/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo;

import com.sap.jdo.sql.catalog.Column;
import com.sap.jdo.sql.catalog.Table;
import com.sap.jdo.sql.mapping.MappingClass;
import com.sap.jdo.sql.mapping.MappingField;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.spi.PersistenceCapable;

public class LockingRequest
implements PersistenceCapable.ObjectIdFieldConsumer {
    private MappingClass _mappingClass;
    private Table[] _tables;
    private String[] _tableNames;
    private Map[] _primaryKeyMapNames;

    public static LockingRequest getLockingRequest(MappingClass mappingClass) {
        return new LockingRequest(mappingClass);
    }

    private LockingRequest(MappingClass mappingClass) {
        this._mappingClass = mappingClass;
        this._tables = mappingClass.getTables();
        this._tableNames = new String[this._tables.length];
        int i = 0;
        while (i < this._tableNames.length) {
            this._tableNames[i] = this._tables[i].getName();
            ++i;
        }
        this._primaryKeyMapNames = new Map[this._tables.length];
        int i2 = 0;
        while (i2 < this._tables.length) {
            this._primaryKeyMapNames[i2] = new HashMap();
            ++i2;
        }
    }

    public String[] getTableNames() {
        return this._tableNames;
    }

    public Map[] getPrimaryKeyMapNames() {
        return this._primaryKeyMapNames;
    }

    private void put(int fieldNumber, Object value) {
        MappingField mappingField = this._mappingClass.getField(fieldNumber);
        int i = 0;
        while (i < this._tables.length) {
            Column[] columns = mappingField.getColumns(this._tables[i]);
            if (columns.length != 1) {
                throw new JDOFatalInternalException("ASSERTION FAILED: number of columns != 1");
            }
            this._primaryKeyMapNames[i].put(columns[0].getName(), value);
            ++i;
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        this.put(fieldNumber, new Boolean(value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        this.put(fieldNumber, new Byte(value));
    }

    public void storeCharField(int fieldNumber, char value) {
        this.put(fieldNumber, new Character(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        this.put(fieldNumber, new Double(value));
    }

    public void storeFloatField(int fieldNumber, float value) {
        this.put(fieldNumber, new Float(value));
    }

    public void storeIntField(int fieldNumber, int value) {
        this.put(fieldNumber, new Integer(value));
    }

    public void storeLongField(int fieldNumber, long value) {
        this.put(fieldNumber, new Long(value));
    }

    public void storeObjectField(int fieldNumber, Object value) {
        this.put(fieldNumber, value);
    }

    public void storeShortField(int fieldNumber, short value) {
        this.put(fieldNumber, new Short(value));
    }

    public void storeStringField(int fieldNumber, String value) {
        this.put(fieldNumber, value);
    }
}

