/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdo;

import com.sap.jdo.LockingInternal;
import com.sap.jdo.LockingRequest;
import com.sap.jdo.PersistenceManagerInternal;
import com.sap.jdo.SAPJDOLockingException;
import com.sap.jdo.SAPStoreManager;
import com.sap.jdo.StoreManagerAdapter;
import com.sap.jdo.jca.cci.SAPJDOConnection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.naming.InitialContext;

public class LockingImpl
implements LockingInternal {
    public static final String TABLE_LOCKING_JNDI_NAME = "TableLocking";
    public static Class __dataLockingClass = null;
    public static Method __lockMethod = null;
    public static Method __unLockMethod = null;
    public static Method __unLockAsynchronousMethod = null;
    public static Method __unLockAllMethod = null;
    public static Method __unLockAllAsynchronousMethod = null;
    public static Method __assertLifetimeMethod = null;
    public static Method __getCurrentOwnerMethod = null;
    public static Throwable __e = null;
    private Object _locking;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;

    public static LockingImpl getInstance() {
        return LockingSingleton.INSTANCE;
    }

    private LockingImpl() {
        try {
            __dataLockingClass = Class.forName("com.sap.engine.services.applocking.TableLocking");
            __lockMethod = __dataLockingClass.getMethod("lock", Byte.TYPE, class$java$sql$Connection == null ? (class$java$sql$Connection = LockingImpl.class$("java.sql.Connection")) : class$java$sql$Connection, class$java$lang$String == null ? (class$java$lang$String = LockingImpl.class$("java.lang.String")) : class$java$lang$String, class$java$util$Map == null ? (class$java$util$Map = LockingImpl.class$("java.util.Map")) : class$java$util$Map, Character.TYPE);
            __unLockMethod = __dataLockingClass.getMethod("unlock", Byte.TYPE, class$java$sql$Connection == null ? (class$java$sql$Connection = LockingImpl.class$("java.sql.Connection")) : class$java$sql$Connection, class$java$lang$String == null ? (class$java$lang$String = LockingImpl.class$("java.lang.String")) : class$java$lang$String, class$java$util$Map == null ? (class$java$util$Map = LockingImpl.class$("java.util.Map")) : class$java$util$Map, Character.TYPE);
            __unLockAsynchronousMethod = __dataLockingClass.getMethod("unlock", Byte.TYPE, class$java$sql$Connection == null ? (class$java$sql$Connection = LockingImpl.class$("java.sql.Connection")) : class$java$sql$Connection, class$java$lang$String == null ? (class$java$lang$String = LockingImpl.class$("java.lang.String")) : class$java$lang$String, class$java$util$Map == null ? (class$java$util$Map = LockingImpl.class$("java.util.Map")) : class$java$util$Map, Character.TYPE, Boolean.TYPE);
            __unLockAllMethod = __dataLockingClass.getMethod("unlockAll", Byte.TYPE);
            __unLockAllAsynchronousMethod = __dataLockingClass.getMethod("unlockAll", Byte.TYPE, Boolean.TYPE);
            __assertLifetimeMethod = __dataLockingClass.getMethod("assertLifetime", Byte.TYPE);
            __getCurrentOwnerMethod = __dataLockingClass.getMethod("getCurrentOwner", Byte.TYPE);
        }
        catch (NoSuchMethodException e) {
            __dataLockingClass = null;
            __e = e;
        }
        catch (ClassNotFoundException e) {
            __dataLockingClass = null;
            __e = e;
        }
        if (__dataLockingClass == null) {
            throw new JDOFatalDataStoreException("locking not defined", __e);
        }
        try {
            this._locking = new InitialContext().lookup(TABLE_LOCKING_JNDI_NAME);
        }
        catch (Exception e) {
            throw new JDOFatalDataStoreException("locking not available", (Throwable)e);
        }
    }

    private SAPStoreManager getSAPStoreManager(PersistenceManager persistenceManager) {
        PersistenceManagerInternal pm = (PersistenceManagerInternal)((SAPJDOConnection)persistenceManager).getPMInternal();
        StoreManagerAdapter sma = (StoreManagerAdapter)pm.getStoreManager();
        SAPStoreManager sm = sma.getSAPStoreManager();
        return sm;
    }

    private void process(Method method, byte lifetime, SAPStoreManager storeManager, Object object, char mode, Boolean asynchronous) {
        Map[] primaryKeyMapNames;
        String[] tableNames;
        LockingRequest lr;
        PersistenceCapable pc = (PersistenceCapable)object;
        Class<?> pcClass = pc.getClass();
        Object oid = pc.jdoGetObjectId();
        LockingRequest lockingRequest = lr = storeManager.getLockingRequest(pc);
        synchronized (lockingRequest) {
            JDOImplHelper.getInstance().copyKeyFieldsFromObjectId(pcClass, (PersistenceCapable.ObjectIdFieldConsumer)lr, oid);
            tableNames = lr.getTableNames();
            primaryKeyMapNames = lr.getPrimaryKeyMapNames();
        }
        try {
            int i = 0;
            while (i < tableNames.length) {
                if (asynchronous == null) {
                    this.invoke(method, new Object[]{new Byte(lifetime), storeManager.getConnection(), tableNames[i], primaryKeyMapNames[i], new Character(mode)});
                } else {
                    this.invoke(method, new Object[]{new Byte(lifetime), storeManager.getConnection(), tableNames[i], primaryKeyMapNames[i], new Character(mode), asynchronous});
                }
                ++i;
            }
        }
        catch (JDOFatalUserException e) {
            throw new JDOFatalUserException("object locked: " + oid, e.getNestedExceptions());
        }
    }

    private Object invoke(Method method, Object[] objects) {
        Object result;
        try {
            result = method.invoke(this._locking, objects);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new SAPJDOLockingException("Lock exception", targetException);
        }
        catch (IllegalAccessException e) {
            throw new JDOFatalInternalException("unexcpected exception occured while calling lock server", (Throwable)e);
        }
        return result;
    }

    public void lock(byte lifetime, PersistenceManager persistenceManager, Object object, char mode) {
        if (persistenceManager == null) {
            throw new JDOUserException("PersistenceManager must not be null");
        }
        this.lock(lifetime, this.getSAPStoreManager(persistenceManager), object, mode);
    }

    public void lock(byte lifetime, SAPStoreManager storeManager, Object object, char mode) {
        this.process(__lockMethod, lifetime, storeManager, object, mode, null);
    }

    public void unlock(byte lifetime, PersistenceManager persistenceManager, Object object, char mode) {
        if (persistenceManager == null) {
            throw new JDOUserException("PersistenceManager must not be null");
        }
        this.unlock(lifetime, this.getSAPStoreManager(persistenceManager), object, mode);
    }

    public void unlock(byte lifetime, PersistenceManager persistenceManager, Object object, char mode, boolean asynchronous) {
        if (persistenceManager == null) {
            throw new JDOUserException("PersistenceManager must not be null");
        }
        this.unlock(lifetime, this.getSAPStoreManager(persistenceManager), object, mode, asynchronous);
    }

    public void unlock(byte lifetime, SAPStoreManager storeManager, Object object, char mode) {
        this.process(__unLockMethod, lifetime, storeManager, object, mode, null);
    }

    public void unlock(byte lifetime, SAPStoreManager storeManager, Object object, char mode, boolean asynchronous) {
        this.process(__unLockMethod, lifetime, storeManager, object, mode, new Boolean(asynchronous));
    }

    public void unlockAll(byte lifetime) {
        this.invoke(__unLockAllMethod, new Object[]{new Byte(lifetime)});
    }

    public void unlockAll(byte lifetime, boolean asynchronous) {
        this.invoke(__unLockAllAsynchronousMethod, new Object[]{new Byte(lifetime), new Boolean(asynchronous)});
    }

    public void assertLifetime(byte lifetime) {
        this.invoke(__assertLifetimeMethod, new Object[]{new Byte(lifetime)});
    }

    public String getCurrentOwner(byte lifetime) {
        return (String)this.invoke(__getCurrentOwnerMethod, new Object[]{new Byte(lifetime)});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LockingSingleton {
        static final LockingImpl INSTANCE = new LockingImpl();

        private LockingSingleton() {
        }
    }
}

