/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbstool.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarFileClassLoader
extends ClassLoader {
    private String[] jarFiles;
    private HashMap classCache;
    private HashMap domainCache;

    private JarFileClassLoader() {
    }

    public JarFileClassLoader(String[] jarFiles) {
        this.classCache = new HashMap();
        this.domainCache = new HashMap();
        this.jarFiles = jarFiles;
        if (jarFiles == null) {
            throw new IllegalArgumentException("Null has been passed as array of jar file names.");
        }
    }

    public URL findResource(String name) {
        String filename = this.findJarFileOfResource(name);
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        URL u = null;
        try {
            u = f.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
        String fileURL = u.toExternalForm();
        String newURL = "jar:" + fileURL;
        newURL = name.startsWith("/") ? newURL + "!" + name : newURL + "!/" + name;
        try {
            return new URL(newURL);
        }
        catch (MalformedURLException e1) {
            return null;
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.classCache.get(name);
        if (c != null) {
            return c;
        }
        c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findSystemClass(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (c == null) {
            String filename = name.replace('.', '/') + ".class";
            try {
                byte[] data = this.loadClassData(filename);
                if (data == null) {
                    throw new ClassNotFoundException("Received null as class data for class " + name);
                }
                String jarFile = this.findJarFileOfResource(filename);
                ProtectionDomain domain = null;
                if (jarFile != null) {
                    File f = new File(jarFile);
                    domain = this.createProtectionDomain(f);
                }
                if ((c = this.defineClass(name, data, 0, data.length, domain)) == null) {
                    throw new ClassNotFoundException("Definition of class " + name + "failed");
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException("I/O error when reading file '" + filename + "':" + e.getMessage());
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        this.classCache.put(name, c);
        return c;
    }

    private ProtectionDomain createProtectionDomain(File file) {
        if (file == null) {
            return null;
        }
        ProtectionDomain domain = null;
        domain = (ProtectionDomain)this.domainCache.get(file);
        if (domain != null) {
            return domain;
        }
        Policy policy = Policy.getPolicy();
        CodeSource codeSource = null;
        PermissionCollection pc = null;
        try {
            codeSource = new CodeSource(file.toURL(), null);
        }
        catch (MalformedURLException e) {
            return null;
        }
        pc = policy.getPermissions(codeSource);
        domain = new ProtectionDomain(codeSource, pc);
        this.domainCache.put(file, domain);
        return domain;
    }

    private byte[] loadClassData(String className) throws IOException {
        if (className == null) {
            return null;
        }
        String jarFile = this.findJarFileOfResource(className);
        if (jarFile == null) {
            throw new IOException("Cannot find a jar file that contains class " + className);
        }
        File f = new File(jarFile);
        ZipFile jf = new ZipFile(f);
        ZipEntry e = jf.getEntry(className);
        long l = e.getSize();
        InputStream in = jf.getInputStream(e);
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Class file size of class " + className + " is greater than" + " the maximum integer value " + Integer.MAX_VALUE);
        }
        int size = (int)l;
        if (size == -1) {
            throw new IOException("Cannot determine size of zip file entry for class " + className);
        }
        int currentPosition = 0;
        int len = 0;
        byte[] buffer = new byte[size];
        while ((len = in.read(buffer, currentPosition, size - currentPosition)) > 0) {
            currentPosition += len;
        }
        in.close();
        return buffer;
    }

    String findJarFileOfResource(String name) {
        int i = 0;
        while (i < this.jarFiles.length) {
            File f;
            String filename = this.jarFiles[i];
            if (filename != null && (f = new File(filename)).exists()) {
                try {
                    ZipFile jf = new ZipFile(f);
                    ZipEntry e = jf.getEntry(name);
                    if (e != null) {
                        return filename;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    public String[] getJarFiles() {
        return this.jarFiles;
    }

    public void setZipFiles(String[] jarFiles) {
        this.jarFiles = jarFiles;
        if (jarFiles == null) {
            throw new IllegalArgumentException("Null has been passed as array of jar file names.");
        }
    }
}

