/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbstool.startup;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

public class FileClassLoader
extends ClassLoader {
    private String rootDirectory;
    private HashMap classCache;

    private FileClassLoader() {
    }

    public FileClassLoader(String rootDir) {
        this.classCache = new HashMap();
        this.rootDirectory = rootDir;
        if (this.rootDirectory == null) {
            throw new IllegalArgumentException("Null has been passed as root directory");
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.classCache.get(name);
        if (c != null) {
            return c;
        }
        c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findSystemClass(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (c == null) {
            String filename = name.replace('.', File.separatorChar) + ".class";
            try {
                byte[] data = this.loadClassData(filename);
                if (data == null) {
                    throw new ClassNotFoundException("Received null as class data for class " + name);
                }
                c = this.defineClass(name, data, 0, data.length);
                if (c == null) {
                    throw new ClassNotFoundException("Definition of class " + name + "failed");
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException("I/O error when reading file '" + filename + "':" + e.getMessage());
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        this.classCache.put(name, c);
        return c;
    }

    private byte[] loadClassData(String filename) throws IOException {
        File f = new File(this.rootDirectory, filename);
        if (!f.exists()) {
            throw new IOException("File '" + f.getAbsolutePath() + "' does not exist.");
        }
        if (f.length() > Integer.MAX_VALUE) {
            throw new IOException("Size of file '" + f.getAbsolutePath() + "' is greater than" + " the maximum integer value " + Integer.MAX_VALUE);
        }
        int size = (int)f.length();
        byte[] buffer = new byte[size];
        FileInputStream fis = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(fis);
        dis.readFully(buffer);
        dis.close();
        return buffer;
    }

    public String getRootDir() {
        return this.rootDirectory;
    }

    public void setRootDir(String rootDir) {
        this.rootDirectory = rootDir;
        if (this.rootDirectory == null) {
            throw new IllegalArgumentException("Null has been passed as root directory");
        }
    }
}

