/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.ant;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.LocalTransaction;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MMRGenerate
extends Task {
    protected static final Location loc = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$ant$MMRGenerate == null ? (class$com$sap$ip$mmr$ant$MMRGenerate = MMRGenerate.class$("com.sap.ip.mmr.ant.MMRGenerate")) : class$com$sap$ip$mmr$ant$MMRGenerate);
    private String sourcePath;
    private String destPath;
    private String classNameOfTask;
    private String classpath;
    private String tempPath;
    private boolean verbose = false;
    static /* synthetic */ Class class$com$sap$ip$mmr$ant$MMRGenerate;
    static /* synthetic */ Class class$com$sap$ip$mmr$m2layer$tasks$TaskGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        File fIndex;
        File fileDest;
        if (this.sourcePath == null) {
            this.log("source path not specified");
            return;
        }
        if (this.destPath == null) {
            this.log("destination path not specified; using user temp directory instead");
        }
        if (this.verbose) {
            this.log("Connecting Model Repository ...");
        }
        if (!(fileDest = new File(this.destPath)).exists()) {
            this.log("The destination path doesn't exist: " + this.destPath);
            this.log("done.");
            return;
        }
        File fileSource = new File(this.sourcePath);
        if (!fileSource.exists()) {
            this.log("The source path doesn't exist: " + this.sourcePath);
            this.log("done.");
            return;
        }
        if (fileSource.isFile()) {
            this.classpath = this.classpath == null ? this.sourcePath : (this.classpath.length() < 1 ? this.sourcePath : this.classpath + Utilities.SystemPathSeparator + this.sourcePath);
        } else if ((class$com$sap$ip$mmr$m2layer$tasks$TaskGenerator == null ? (class$com$sap$ip$mmr$m2layer$tasks$TaskGenerator = MMRGenerate.class$("com.sap.ip.mmr.m2layer.tasks.TaskGenerator")) : class$com$sap$ip$mmr$m2layer$tasks$TaskGenerator).getName().compareTo(this.getClassNameOfTask()) == 0 && !(fIndex = new File(fileSource.getAbsolutePath() + Utilities.SystemFileSeparator + "MMR_M2" + Utilities.SystemFileSeparator + "Model")).exists()) {
            this.log("The source path doesn't contain MMR_M2 data (Model folder)");
            this.log("done.");
            return;
        }
        try {
            RepositoryServer.getRepositoryServer().finalizer();
        }
        catch (BaseRuntimeException e) {
            this.log(e.toString());
        }
        catch (BaseException e) {
            this.log(e.toString());
        }
        Log log = Utilities.getUtilities().getConsoleLog();
        if (this.verbose) {
            log.setEffectiveSeverity(300);
        } else {
            log.setEffectiveSeverity(400);
        }
        Location.getLocation((String)"com.sap.ip.mmr").addLog(log);
        if (this.verbose) {
            Location.getLocation((String)"com.sap.ip.mmr").setEffectiveSeverity(300);
        }
        this.log("Created log with severity: " + log.getEffectiveSeverity());
        try {
            Connection cx;
            block29: {
                LocalTransaction lt;
                block30: {
                    ConnectionSpec cxs = new ConnectionSpec();
                    Workspace wsSource = new Workspace(fileSource.getAbsolutePath());
                    wsSource.setPath(fileSource.getAbsolutePath());
                    wsSource.getProperties().put("MMR_USE_CACHE", Boolean.FALSE);
                    Workspace wsDest = new Workspace(fileDest.getAbsolutePath());
                    wsDest.setPath(fileDest.getAbsolutePath());
                    wsDest.getProperties().put("MMR_USE_CACHE", Boolean.FALSE);
                    cxs.getWorkspacesM1().add(wsSource);
                    cxs.getWorkspacesM2().add(wsSource);
                    cxs.setLog(log);
                    String pathTmp = this.getTempPath();
                    if (pathTmp != null) {
                        cxs.getProperties().put("tempDir", pathTmp);
                    }
                    cxs.getProperties().put("MMR_USE_CACHE", Boolean.FALSE);
                    this.log("Prepared MMR connection specification");
                    ConnectionFactory cxf = new ConnectionFactory();
                    this.log("Created MMR connection factory");
                    cx = cxf.getConnection((javax.resource.cci.ConnectionSpec)cxs);
                    this.log("Created MMR connection");
                    cxs.getWorkspacesM1().addAll(cx.getWorkspacesAvailableM1());
                    cxs.getWorkspacesM2().addAll(cx.getWorkspacesAvailableM2());
                    lt = (LocalTransaction)cx.getLocalTransaction();
                    try {
                        try {
                            lt.begin();
                            if (this.classNameOfTask == null || this.classNameOfTask.length() < 1) {
                                List paths = Utilities.getUtilities().splitClassPath(this.classpath);
                                Iterator ip = paths.iterator();
                                while (ip.hasNext()) {
                                    String path = (String)ip.next();
                                    Workspace w = new Workspace(path);
                                    w.setPath(path);
                                    w.setReadOnly(true);
                                    RepositoryServer.getRepositoryServer().registerWorkspace(w, 2);
                                    cxs.getWorkspacesM2().add(w);
                                }
                                this.log("Update type information ...");
                                LinkedList<String> mofIds = new LinkedList<String>();
                                mofIds.add("Dummy");
                                cx.selectM1(mofIds, false);
                                this.log("Update search data ...");
                                QueryFilters qf = new QueryFilters();
                                cx.queryM1(null, qf, false);
                            } else {
                                this.log("Update search data ...");
                                QueryFilters qf = new QueryFilters();
                                cx.queryM2(null, qf, false);
                                this.log("Running task: " + this.getClassNameOfTask() + " ...");
                                HashMap<String, String> p = new HashMap<String, String>();
                                p.put("srcpath", this.sourcePath);
                                p.put("dstpath", this.destPath);
                                p.put("taskClassName", this.classNameOfTask);
                                p.put("classpath", this.classpath);
                                cx.runTask(this.classNameOfTask, p);
                                this.log("Finished task successfully");
                            }
                        }
                        catch (Exception e) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            PrintStream ps = new PrintStream(baos);
                            e.printStackTrace(ps);
                            this.log(baos.toString());
                            Repository.category.errorT(loc, e.toString());
                            Object var16_24 = null;
                            if (this.verbose) {
                                this.log("Commit ...");
                            }
                            lt.commit();
                            this.log("Commit done");
                            break block29;
                        }
                        Object var16_23 = null;
                        if (!this.verbose) break block30;
                    }
                    catch (Throwable throwable) {
                        Object var16_25 = null;
                        if (this.verbose) {
                            this.log("Commit ...");
                        }
                        lt.commit();
                        this.log("Commit done");
                        throw throwable;
                    }
                    this.log("Commit ...");
                }
                lt.commit();
                this.log("Commit done");
            }
            if (this.verbose) {
                this.log("Close connection to Metamodel Repository ...");
            }
            cx.close();
            this.log("Connection to MMR closed");
        }
        catch (Exception e) {
            Repository.category.errorT(loc, e.toString());
        }
        if (this.verbose) {
            this.log("done.");
        }
    }

    public String getDestPath() {
        return this.destPath;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getClassNameOfTask() {
        return this.classNameOfTask;
    }

    public void setClassNameOfTask(String classNameOfTask) {
        this.classNameOfTask = classNameOfTask;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public void setTempPath(String string) {
        this.tempPath = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

