/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.generic.api;

import java.util.ArrayList;

public class SortingCriteria {
    public static final boolean ASCENDING = true;
    public static final boolean DESCENDING = false;
    private ArrayList sortingCriteria = new ArrayList();

    public int size() {
        return this.sortingCriteria.size();
    }

    public String getFieldName(int i) {
        SortingCriterion sortingCriterion = (SortingCriterion)this.sortingCriteria.get(i);
        return sortingCriterion.fieldName;
    }

    public boolean getDirection(int i) {
        SortingCriterion sortingCriterion = (SortingCriterion)this.sortingCriteria.get(i);
        return sortingCriterion.direction;
    }

    public String getComparisonRule(int i) {
        return null;
    }

    public void addCriterion(String fieldName) {
        this.addCriterion(fieldName, true);
    }

    public void addCriterion(String fieldName, boolean ascending) {
        if (fieldName == null || fieldName.equals("")) {
            throw new IllegalArgumentException("fieldName is 'null' or empty");
        }
        SortingCriterion sortingCriterion = new SortingCriterion(fieldName, ascending);
        this.sortingCriteria.add(sortingCriterion);
    }

    public void removeCriterion(int i) {
        this.sortingCriteria.remove(i);
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <SortingCriteria>").append(nl);
        int i = 0;
        while (i < this.size()) {
            SortingCriterion sort = (SortingCriterion)this.sortingCriteria.get(i);
            String dir = "ASCENDING";
            if (!sort.direction) {
                dir = "DESCENDING";
            }
            buf.append("    <FieldName = " + sort.fieldName + " / " + dir + " >").append(nl);
            ++i;
        }
        buf.append("  </SortingCriteria>").append(nl);
        return buf.toString();
    }

    private class SortingCriterion {
        private String fieldName;
        private boolean direction;

        private SortingCriterion(String fieldName, boolean direction) {
            this.fieldName = fieldName;
            this.direction = direction;
        }
    }
}

