/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.util;

import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.ExchangeProfile;
import com.sap.rprof.dbprofiles.RemoteProfile;
import com.sap.rprof.dbprofiles.util.CmdlineUtility;

public class WriteContentToFile
extends CmdlineUtility {
    public static void main(String[] args) {
        ExchangeProfile profileFromFile = null;
        ExchangeProfile profileFromDb = null;
        String transferOption = "replace";
        if (args.length == 9) {
            transferOption = args[8];
        } else if (args.length != 8) {
            CmdlineUtility.printUsageAndArguments("Usage: WriteContentToFile <client> <user> <password> <language> <hostname> <systemnumber> <filepath> <filename> [merge/replace]", args);
            System.exit(1);
        }
        String client = args[0];
        String user = args[1];
        String password = args[2];
        String language = args[3];
        String hostname = args[4];
        String system = args[5];
        String pathname = args[6];
        String filename = args[7];
        try {
            RemoteProfile.setAbapConnect(client, user, password, language, hostname, system);
            profileFromDb = ExchangeProfile.getExchangeProfile();
            if (transferOption.equals("merge")) {
                profileFromFile = ExchangeProfile.getExchangeProfileFromFile(pathname, filename);
                profileFromFile.mergeContent(profileFromDb);
                if (profileFromFile == null || !profileFromFile.writeXMLToFile(pathname, filename)) {
                    throw new DBException("Failed to write content to file (" + pathname + "/" + filename);
                }
            } else if (!profileFromDb.writeXMLToFile(pathname, filename)) {
                throw new DBException("Failed to write content to file (" + pathname + "/" + filename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

