/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.util;

import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.RemoteProfile;
import com.sap.rprof.dbprofiles.util.CmdlineUtility;
import java.io.File;

public class TransferToFile
extends CmdlineUtility {
    String myClient;
    String myUser;
    String myPassword;
    String myLanguage;
    String myHostname;
    String mySysnr;
    String myFsPath;
    String transferMode;

    public TransferToFile(String client, String user, String password, String language, String hostname, String sysnr, String fspath) {
        this.myClient = client;
        this.myUser = user;
        this.myPassword = password;
        this.myLanguage = language;
        this.myHostname = hostname;
        this.mySysnr = sysnr;
        this.myFsPath = fspath;
    }

    public static void main(String[] args) {
        String transferOption = "replace";
        if (args.length == 10) {
            transferOption = args[9];
        } else if (args.length != 9) {
            CmdlineUtility.printUsageAndArguments("Usage: TransferToFile <client> <user> <password> <language> <hostname> <systemnumber> <application> <filename> <resultdir> [merge/replace]", args);
            System.exit(1);
        }
        TransferToFile myVehicle = new TransferToFile(args[0], args[1], args[2], args[3], args[4], args[5], args[8]);
        myVehicle.transferMode = transferOption;
        try {
            if (!myVehicle.transferProfile(args[6], args[7])) {
                System.out.println("ERROR: Unable to write result file, see log for details.");
            } else {
                System.out.println("Profile written to " + new File(args[8], args[7]).toString());
            }
        }
        catch (DBException dbe) {
            System.out.println("ERROR: Unable to read source or target profile.");
            dbe.printStackTrace();
        }
    }

    public boolean transferProfile(String applname, String filename) throws DBException {
        RemoteProfile.setAbapConnect(this.myClient, this.myUser, this.myPassword, this.myLanguage, this.myHostname, this.mySysnr);
        RemoteProfile profileFromDb = RemoteProfile.getRemoteProfile(applname, filename);
        if (this.transferMode != null && this.transferMode.equals("merge")) {
            try {
                RemoteProfile profileFromFile = RemoteProfile.getRemoteProfileFromFile(applname, filename, this.myFsPath, filename);
                profileFromFile.mergeContent(profileFromDb);
                return profileFromFile.writeXMLToFile(this.myFsPath, filename);
            }
            catch (AccessException ace) {
                ace.printStackTrace();
                return false;
            }
        }
        return profileFromDb.writeXMLToFile(this.myFsPath, filename);
    }
}

