/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.util;

import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.RemoteProfile;
import com.sap.rprof.dbprofiles.util.CmdlineUtility;

public class TransferToDatabase
extends CmdlineUtility {
    String myClient;
    String myUser;
    String myPassword;
    String myLanguage;
    String myHostname;
    String mySysnr;
    String myFsPath;
    String transferMode;

    public TransferToDatabase(String client, String user, String password, String language, String hostname, String sysnr, String fspath) {
        this.myClient = client;
        this.myUser = user;
        this.myPassword = password;
        this.myLanguage = language;
        this.myHostname = hostname;
        this.mySysnr = sysnr;
        this.myFsPath = fspath;
    }

    public static void main(String[] args) {
        String transferOption = "replace";
        if (args.length == 10) {
            transferOption = args[9];
        } else if (args.length != 9) {
            CmdlineUtility.printUsageAndArguments("Usage: TransferToDatabase <client> <user> <password> <language> <hostname> <systemnumber> <sourcedir> <application> <filename> [merge/replace]", args);
            System.exit(1);
        }
        TransferToDatabase myVehicle = new TransferToDatabase(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
        myVehicle.transferMode = transferOption;
        try {
            myVehicle.transferProfile(args[7], args[8]);
            System.out.println("Profile " + args[7] + ", " + args[8] + " written to database");
        }
        catch (DBException dbe) {
            System.out.println("ERROR: Unable to read or write profile.");
            dbe.printStackTrace();
        }
        catch (AccessException ace) {
            System.out.println("ERROR: Unable to lock profile on DB.");
            ace.printStackTrace();
        }
    }

    public void transferProfile(String applname, String filename) throws DBException, AccessException {
        RemoteProfile.setAbapConnect(this.myClient, this.myUser, this.myPassword, this.myLanguage, this.myHostname, this.mySysnr);
        RemoteProfile profileFromFile = RemoteProfile.getRemoteProfileFromFile(applname, filename, this.myFsPath, filename);
        RemoteProfile profileFromDb = RemoteProfile.getRemoteProfileForUpdate(applname, filename);
        try {
            if (this.transferMode != null && this.transferMode.equals("merge")) {
                profileFromDb.mergeContent(profileFromFile);
            } else {
                profileFromDb.substituteContent(profileFromFile);
            }
            profileFromDb.releaseChanges();
        }
        catch (AccessException ace) {
            profileFromDb.revertChanges();
            throw ace;
        }
        catch (DBException dbe) {
            profileFromDb.revertChanges();
            throw dbe;
        }
    }
}

