/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.util;

import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.ExchangeProfile;
import com.sap.rprof.dbprofiles.util.CmdlineUtility;

public class SetParameterInTemplate
extends CmdlineUtility {
    public static void main(String[] args) {
        ExchangeProfile profile = null;
        if (args.length < 5 || args.length % 3 != 2) {
            CmdlineUtility.printUsageAndArguments("Usage: SetParameterInTemplate <filepath> <filename> [<nameOfSection> <nameOfParam2Set> <valueOfParam2Set>]+", args);
            System.exit(1);
        }
        String filepath = args[0];
        String filename = args[1];
        int nextTripleStart = 2;
        try {
            profile = ExchangeProfile.getExchangeProfileFromFile(filepath, filename);
        }
        catch (DBException e) {
            System.out.println("*** Failed to get remote profile from file ***");
            System.exit(1);
        }
        while (nextTripleStart < args.length) {
            String section = args[nextTripleStart];
            String param = args[nextTripleStart + 1];
            String value = args[nextTripleStart + 2];
            nextTripleStart += 3;
            try {
                profile.setParameter(section, param, value);
            }
            catch (AccessException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        profile.writeXMLToFile(filepath, filename);
    }
}

