/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.util;

import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.ProfileDestinationStore;
import com.sap.rprof.dbprofiles.log.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SecureStoreAccess {
    static final String SECURE_STORE_JNDI_NAME = "tc~sec~securestorage~service";
    static final String SECSTORE_RTI_JAVA_CLASS_NAME = "com.sap.security.core.server.securestorage.SecureStorageRuntimeInterface";
    static final String SECSTORE_SFR_JAVA_CLASS_NAME = "com.sap.security.core.server.securestorage.SecureStorageServiceFrame";
    static final String SECSTORE_CCI_JAVA_CLASS_NAME = "com.sap.security.core.server.securestorage.remote.RemoteSecureStorageClientContextInterface";
    static final String SECSTORE_SFR_APP_FIELD_NAME = "CLIENT_TYPE_WEB_APPLICATION";
    static final String SECSTORE_CC_JAVA_METHOD_NAME = "getSecureStorageClientContext";
    static final String SECSTORE_RO_JAVA_METHOD_NAME = "retrieveObject";
    static final String SECSTORE_ST_JAVA_METHOD_NAME = "storeObject";
    static final String SECSTORE_RM_JAVA_METHOD_NAME = "deleteObject";
    static final String SECSTORE_CONNECT_OBJ_ALIAS = "RprofDestination";
    private static final Logger logger = Logger.getLogger((class$com$sap$rprof$dbprofiles$util$SecureStoreAccess == null ? (class$com$sap$rprof$dbprofiles$util$SecureStoreAccess = SecureStoreAccess.class$("com.sap.rprof.dbprofiles.util.SecureStoreAccess")) : class$com$sap$rprof$dbprofiles$util$SecureStoreAccess).getName());
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$util$SecureStoreAccess;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Serializable;

    private SecureStoreAccess() {
    }

    public static ProfileDestinationStore loadConfigFromSecureStore() throws AccessException {
        ClassLoader saveLoader;
        ProfileDestinationStore result;
        block16: {
            Class<?> secureStoreSFr;
            Class<?> secureStoreCcI;
            Class<?> secureStoreRtI;
            String currentMethodName = "none";
            result = null;
            try {
                secureStoreRtI = Class.forName(SECSTORE_RTI_JAVA_CLASS_NAME);
                secureStoreCcI = Class.forName(SECSTORE_CCI_JAVA_CLASS_NAME);
                secureStoreSFr = Class.forName(SECSTORE_SFR_JAVA_CLASS_NAME);
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
            saveLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$rprof$dbprofiles$util$SecureStoreAccess == null ? (class$com$sap$rprof$dbprofiles$util$SecureStoreAccess = SecureStoreAccess.class$("com.sap.rprof.dbprofiles.util.SecureStoreAccess")) : class$com$sap$rprof$dbprofiles$util$SecureStoreAccess).getClassLoader());
            try {
                try {
                    InitialContext initialContext = new InitialContext();
                    Object secureStoreClientObj = initialContext.lookup(SECURE_STORE_JNDI_NAME);
                    if (secureStoreRtI.isInstance(secureStoreClientObj)) {
                        currentMethodName = SECSTORE_CC_JAVA_METHOD_NAME;
                        Object secureStoreContextObject = SecureStoreAccess.getSecureStoreContextObject(secureStoreSFr, secureStoreRtI, secureStoreClientObj);
                        Method retObjMethod = secureStoreCcI.getDeclaredMethod(SECSTORE_RO_JAVA_METHOD_NAME, class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
                        currentMethodName = SECSTORE_RO_JAVA_METHOD_NAME;
                        Object secureStoreResultObject = null;
                        try {
                            secureStoreResultObject = retObjMethod.invoke(secureStoreContextObject, SECSTORE_CONNECT_OBJ_ALIAS);
                        }
                        catch (InvocationTargetException iteore) {
                            Throwable cft = iteore.getTargetException();
                            logger.debug("Error during read access to secure store, method = " + currentMethodName + ", message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)");
                            ProfileDestinationStore profileDestinationStore = null;
                            Object var15_21 = null;
                            Thread.currentThread().setContextClassLoader(saveLoader);
                            return profileDestinationStore;
                        }
                        if (secureStoreResultObject == null) {
                            logger.debug("Null returned by read access to secure store, method = " + currentMethodName);
                            ProfileDestinationStore profileDestinationStore = null;
                            Object var15_22 = null;
                            Thread.currentThread().setContextClassLoader(saveLoader);
                            return profileDestinationStore;
                        }
                        if (secureStoreResultObject instanceof ProfileDestinationStore) {
                            result = (ProfileDestinationStore)secureStoreResultObject;
                            break block16;
                        }
                        logger.error("Invalid object retrieved from secure store, class = \"" + secureStoreResultObject.getClass().getName() + "\", must be \"HttpDestinationStore\". Re-enter the profile destination" + " to re-write the secure store object.");
                        throw new AccessException("Invalid object retrieved from secure store");
                    }
                    logger.debug("JNDI lookup failed, secure storage context does not fit; class = " + secureStoreClientObj.getClass().getName() + " -> secure store version mismatch?");
                    throw new AccessException("secure storage context does not fit");
                }
                catch (NamingException ne) {
                    logger.debug("JNDI lookup failed; secure store service not started?", ne);
                    throw new AccessException(ne);
                }
                catch (IllegalAccessException iae) {
                    logger.error("No permission to read from secure store. Check the grantsin the secure store service of the J2EE engine.", iae);
                    throw new AccessException(iae);
                }
                catch (InvocationTargetException ite) {
                    Throwable cft = ite.getTargetException();
                    logger.warning("Error during read access to secure store, method = " + currentMethodName + ", message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)." + " The error can be ignored, if no profile destinations have been configured so far.", cft);
                    if (cft != null && cft instanceof Exception) {
                        throw new AccessException((Exception)cft);
                    }
                    throw new AccessException(ite);
                }
                catch (Exception ore) {
                    if (ore instanceof AccessException) {
                        throw (AccessException)ore;
                    }
                    logger.error("Unspecific error during read access to secure store. Try to repeat the activity and check the dbprofiles and Secure Store log", ore);
                    throw new AccessException(ore);
                }
            }
            catch (Throwable throwable) {
                Object var15_24 = null;
                Thread.currentThread().setContextClassLoader(saveLoader);
                throw throwable;
            }
        }
        Object var15_23 = null;
        Thread.currentThread().setContextClassLoader(saveLoader);
        return result;
    }

    public static void storeConfigInSecureStore(ProfileDestinationStore destinations) throws AccessException {
        Class<?> secureStoreSFr;
        Class<?> secureStoreCcI;
        Class<?> secureStoreRtI;
        String currentMethodName = "none";
        try {
            secureStoreRtI = Class.forName(SECSTORE_RTI_JAVA_CLASS_NAME);
            secureStoreCcI = Class.forName(SECSTORE_CCI_JAVA_CLASS_NAME);
            secureStoreSFr = Class.forName(SECSTORE_SFR_JAVA_CLASS_NAME);
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Secure store service not available. Check the status of the secure store J2EE service.", cnfe);
            throw new AccessException("Secure store service not available");
        }
        ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((class$com$sap$rprof$dbprofiles$util$SecureStoreAccess == null ? (class$com$sap$rprof$dbprofiles$util$SecureStoreAccess = SecureStoreAccess.class$("com.sap.rprof.dbprofiles.util.SecureStoreAccess")) : class$com$sap$rprof$dbprofiles$util$SecureStoreAccess).getClassLoader());
        try {
            try {
                InitialContext initialContext = new InitialContext();
                Object secureStoreClientObj = initialContext.lookup(SECURE_STORE_JNDI_NAME);
                if (secureStoreRtI.isInstance(secureStoreClientObj)) {
                    currentMethodName = SECSTORE_CC_JAVA_METHOD_NAME;
                    Object secureStoreContextObject = SecureStoreAccess.getSecureStoreContextObject(secureStoreSFr, secureStoreRtI, secureStoreClientObj);
                    currentMethodName = SECSTORE_RM_JAVA_METHOD_NAME;
                    SecureStoreAccess.cleanConfigInSecureStore(secureStoreCcI, secureStoreContextObject);
                    if (destinations != null) {
                        Method storeObjMethod = secureStoreCcI.getDeclaredMethod(SECSTORE_ST_JAVA_METHOD_NAME, class$java$io$Serializable == null ? (class$java$io$Serializable = SecureStoreAccess.class$("java.io.Serializable")) : class$java$io$Serializable, class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
                        currentMethodName = SECSTORE_ST_JAVA_METHOD_NAME;
                        storeObjMethod.invoke(secureStoreContextObject, destinations, SECSTORE_CONNECT_OBJ_ALIAS);
                    }
                } else {
                    logger.error("Secure store service lookup failed. This may be caused by a secure store version mismatch. Check the versions of your software components and deploy the latest Support Packages, if not yet installed.");
                    throw new AccessException("JNDI lookup failed; secure store version mismatch");
                }
                Object var11_16 = null;
                Thread.currentThread().setContextClassLoader(saveLoader);
            }
            catch (NamingException ne) {
                logger.error("Secure store service lookup failed. This may be caused by a stopped secure store service. Check the status of the secure store J2EE service.", ne);
                throw new AccessException(ne);
            }
            catch (IllegalAccessException iae) {
                logger.error("No permission to write to the secure store. Check the grantsin the secure store service of the J2EE engine.", iae);
                throw new AccessException(iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cft = ite.getTargetException();
                logger.error("Error during write access to secure store, method = " + currentMethodName + ", message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)." + " Try to repeat the activity, which caused this error.", cft);
                if (cft != null && cft instanceof Exception) {
                    throw new AccessException((Exception)cft);
                }
                throw new AccessException(ite);
            }
            catch (Exception ore) {
                if (ore instanceof AccessException) {
                    throw (AccessException)ore;
                }
                logger.error("Unspecific error during write access to secure store. Try to repeat the activity and check the dbprofiles and Secure Store log", ore);
                throw new AccessException(ore);
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            Thread.currentThread().setContextClassLoader(saveLoader);
            throw throwable;
        }
    }

    private static Object getSecureStoreContextObject(Class secureStoreSFr, Class secureStoreRtI, Object secureStoreClientObj) throws IllegalAccessException, InvocationTargetException, AccessException {
        try {
            Method getCcIMethod = secureStoreRtI.getDeclaredMethod(SECSTORE_CC_JAVA_METHOD_NAME, class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
            Object[] cciParams = new Object[]{SECSTORE_CONNECT_OBJ_ALIAS};
            return getCcIMethod.invoke(secureStoreClientObj, cciParams);
        }
        catch (NoSuchMethodException nsme) {
            try {
                Field webAppConst = secureStoreSFr.getDeclaredField(SECSTORE_SFR_APP_FIELD_NAME);
                int webAppType = webAppConst.getInt(secureStoreSFr);
                Method getCcIMethod = secureStoreRtI.getDeclaredMethod(SECSTORE_CC_JAVA_METHOD_NAME, class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                Object[] cciParams = new Object[]{SECSTORE_CONNECT_OBJ_ALIAS, new Integer(webAppType)};
                return getCcIMethod.invoke(secureStoreClientObj, cciParams);
            }
            catch (NoSuchMethodException nsme2) {
                throw new AccessException("Secure Storage method getSecureStorageClientContext not found");
            }
            catch (NoSuchFieldException nsfe) {
                throw new AccessException("Secure Storage method getSecureStorageClientContext not found");
            }
        }
    }

    private static void cleanConfigInSecureStore(Class secureStoreCcI, Object secureStoreContextObject) {
        try {
            Method deleteObjMethod = secureStoreCcI.getDeclaredMethod(SECSTORE_RM_JAVA_METHOD_NAME, class$java$lang$String == null ? (class$java$lang$String = SecureStoreAccess.class$("java.lang.String")) : class$java$lang$String);
            deleteObjMethod.invoke(secureStoreContextObject, SECSTORE_CONNECT_OBJ_ALIAS);
        }
        catch (IllegalAccessException iae) {
            logger.warning("No permission to delete object in secure store. Check the grantsin the secure store service of the J2EE engine.", iae);
            return;
        }
        catch (InvocationTargetException ite) {
            Throwable cft = ite.getTargetException();
            logger.debug("Failed to delete object in secure store, message = " + cft.getMessage() + " (see secure storage log for a detailed analysis)");
            return;
        }
        catch (Exception ore) {
            logger.warning("Unspecific error during delete in secure store. Try to repeat the activity and check the dbprofiles and Secure Store log", ore);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

