/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.util;

import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.ProfileDestinationStore;
import com.sap.rprof.dbprofiles.log.Logger;
import com.sap.rprof.dbprofiles.util.SecureStoreAccess;
import com.sap.rprof.dbprofiles.util.StreamedGenericConfigServlet;
import java.io.IOException;
import java.util.Properties;

public abstract class GenericConfigServlet
extends StreamedGenericConfigServlet {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$rprof$dbprofiles$util$GenericConfigServlet == null ? (class$com$sap$rprof$dbprofiles$util$GenericConfigServlet = GenericConfigServlet.class$("com.sap.rprof.dbprofiles.util.GenericConfigServlet")) : class$com$sap$rprof$dbprofiles$util$GenericConfigServlet).getName());
    private static final String ERR_RESULT_CODE = "ERR";
    private static final String OK_RESULT_CODE = "OK";
    private static final String REMOVE_PARAM_NAME = "removeConfiguration";
    private static final String SERVER_LOG_HINT = " (see server log for details)";
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$util$GenericConfigServlet;

    protected void servePost() {
        this.servePostForSecureStorage();
    }

    protected void serveGet() {
        this.servePostForSecureStorage();
    }

    protected void servePostForSecureStorage() {
        String aResultCode = OK_RESULT_CODE;
        String aResultMessage = "";
        if (!this.isRequiredCharSet("ISO-8859-1")) {
            aResultMessage = "Wrong character set found in secure storage request";
            myLogger.error(aResultMessage);
            aResultCode = ERR_RESULT_CODE;
        } else {
            Properties connProps = new Properties();
            try {
                connProps.load(this.inputStream);
            }
            catch (IOException ioe) {
                aResultMessage = "Unable to load properties from secure storage request";
                myLogger.error(aResultMessage, ioe);
                aResultCode = ERR_RESULT_CODE;
            }
            String removeRequest = connProps.getProperty(REMOVE_PARAM_NAME);
            if (removeRequest != null) {
                try {
                    SecureStoreAccess.storeConfigInSecureStore(null);
                    myLogger.info("Profile destinations in secure store deleted");
                }
                catch (AccessException lce) {
                    aResultMessage = "Failed to delete profile connection from secure storage";
                    myLogger.error(aResultMessage);
                    aResultCode = ERR_RESULT_CODE;
                }
            } else {
                try {
                    ProfileDestinationStore dest = new ProfileDestinationStore(connProps);
                    if (!dest.isValid()) {
                        aResultMessage = "Missing parameters in secure storage request";
                        myLogger.error(aResultMessage);
                        aResultCode = ERR_RESULT_CODE;
                    } else {
                        SecureStoreAccess.storeConfigInSecureStore(dest);
                        myLogger.info("Profile destination written to secure store");
                    }
                }
                catch (AccessException lce) {
                    aResultMessage = "Failed to store profile connection in secure storage";
                    myLogger.error(aResultMessage);
                    aResultCode = ERR_RESULT_CODE;
                }
            }
        }
        String aResultHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- Response of " + ((Object)((Object)this)).getClass() + " --><store><returncode>";
        String aResultDelim = "</returncode><message>";
        String aResultFooter = "</message></store>";
        String theResult = aResultCode.equals(ERR_RESULT_CODE) ? aResultHeader + aResultCode + aResultDelim + aResultMessage + SERVER_LOG_HINT + aResultFooter : aResultHeader + aResultCode + aResultDelim + aResultMessage + aResultFooter;
        try {
            this.outputStream.write(StreamedGenericConfigServlet.toUTF8(theResult));
        }
        catch (Exception e) {
            myLogger.error("Unable to response secure storage request", e);
        }
    }

    private boolean isRequiredCharSet(String reqCharSet) {
        String paramValue;
        String paramKey;
        String param;
        String typeHeader = this.request.getHeader("Content-Type");
        return typeHeader != null && (param = StreamedGenericConfigServlet.getParameter(typeHeader)) != null && (paramKey = StreamedGenericConfigServlet.getParamKey(param)).equalsIgnoreCase("charset") && (paramValue = StreamedGenericConfigServlet.getParamValue(param)) != null && paramValue.equalsIgnoreCase(reqCharSet);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

