/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.log;

import com.sap.rprof.dbprofiles.log.ConsoleHandler;
import com.sap.rprof.dbprofiles.log.FileHandler;
import com.sap.rprof.dbprofiles.log.Handler;
import com.sap.rprof.dbprofiles.log.Level;
import com.sap.rprof.dbprofiles.log.LogRecord;
import com.sap.rprof.dbprofiles.log.LogUtil;
import com.sap.rprof.dbprofiles.log.SAPStandardLogHandler;
import com.sap.rprof.dbprofiles.log.SimpleLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Logger {
    private static final String CONFIG_FILE = "rproflog.properties";
    private static Map categoryMap = new Hashtable();
    static final String ROOT_NAME;
    public static final Logger ROOT;
    public static final Logger global;
    private static boolean active;
    private String name;
    private Logger parent;
    private Level level;
    private boolean useParentHandlers = true;
    private Vector handlers = new Vector();

    private Logger(String name, Logger parent) {
        this.name = name;
        this.parent = parent;
        this.level = null;
        categoryMap.put(name, this);
    }

    public static Logger getLogger(String name) {
        Logger result;
        if (categoryMap.containsKey(name)) {
            result = (Logger)categoryMap.get(name);
        } else {
            int pos = name.lastIndexOf(46);
            String parentName = pos < 0 ? ROOT_NAME : name.substring(0, pos);
            Logger parent = Logger.getLogger(parentName);
            result = new Logger(name, parent);
        }
        return result;
    }

    public void log(Exception exception) {
        this.log(Level.ERROR, exception.getMessage(), exception);
    }

    public void log(RuntimeException exception) {
        this.log(Level.ERROR, exception.getMessage(), exception);
    }

    public void log(Throwable throwable) {
        this.log(Level.ERROR, throwable.getMessage(), throwable);
    }

    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    public void log(Level level, String message, Throwable t) {
        if (level == null) {
            level = Level.DEFAULT;
        }
        try {
            if (active && level.getPriority() >= this.getActiveLevel().getPriority()) {
                LogRecord rec = new LogRecord(this.name, level, message);
                if (t != null) {
                    rec.setThrown(t);
                }
                this.publish(rec);
            }
        }
        catch (Exception e) {
            SimpleLog.error("in log", e);
        }
    }

    public void log(String message) {
        this.log(Level.DEFAULT, message);
    }

    public void fatal(String message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public void error(String message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void warning(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public void debug(String message, Throwable t) {
        this.log(Level.DEBUG, message, t);
    }

    public void fine(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    public void finer(String message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    public void finest(String message, Throwable t) {
        this.log(Level.FINEST, message, t);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void warning(String message) {
        this.log(Level.WARNING, message, null);
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void fine(String message) {
        this.log(Level.FINE, message, null);
    }

    public void finer(String message) {
        this.log(Level.FINER, message, null);
    }

    public void finest(String message) {
        this.log(Level.FINEST, message, null);
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            if (level != null && level.getPriority() > this.getActiveLevel().getPriority()) {
                SimpleLog.info("changing output level of \"" + this.getName() + "\" from " + this.getActiveLevel() + " to " + level);
            }
            this.level = level;
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public Level getActiveLevel() {
        if (!active) {
            return Level.OFF;
        }
        if (this.level != null) {
            return this.level;
        }
        if (this.parent != null) {
            return this.parent.getActiveLevel();
        }
        return Level.ALL;
    }

    public static void off() {
        active = false;
    }

    public static void on() {
        active = true;
    }

    private static Properties getSubProperties(Properties prop, String prefix) {
        Properties newProp = new Properties();
        int len = prefix.length();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            String value = prop.getProperty(name);
            name = name.length() > len ? name.substring(len) : "";
            newProp.setProperty(name, value);
        }
        return newProp;
    }

    public static void configure(Properties props) {
        String name;
        Logger.clearAll();
        String value = props.getProperty("log.internalDebug");
        if (value != null) {
            Logger.setInternalDebug(Boolean.valueOf(value));
        }
        if ((value = props.getProperty("log.internalInfo")) != null) {
            Logger.setInternalInfo(Boolean.valueOf(value));
        }
        if ((value = props.getProperty("log.stacktraceMode")) != null) {
            if (value.equals("always")) {
                LogUtil.setStacktraceMode(0);
            }
            if (value.equals("never")) {
                LogUtil.setStacktraceMode(2);
            }
            if (value.equals("runtime")) {
                LogUtil.setStacktraceMode(1);
            }
        }
        Properties handlerProp = Logger.getSubProperties(props, "log.handler.");
        Enumeration<?> e = handlerProp.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = handlerProp.getProperty(name);
            SimpleLog.debug("configure Handler: " + name + "=" + value);
            if (name.indexOf(46) != -1) continue;
            Handler handler = null;
            StringTokenizer tok = new StringTokenizer(value, " ,");
            if (tok.hasMoreTokens()) {
                String hclass = tok.nextToken();
                if (hclass.equals("ConsoleHandler")) {
                    handler = new ConsoleHandler(name);
                    SimpleLog.debug("   new ConsoleHandler \"" + name);
                } else if (hclass.equals("SAPStandardLogHandler")) {
                    while (tok.hasMoreTokens()) {
                        tok.nextToken();
                    }
                    handler = new SAPStandardLogHandler(name);
                    SimpleLog.debug("   new SAPStandardLogHandler \"" + name + "\"");
                } else if (hclass.equals("FileHandler")) {
                    String file = "log.txt";
                    boolean append = false;
                    if (tok.hasMoreTokens()) {
                        file = tok.nextToken();
                    }
                    while (tok.hasMoreTokens()) {
                        String flag = tok.nextToken();
                        if (!flag.equalsIgnoreCase("append")) continue;
                        append = true;
                    }
                    try {
                        handler = new FileHandler(name, file, append);
                        SimpleLog.debug("   new FileHandler \"" + name + "\" file=" + file + " append=" + append);
                    }
                    catch (IOException ex) {
                        SimpleLog.error("cannot create FileHandler \"" + name + "\" file=" + file, ex);
                    }
                } else {
                    SimpleLog.error("Handler " + hclass + " not supported by readConfig()");
                }
            }
            if (handler == null || name == null) continue;
            Properties subProp = Logger.getSubProperties(handlerProp, name + ".");
            Enumeration<?> e2 = subProp.propertyNames();
            while (e2.hasMoreElements()) {
                String n = (String)e2.nextElement();
                String v = subProp.getProperty(n);
                if (!n.equals("level")) continue;
                handler.setLevel(Level.getLevel(v));
            }
        }
        Properties logProp = Logger.getSubProperties(props, "log.logger.");
        e = logProp.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = logProp.getProperty(name);
            SimpleLog.debug("configure Logger: " + name + "=" + value);
            Logger logger = Logger.getLogger(name);
            StringTokenizer tok = new StringTokenizer(value, " ,");
            if (tok.hasMoreTokens()) {
                logger.setLevel(Level.getLevel(tok.nextToken()));
                SimpleLog.debug("   setLevel=" + logger.getLevel());
            }
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken();
                Handler h = Handler.getHandler(t);
                if (h != null) {
                    logger.addHandler(h);
                    SimpleLog.debug("   addHandler=" + t);
                    continue;
                }
                SimpleLog.error("Handler \"" + t + "\" not found");
            }
        }
    }

    public String toString() {
        return this.name + '(' + this.level + ')';
    }

    private void publish(LogRecord rec) {
        int i = 0;
        while (i < this.handlers.size()) {
            ((Handler)this.handlers.get(i)).publish(rec);
            ++i;
        }
        if (this.parent != null && this.useParentHandlers) {
            this.parent.publish(rec);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        int pos = this.name.lastIndexOf(46);
        if (pos < 0) {
            return this.name;
        }
        return this.name.substring(pos + 1);
    }

    public void setUseParentHandlers(boolean flag) {
        this.useParentHandlers = flag;
    }

    public void addHandler(Handler handler) {
        this.handlers.addElement(handler);
    }

    public void removeAllHandlers() {
        this.handlers.removeAllElements();
        SimpleLog.debug("removing all Handlers from " + this.getName());
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public void removeHandler(String name) {
        this.handlers.remove(Handler.getHandler(name));
    }

    public Enumeration listHandlers() {
        return this.handlers.elements();
    }

    boolean contains(Logger p) {
        while (p != null) {
            if (p == this) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public static Enumeration listLoggers() {
        return Collections.enumeration(categoryMap.keySet());
    }

    public static void clearAll() {
        Iterator i = categoryMap.keySet().iterator();
        while (i.hasNext()) {
            Logger l = (Logger)categoryMap.get((String)i.next());
            l.removeAllHandlers();
            l.level = null;
            l.setUseParentHandlers(true);
        }
    }

    public static void resetAll() {
        Logger.clearAll();
        Logger.init();
    }

    private static Properties getDefaultConfig() {
        Properties props = new Properties();
        props.setProperty("log.internalDebug", "false");
        props.setProperty("log.internalInfo", "false");
        props.setProperty("log.stacktraceMode", "always");
        props.setProperty("log.handler.RootSAPLog", "SAPStandardLogHandler");
        props.setProperty("log.handler.RootSAPLog.level", "ALL");
        props.setProperty("log.logger.ROOT", "ALL, RootSAPLog");
        return props;
    }

    private static Properties getSimpleConfig(Level level) {
        if (level == null) {
            level = Level.ERROR;
        }
        Properties props = new Properties();
        props.setProperty("log.internalDebug", "false");
        props.setProperty("log.internalInfo", "false");
        props.setProperty("log.stacktraceMode", "always");
        props.setProperty("log.handler.RootConsole", "ConsoleHandler");
        props.setProperty("log.handler.RootConsole.level", level.getName());
        props.setProperty("log.logger.ROOT", "ALL, RootConsole");
        return props;
    }

    private static void init() {
        Properties props = new Properties();
        File file = new File(CONFIG_FILE);
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                SimpleLog.debug("RProf reading log configuration from \"" + file.getAbsolutePath() + "\"");
                props.load(in);
                ((InputStream)in).close();
            }
            catch (IOException ex) {
                SimpleLog.error("RProf error during log configuration", ex);
                props = Logger.getSimpleConfig(null);
            }
            Logger.configure(props);
        } else {
            SimpleLog.debug("RProf using default log configuration");
            Logger.configure(Logger.getDefaultConfig());
        }
    }

    public static void setInternalDebug(boolean x) {
        SimpleLog.setDebug(x);
    }

    public static void setInternalInfo(boolean x) {
        SimpleLog.setInfo(x);
    }

    static {
        active = true;
        ROOT_NAME = "ROOT";
        ROOT = new Logger(ROOT_NAME, null);
        global = new Logger("global", ROOT);
        Logger.init();
    }
}

