/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.log;

import com.sap.rprof.dbprofiles.log.Logger;
import com.sap.rprof.dbprofiles.log.SimpleLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;

public class LogUtil {
    public static final int STACKTRACE_ALWAYS = 0;
    public static final int STACKTRACE_RUNTIME = 1;
    public static final int STACKTRACE_NEVER = 2;
    public static final String UNKNOWN_CLASS = "UnknownClass";
    public static final String UNKNOWN_METHOD = "UnknownClass.method";
    private static int stacktraceMode = 0;

    public static int getStacktraceMode() {
        return stacktraceMode;
    }

    public static void setStacktraceMode(int mode) {
        stacktraceMode = mode;
    }

    public static Logger getClassLogger(Object obj) {
        return Logger.getLogger(obj.getClass().getName());
    }

    public static String formatThrowable(Throwable t) {
        try {
            StringBuffer buf = new StringBuffer("Thrown: \n");
            LogUtil.formatThrowable(t, buf);
            return buf.toString();
        }
        catch (Error e) {
            SimpleLog.error("Unexpected Error during Trace output");
            return "";
        }
    }

    private static void formatThrowable(Throwable t, StringBuffer buf) {
        buf.append(t.getClass().getName());
        buf.append(": ");
        buf.append(t.getMessage());
        buf.append("\n");
        switch (stacktraceMode) {
            case 2: {
                break;
            }
            case 1: {
                if (!(t instanceof RuntimeException)) break;
            }
            default: {
                buf.append(LogUtil.formatStackTrace(t));
            }
        }
        Throwable innerT = null;
        if (t instanceof RemoteException) {
            innerT = ((RemoteException)t).detail;
        }
        if (innerT != null) {
            buf.append("Root cause:\n");
            LogUtil.formatThrowable(innerT, buf);
        }
    }

    private static String formatStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        String s = sw.toString();
        int i = s.indexOf("\n");
        if (i < 0) {
            return s;
        }
        return s.substring(i + 1);
    }
}

