/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.log;

import com.sap.rprof.dbprofiles.log.Formatter;
import com.sap.rprof.dbprofiles.log.LogRecord;
import com.sap.rprof.dbprofiles.log.LogUtil;
import java.text.DateFormat;

public class DefaultFormatter
extends Formatter {
    private static final DateFormat df = DateFormat.getDateTimeInstance(3, 2);

    public String format(LogRecord rec) {
        String date;
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(rec.getSequenceNumber());
        sb.append(" ");
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            date = df.format(rec.getDate());
        }
        sb.append(date);
        sb.append(" [");
        sb.append(rec.getThreadName());
        sb.append("] ");
        sb.append(rec.getLevel().getName());
        sb.append(" ");
        sb.append(rec.getLoggerName());
        sb.append(": ");
        sb.append(rec.getMessage());
        Throwable t = rec.getThrown();
        if (t != null) {
            sb.append("\n").append(LogUtil.formatThrowable(t));
        }
        return sb.toString();
    }
}

