/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles.jdbc;

import com.sap.rprof.dbprofiles.jdbc.SLDContext;
import com.sap.rprof.dbprofiles.log.LocationLogger;
import com.sap.rprof.dbprofiles.log.Logger;
import java.sql.Connection;
import java.util.Date;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class RprofContextProvider {
    static DataSource ds = null;
    static final Logger logger = Logger.getLogger((class$com$sap$rprof$dbprofiles$jdbc$RprofContextProvider == null ? (class$com$sap$rprof$dbprofiles$jdbc$RprofContextProvider = RprofContextProvider.class$("com.sap.rprof.dbprofiles.jdbc.RprofContextProvider")) : class$com$sap$rprof$dbprofiles$jdbc$RprofContextProvider).getName());
    static final String CheckDBMsg = "Check your database for sanity and check logs and traces for further information.";
    static final String StdJdbcConnect = "jdbc/SAP/BC_SLD";
    static final Object OpenConnectionsLock = new Object();
    static int OpenConnectionsCounter = 0;
    static int TotalConnectionsCounter = 0;
    static final String startsep = "---------------------- Creation of new context ";
    static final String sep = "----------------------";
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$jdbc$RprofContextProvider;

    public static SLDContext getContext(boolean aLoggingFlag) throws Exception {
        Object object;
        String tMethodName = null;
        if (aLoggingFlag) {
            tMethodName = "RprofContextProvider.getContext";
            tMethodName = tMethodName + " " + LocationLogger.CallNumber++;
            LocationLogger.debug(logger, "---------------------- Creation of new context  " + new Date() + " " + tMethodName + " " + sep, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:35)");
            LocationLogger.som(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:36)");
        }
        SLDContext tResult = null;
        Connection tConnection = null;
        if (ds == null) {
            object = class$com$sap$rprof$dbprofiles$jdbc$RprofContextProvider == null ? (class$com$sap$rprof$dbprofiles$jdbc$RprofContextProvider = RprofContextProvider.class$("com.sap.rprof.dbprofiles.jdbc.RprofContextProvider")) : class$com$sap$rprof$dbprofiles$jdbc$RprofContextProvider;
            synchronized (object) {
                if (ds == null) {
                    RprofContextProvider.init(aLoggingFlag);
                }
            }
        }
        try {
            tConnection = RprofContextProvider.getConnection(aLoggingFlag);
            object = OpenConnectionsLock;
            synchronized (object) {
                LocationLogger.debug(logger, "OpenConnectionsCounter", ++OpenConnectionsCounter, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:58)");
                LocationLogger.debug(logger, "TotalConnectionsCounter", ++TotalConnectionsCounter, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:59)");
            }
            tResult = new SLDContext(tConnection);
        }
        catch (Exception e) {
            try {
                if (tResult != null) {
                    RprofContextProvider.releaseContext(tResult, aLoggingFlag);
                } else if (tConnection != null) {
                    RprofContextProvider.releaseConnection(tConnection, aLoggingFlag);
                }
            }
            catch (Exception ne) {
                LocationLogger.error(logger, "Caught an exception while already processing another one", ne, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:77)");
            }
            LocationLogger.error(logger, "Failed to acquire a database connection. Check your database for sanity and check logs and traces for further information.", e, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:80)");
            throw e;
        }
        if (aLoggingFlag) {
            LocationLogger.debug(logger, "tResult", (Object)tResult, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:85)");
            LocationLogger.eom(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:86)");
        }
        return tResult;
    }

    public static void releaseContext(SLDContext aContext, boolean aLoggingFlag) throws Exception {
        String tMethodName = null;
        if (aLoggingFlag) {
            tMethodName = "RprofContextProvider.releaseContext";
            tMethodName = tMethodName + " " + LocationLogger.CallNumber++;
            LocationLogger.som(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:98)");
        }
        aContext.close(true);
        Object object = OpenConnectionsLock;
        synchronized (object) {
            LocationLogger.debug(logger, "OpenConnectionsCounter", --OpenConnectionsCounter, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:104)");
        }
        if (aLoggingFlag) {
            LocationLogger.eom(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:108)");
        }
    }

    static void releaseConnection(Connection aConnection, boolean aLoggingFlag) throws Exception {
        String tMethodName = null;
        if (aLoggingFlag) {
            tMethodName = "RprofContextProvider.releaseConnection";
            tMethodName = tMethodName + " " + LocationLogger.CallNumber++;
            LocationLogger.som(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:118)");
        }
        aConnection.close();
        Object object = OpenConnectionsLock;
        synchronized (object) {
            LocationLogger.debug(logger, "OpenConnectionsCounter", --OpenConnectionsCounter, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:124)");
        }
        if (aLoggingFlag) {
            LocationLogger.eom(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:128)");
        }
    }

    static void init(boolean aLoggingFlag) throws Exception {
        String tMethodName = null;
        if (aLoggingFlag) {
            tMethodName = "RprofContextProvider.init";
            tMethodName = tMethodName + " " + LocationLogger.CallNumber++;
            LocationLogger.som(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:138)");
        }
        ds = RprofContextProvider.lookupDataSource(aLoggingFlag);
        if (aLoggingFlag) {
            LocationLogger.eom(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:144)");
        }
    }

    static DataSource lookupDataSource(boolean aLoggingFlag) throws Exception {
        String tMethodName = null;
        if (aLoggingFlag) {
            tMethodName = "RprofContextProvider.lookupDataSource";
            tMethodName = tMethodName + " " + LocationLogger.CallNumber++;
            LocationLogger.som(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:154)");
        }
        Object tObject = null;
        DataSource tResult = null;
        InitialContext jndiContext = new InitialContext();
        tObject = jndiContext.lookup(StdJdbcConnect);
        if (!(tObject instanceof DataSource)) {
            String tMsg = "Failed to get datasource from JNDI lookup of: jdbc/SAP/BC_SLD";
            LocationLogger.debug(logger, "tResult", tResult, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:167)");
            LocationLogger.error(logger, tMsg + ". " + CheckDBMsg, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:168)");
            Exception e = new Exception(tMsg);
            throw e;
        }
        tResult = (DataSource)tObject;
        if (aLoggingFlag) {
            LocationLogger.debug(logger, "tResult", tResult, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:174)");
            LocationLogger.eom(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:175)");
        }
        return tResult;
    }

    static Connection getConnection(boolean aLoggingFlag) throws Exception {
        Connection tConnection;
        String tMethodName = null;
        if (aLoggingFlag) {
            tMethodName = "RprofContextProvider.getContext";
            tMethodName = tMethodName + " " + LocationLogger.CallNumber++;
            LocationLogger.som(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:187)");
        }
        if ((tConnection = ds.getConnection()) == null) {
            String tMsg = "Failed to get connection from DataSource: " + ds;
            LocationLogger.error(logger, tMsg + ". " + CheckDBMsg, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:195)");
            Exception e = new Exception(tMsg);
            throw e;
        }
        if (aLoggingFlag) {
            LocationLogger.debug(logger, "tConnection", tConnection, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:201)");
            LocationLogger.eom(logger, tMethodName, "(com/sap/rprof/dbprofiles/jdbc/RprofContextProvider.java:202)");
        }
        return tConnection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

