/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.ProfileParameter;
import com.sap.rprof.dbprofiles.ProfileSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtil {
    static final String DEFAULT_SECTION = "default";
    static final String NAME_ATTR = "name";
    static final String DEFAULT_ATTR = "default";
    static final String TYPE_ATTR = "type";
    static final String VISIBLE_ATTR = "visible";
    static final String SEVERITY_ATTR = "severity";
    static final String DELETE_ATTR = "delete";
    static final String ENCODED_ATTR = "encoded";
    static final String OWNER_ATTR = "owner";
    static final String SINCE_ATTR = "since";
    static final String TILL_ATTR = "till";
    static final String VALUE_TRUE = "true";
    static final String VALUE_FALSE = "false";
    private ArrayList deletedElements = new ArrayList();

    void scanDocument(Document profileDocument, Node node, HashMap sectionMap) {
        String sectionName;
        Element elem;
        ProfileSection currentSection = null;
        if (node.getNodeType() == 1 && (elem = (Element)node).getTagName().equals("section") && (sectionName = elem.getAttribute(NAME_ATTR)).length() > 0) {
            if (sectionMap.containsKey(sectionName)) {
                currentSection = (ProfileSection)sectionMap.get(sectionName);
            } else {
                currentSection = new ProfileSection(sectionName);
                sectionMap.put(sectionName, currentSection);
            }
            this.scanParameters(profileDocument, elem, currentSection);
        }
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                this.scanDocument(profileDocument, childNodes.item(i), sectionMap);
                ++i;
            }
        }
    }

    private void scanParameters(Document profileDocument, Node node, ProfileSection section) {
        block7: {
            HashMap sectionMap = section.getParameterMap();
            if (!node.hasChildNodes()) break block7;
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                block8: {
                    Element elem;
                    block9: {
                        String trimedValue;
                        String parameterName;
                        block11: {
                            NodeList valueElemList;
                            StringBuffer parameterValue;
                            block10: {
                                Node nextChild = childNodes.item(i);
                                if (nextChild.getNodeType() != 1) break block8;
                                elem = (Element)nextChild;
                                if (!elem.getTagName().equals("parameter")) break block9;
                                parameterValue = new StringBuffer(256);
                                parameterName = elem.getAttribute(NAME_ATTR);
                                if (parameterName.length() <= 0) break block8;
                                valueElemList = elem.getElementsByTagName("value");
                                if (valueElemList.getLength() != 0) break block10;
                                if (!elem.hasAttribute("default")) break block8;
                                trimedValue = elem.getAttribute("default");
                                break block11;
                            }
                            Element valueElement = (Element)valueElemList.item(0);
                            NodeList subChildNodes = valueElement.getChildNodes();
                            int j = 0;
                            while (j < subChildNodes.getLength()) {
                                if (subChildNodes.item(j).getNodeType() == 3) {
                                    parameterValue.append(subChildNodes.item(j).getNodeValue());
                                }
                                ++j;
                            }
                            trimedValue = parameterValue.toString().trim();
                        }
                        boolean docValueEncoded = false;
                        if (elem.hasAttribute(ENCODED_ATTR)) {
                            docValueEncoded = elem.getAttribute(ENCODED_ATTR).equals(VALUE_TRUE);
                        }
                        String docParamType = null;
                        if (elem.hasAttribute(TYPE_ATTR)) {
                            docParamType = elem.getAttribute(TYPE_ATTR);
                        }
                        ProfileParameter parameter = new ProfileParameter(docParamType, parameterName, trimedValue, docValueEncoded);
                        this.scanParameterAttributes(elem, parameter);
                        if (parameter.isEncoded() && !docValueEncoded) {
                            this.encodeElement(profileDocument, elem, trimedValue, parameter);
                        }
                        sectionMap.put(parameterName, parameter);
                        break block8;
                    }
                    if (elem.getTagName().equals("description")) {
                        section.setDescription(this.extractDescriptionValue(elem));
                    }
                }
                ++i;
            }
        }
    }

    private void scanParameterAttributes(Element elem, ProfileParameter param) {
        param.setDescription(this.findDescriptionValue(elem));
        if (elem.hasAttribute("default")) {
            param.setDefaultValue(elem.getAttribute("default"));
        }
        if (elem.hasAttribute(VISIBLE_ATTR)) {
            param.setVisible(elem.getAttribute(VISIBLE_ATTR).equals(VALUE_TRUE));
        }
        if (elem.hasAttribute(SEVERITY_ATTR)) {
            param.setSeverity(elem.getAttribute(SEVERITY_ATTR));
        }
        if (elem.hasAttribute(DELETE_ATTR)) {
            param.setDelete(elem.getAttribute(DELETE_ATTR).equals(VALUE_TRUE));
        }
        if (elem.hasAttribute(OWNER_ATTR)) {
            param.setOwner(elem.getAttribute(OWNER_ATTR));
        }
        if (elem.hasAttribute(SINCE_ATTR)) {
            param.setSince(elem.getAttribute(SINCE_ATTR));
        }
        if (elem.hasAttribute(TILL_ATTR)) {
            param.setTill(elem.getAttribute(TILL_ATTR));
        }
    }

    private String findDescriptionValue(Element elem) {
        NodeList descElemList = elem.getElementsByTagName("description");
        int iv = 0;
        if (iv < descElemList.getLength()) {
            Element nextValueElem = (Element)descElemList.item(iv);
            return this.extractDescriptionValue(nextValueElem);
        }
        return null;
    }

    private String extractDescriptionValue(Element elem) {
        StringBuffer myDescBuf = new StringBuffer(1024);
        NodeList subChildNodes = elem.getChildNodes();
        int j = 0;
        while (j < subChildNodes.getLength()) {
            if (subChildNodes.item(j).getNodeType() == 3) {
                myDescBuf.append(subChildNodes.item(j).getNodeValue());
            }
            ++j;
        }
        if (myDescBuf.length() > 0) {
            return myDescBuf.toString();
        }
        return null;
    }

    Document createProfileDocument(DocumentBuilder DomBuilder, HashMap profileMap) {
        Document result = DomBuilder.newDocument();
        Element docRoot = result.createElement("aiiparameters");
        result.appendChild(docRoot);
        Set sectionEntries = profileMap.entrySet();
        Iterator sectionIter = sectionEntries.iterator();
        while (sectionIter.hasNext()) {
            Map.Entry nextSectionEntry = sectionIter.next();
            ProfileSection nextSection = (ProfileSection)nextSectionEntry.getValue();
            String nextSectionName = (String)nextSectionEntry.getKey();
            Element sectionElement = this.createSectionElement(result, docRoot, nextSection, nextSectionName);
            HashMap nextParameterMap = nextSection.getParameterMap();
            Set parameterEntries = nextParameterMap.entrySet();
            Iterator parameterIter = parameterEntries.iterator();
            while (parameterIter.hasNext()) {
                Map.Entry nextParameterEntry = parameterIter.next();
                ProfileParameter nextParameter = (ProfileParameter)nextParameterEntry.getValue();
                String nextParameterName = (String)nextParameterEntry.getKey();
                this.createParameterElement(result, sectionElement, nextParameter, nextParameterName);
            }
        }
        return result;
    }

    private void createParameterElement(Document document, Element sectionElement, ProfileParameter parameterObj, String parameterName) {
        Element parameterElement = document.createElement("parameter");
        parameterElement.setAttribute(NAME_ATTR, parameterName);
        sectionElement.appendChild(parameterElement);
        String nextParamDescription = parameterObj.getDescription();
        if (nextParamDescription != null) {
            Element descriptionElement = document.createElement("description");
            parameterElement.appendChild(descriptionElement);
            Text descriptionText = document.createTextNode(nextParamDescription);
            descriptionElement.appendChild(descriptionText);
        }
        Element valueElement = document.createElement("value");
        parameterElement.appendChild(valueElement);
        Text valueText = document.createTextNode(parameterObj.getDocumentValue());
        valueElement.appendChild(valueText);
        if (parameterObj.getDefaultValue() != null) {
            parameterElement.setAttribute("default", parameterObj.getDefaultValue());
        }
        if (parameterObj.getType() != null) {
            parameterElement.setAttribute(TYPE_ATTR, parameterObj.getType());
        }
        if (!parameterObj.isVisible()) {
            parameterElement.setAttribute(VISIBLE_ATTR, VALUE_FALSE);
        }
        if (parameterObj.getSeverity() != null) {
            parameterElement.setAttribute(SEVERITY_ATTR, parameterObj.getSeverity());
        }
        if (parameterObj.isDelete()) {
            parameterElement.setAttribute(DELETE_ATTR, VALUE_TRUE);
        }
        if (parameterObj.isEncoded()) {
            parameterElement.setAttribute(ENCODED_ATTR, VALUE_TRUE);
        }
        if (parameterObj.getOwner() != null) {
            parameterElement.setAttribute(OWNER_ATTR, parameterObj.getOwner());
        }
        if (parameterObj.getSince() != null) {
            parameterElement.setAttribute(SINCE_ATTR, parameterObj.getSince());
        }
        if (parameterObj.getTill() != null) {
            parameterElement.setAttribute(TILL_ATTR, parameterObj.getTill());
        }
    }

    private Element createSectionElement(Document document, Element rootElem, ProfileSection sectionObj, String sectionName) {
        Element sectionElement = document.createElement("section");
        sectionElement.setAttribute(NAME_ATTR, sectionName);
        rootElem.appendChild(sectionElement);
        String nextSectionDescription = sectionObj.getDescription();
        if (nextSectionDescription != null) {
            this.setSectionDescription(document, sectionElement, nextSectionDescription);
        }
        return sectionElement;
    }

    private void setSectionDescription(Document document, Element sectionElement, String sectionDescription) {
        if (sectionDescription == null) {
            return;
        }
        Element descriptionElement = document.createElement("description");
        sectionElement.appendChild(descriptionElement);
        Text descriptionText = document.createTextNode(sectionDescription);
        descriptionElement.appendChild(descriptionText);
    }

    Element getParameterElement(Document profileDocument, String section, String name) {
        Element result = null;
        NodeList parameterList = profileDocument.getElementsByTagName("parameter");
        int i = 0;
        while (i < parameterList.getLength()) {
            Node elemSection;
            Element elem = (Element)parameterList.item(i);
            if (elem.getAttribute(NAME_ATTR).equals(name) && (elemSection = elem.getParentNode()).getNodeType() == 1) {
                String elemSectionName = ((Element)elemSection).getAttribute(NAME_ATTR);
                if (section != null && elemSectionName.equals(section)) {
                    return elem;
                }
                if (elemSectionName.equals("default")) {
                    result = elem;
                }
            }
            ++i;
        }
        return result;
    }

    Element findOrAddSection(Document profileDocument, String section) {
        Element sectionElem = null;
        if (profileDocument != null) {
            NodeList sectionList = profileDocument.getElementsByTagName("section");
            int i = 0;
            while (i < sectionList.getLength()) {
                Element elem = (Element)sectionList.item(i);
                if (elem.getAttribute(NAME_ATTR).equals(section)) {
                    sectionElem = elem;
                    break;
                }
                ++i;
            }
            if (sectionElem == null) {
                sectionElem = profileDocument.createElement("section");
                sectionElem.setAttribute(NAME_ATTR, section);
                profileDocument.getDocumentElement().appendChild(sectionElem);
            }
        }
        return sectionElem;
    }

    void updateOrInsertParameter(Document profileDocument, String section, ProfileParameter parameter) {
        String name = parameter.getName();
        String value = parameter.getDocumentValue();
        if (profileDocument != null) {
            Element parameterElem = this.getParameterElement(profileDocument, section, name);
            if (parameterElem == null) {
                Element sectionElem = this.findOrAddSection(profileDocument, section);
                this.createParameterElement(profileDocument, sectionElem, parameter, name);
            } else {
                this.modifyParameterValue(profileDocument, parameterElem, value);
            }
        }
    }

    void deleteParameter(Document profileDocument, String section, String name) {
        if (profileDocument != null) {
            NodeList parameterList = profileDocument.getElementsByTagName("parameter");
            int i = parameterList.getLength() - 1;
            while (i >= 0) {
                String elemSectionName;
                Element elem = (Element)parameterList.item(i);
                Node elemSection = elem.getParentNode();
                if (elemSection.getNodeType() == 1 && (elemSectionName = ((Element)elemSection).getAttribute(NAME_ATTR)).equals(section) && elem.getAttribute(NAME_ATTR).equals(name)) {
                    elemSection.removeChild(elem);
                }
                --i;
            }
        }
    }

    List clearSection(Document profileDocument, String section) throws AccessException {
        ArrayList<String> result = new ArrayList<String>();
        if (profileDocument != null) {
            NodeList sectionList = profileDocument.getElementsByTagName("section");
            int i = sectionList.getLength() - 1;
            while (i >= 0) {
                Element elem = (Element)sectionList.item(i);
                if (elem.getAttribute(NAME_ATTR).equals(section)) {
                    NodeList subSections = elem.getChildNodes();
                    int j = 0;
                    while (j < subSections.getLength()) {
                        Element childElem;
                        Node childNode = subSections.item(j);
                        if (childNode.getNodeType() == 1 && (childElem = (Element)childNode).getNodeName().equals("section")) {
                            String subSectionName = childElem.getAttribute(NAME_ATTR);
                            List clearedSubSections = this.clearSection(profileDocument, subSectionName);
                            result.addAll(clearedSubSections);
                        }
                        ++j;
                    }
                    elem.getParentNode().removeChild(elem);
                    result.add(section);
                }
                --i;
            }
        }
        return result;
    }

    void setParameterDefault(Document profileDocument, String section, String name, String value) {
        Element paramElem = this.getParameterElement(profileDocument, section, name);
        paramElem.setAttribute("default", value);
    }

    void adaptMergeTarget(Document profileDocument, HashMap sourceSectionMap) {
        Set sectionEntries = sourceSectionMap.entrySet();
        Iterator sectionIter = sectionEntries.iterator();
        while (sectionIter.hasNext()) {
            Map.Entry nextSectionEntry = sectionIter.next();
            String nextSectionName = (String)nextSectionEntry.getKey();
            ProfileSection nextSectionObj = (ProfileSection)nextSectionEntry.getValue();
            HashMap nextParameterMap = nextSectionObj.getParameterMap();
            Set parameterEntries = nextParameterMap.entrySet();
            Iterator parameterIter = parameterEntries.iterator();
            while (parameterIter.hasNext()) {
                Map.Entry nextParameterEntry = parameterIter.next();
                String nextParameterName = (String)nextParameterEntry.getKey();
                ProfileParameter nextParameterObj = (ProfileParameter)nextParameterEntry.getValue();
                Element targetElem = this.getParameterElement(profileDocument, nextSectionName, nextParameterName);
                if (targetElem != null) {
                    String currParameterType;
                    String nextParameterValue = nextParameterObj.getValue();
                    String nextParameterType = nextParameterObj.getType();
                    if (!nextParameterType.equals(currParameterType = this.getElementType(targetElem))) {
                        if (nextParameterType.equals("pwd") && currParameterType.equals("string")) {
                            this.modifyParameterValue(profileDocument, targetElem, nextParameterValue);
                            continue;
                        }
                        if (currParameterType.equals("pwd") && nextParameterType.equals("string")) {
                            this.encodeElement(profileDocument, targetElem, nextParameterValue, nextParameterObj);
                            continue;
                        }
                        targetElem.setAttribute(TYPE_ATTR, nextParameterType);
                        this.modifyParameterValue(profileDocument, targetElem, nextParameterValue);
                        if (!targetElem.hasAttribute(ENCODED_ATTR)) continue;
                        targetElem.removeAttribute(ENCODED_ATTR);
                        continue;
                    }
                    targetElem.setAttribute(TYPE_ATTR, nextParameterType);
                    if (nextParameterObj.isEncoded()) {
                        this.encodeElement(profileDocument, targetElem, nextParameterValue, nextParameterObj);
                        continue;
                    }
                    this.modifyParameterValue(profileDocument, targetElem, nextParameterValue);
                    continue;
                }
                Element sectionElem = this.findOrAddSection(profileDocument, nextSectionName);
                String targetDescription = this.findDescriptionValue(sectionElem);
                if (targetDescription == null) {
                    this.setSectionDescription(profileDocument, sectionElem, nextSectionObj.getDescription());
                }
                this.createParameterElement(profileDocument, sectionElem, nextParameterObj, nextParameterName);
            }
        }
        this.cleanDeleteElements(profileDocument);
    }

    void cleanDeleteElements(Document profileDocument) {
        Element docRootElem = profileDocument.getDocumentElement();
        this.deletedElements.clear();
        this.collectDeletedElements(docRootElem);
        this.cleanDeletedElements();
        this.deletedElements.clear();
    }

    private void modifyParameterValue(Document profileDocument, Element paramElem, String value) {
        Text futureTextNode = profileDocument.createTextNode(value);
        NodeList oldValueElemList = paramElem.getElementsByTagName("value");
        if (oldValueElemList.getLength() == 0) {
            Element valueElement = profileDocument.createElement("value");
            valueElement.appendChild(futureTextNode);
            paramElem.appendChild(valueElement);
        } else {
            int iv = 0;
            while (iv < oldValueElemList.getLength()) {
                Element nextValueElem = (Element)oldValueElemList.item(iv);
                NodeList subChildNodes = nextValueElem.getChildNodes();
                int j = subChildNodes.getLength() - 1;
                while (j >= 0) {
                    if (subChildNodes.item(j).getNodeType() == 3) {
                        nextValueElem.removeChild(subChildNodes.item(j));
                    }
                    --j;
                }
                nextValueElem.appendChild(futureTextNode);
                ++iv;
            }
        }
    }

    private void collectDeletedElements(Node node) {
        Element elem;
        String deleteAttr;
        if (node.getNodeType() == 1 && (deleteAttr = (elem = (Element)node).getAttribute(DELETE_ATTR)).length() > 0 && deleteAttr.equals(VALUE_TRUE)) {
            Node[] deletePair = new Node[]{elem.getParentNode(), elem};
            this.deletedElements.add(deletePair);
            return;
        }
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                this.collectDeletedElements(childNodes.item(i));
                ++i;
            }
        }
    }

    private void cleanDeletedElements() {
        int i = this.deletedElements.size() - 1;
        while (i >= 0) {
            Node[] deletePair = (Node[])this.deletedElements.get(i);
            deletePair[0].removeChild(deletePair[1]);
            --i;
        }
    }

    private void encodeElement(Document profileDocument, Element elem, String orgValue, ProfileParameter parameter) {
        String encValue = ProfileParameter.encVal(orgValue);
        if (orgValue.length() == 0 || encValue != orgValue) {
            parameter.setValue(orgValue);
            this.modifyParameterValue(profileDocument, elem, encValue);
            elem.setAttribute(ENCODED_ATTR, VALUE_TRUE);
        }
    }

    private String getElementType(Element elem) {
        String result = elem.getAttribute(TYPE_ATTR);
        if (result.length() == 0) {
            return "string";
        }
        return result;
    }
}

