/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.DBProfiles;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class Test {
    private static final String PROFILE_ENCODING = "UTF-8";

    public static void main(String[] args) {
        try {
            int nc;
            BufferedReader reader;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Enter Profile Attributes on DB:");
            System.out.print(" Application name in DB (max. 10 char): ");
            String appl = in.readLine();
            System.out.print(" Source file name in DB (max. 60 char): ");
            String filename = in.readLine();
            System.out.println("");
            System.out.println("Enter ABAP Login Parameters:");
            System.out.print(" Client (3 char): ");
            String client = in.readLine();
            System.out.print(" User: ");
            String user = in.readLine();
            System.out.print(" Password: ");
            String password = in.readLine();
            System.out.print(" Language (2 char): ");
            String language = in.readLine();
            System.out.print(" Host name of the application server: ");
            String apsrvHost = in.readLine();
            System.out.print(" System number (2 char): ");
            String sysnum = in.readLine();
            System.out.println("");
            System.out.println("Enter file name to be used on the file system:");
            System.out.print(" File name of a temporary file: ");
            String fsFilename = in.readLine();
            DBProfiles profiles = new DBProfiles(client, user, password, language, apsrvHost, sysnum);
            String currProfileString = profiles.getProfile(appl, filename);
            OutputStreamWriter myFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fsFilename), PROFILE_ENCODING);
            myFileWriter.write(currProfileString);
            myFileWriter.close();
            System.out.print("\n\nFile " + fsFilename + " with length " + currProfileString.length() + " written, write content back to DB (y/n) ? ");
            String decFlag = in.readLine();
            if (!decFlag.equalsIgnoreCase("y")) {
                return;
            }
            StringBuffer profileBuffer = new StringBuffer(65536);
            File readFile = new File(fsFilename);
            char[] inbuf = new char[512];
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(readFile), PROFILE_ENCODING));
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                return;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
                return;
            }
            do {
                try {
                    nc = reader.read(inbuf, 0, 512);
                    if (nc <= 0) continue;
                    profileBuffer.append(inbuf, 0, nc);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return;
                }
            } while (nc >= 0);
            try {
                reader.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            System.out.println("New source read successfully from file\n\n");
            String profileString = profileBuffer.toString();
            profiles.setProfile(appl, filename, profileString);
            String writtenProfileString = profiles.getProfile(appl, filename);
            System.out.println("\n\nRe-Read content, written to DB:");
            System.out.println(writtenProfileString);
        }
        catch (DBException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
    }
}

