/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.rprof.dbprofiles.AbapConnect;
import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.DBProfileFactory;
import com.sap.rprof.dbprofiles.FSProfileFactory;
import com.sap.rprof.dbprofiles.IProfileAccess;
import com.sap.rprof.dbprofiles.IProfileFactory;
import com.sap.rprof.dbprofiles.IProfileLock;
import com.sap.rprof.dbprofiles.IRemoteProfile;
import com.sap.rprof.dbprofiles.ProfileParameter;
import com.sap.rprof.dbprofiles.ProfileSection;
import com.sap.rprof.dbprofiles.XMLUtil;
import com.sap.rprof.dbprofiles.log.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RemoteProfile
implements IRemoteProfile {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$rprof$dbprofiles$RemoteProfile == null ? (class$com$sap$rprof$dbprofiles$RemoteProfile = RemoteProfile.class$("com.sap.rprof.dbprofiles.RemoteProfile")) : class$com$sap$rprof$dbprofiles$RemoteProfile).getName());
    public static final int MAXLEN_APPLNAME = 10;
    public static final int MAXLEN_FILENAME = 60;
    private static final String PROFILE_ENCODING = "UTF-8";
    private static final String KEY_SEPARATOR_STRING = "/";
    public static final String PROFILE_TAG = "aiiparameters";
    public static final String SECTION_TAG = "section";
    public static final String PARAMETER_TAG = "parameter";
    public static final String DESCRIPTION_TAG = "description";
    public static final String VALUE_TAG = "value";
    public static final String NAME_ATTR = "name";
    private static final String DEFAULT_SECTION = "default";
    private static final long TIMEOUT = 3600000L;
    private static AbapConnect abapConnect = null;
    protected static HashMap activeLockMap = new HashMap();
    private static DocumentBuilderFactory domFactory = null;
    private String myApplication = null;
    private String myProfileName = null;
    private IProfileLock profileLocker = null;
    private HashMap remoteSectionHashMap = new HashMap();
    private boolean remoteProfileMapFilled = false;
    private Document remoteProfileDocument = null;
    private boolean remoteProfileForFile = false;
    private IProfileFactory dataAccessFactory = null;
    private boolean doLocalLocking = true;
    private XMLUtil myXMLUtil;
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$RemoteProfile;

    protected RemoteProfile(String applname, String filename) {
        this.myApplication = applname.length() > 10 ? applname.substring(0, 10) : applname;
        this.myProfileName = filename.length() > 60 ? filename.substring(0, 60) : filename;
        this.myXMLUtil = new XMLUtil();
        if (domFactory == null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader savedLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader((class$com$sap$rprof$dbprofiles$RemoteProfile == null ? (class$com$sap$rprof$dbprofiles$RemoteProfile = RemoteProfile.class$("com.sap.rprof.dbprofiles.RemoteProfile")) : class$com$sap$rprof$dbprofiles$RemoteProfile).getClassLoader());
            try {
                domFactory = DocumentBuilderFactory.newInstance();
                Object var6_5 = null;
                currentThread.setContextClassLoader(savedLoader);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                currentThread.setContextClassLoader(savedLoader);
                throw throwable;
            }
        }
    }

    public static void setAbapConnect(String aClient, String aUser, String aPassword, String aLanguage, String aHostname, String aSystemNumber) {
        abapConnect = new AbapConnect();
        abapConnect.setupJcoCommunication(aClient, aUser, aPassword, aLanguage, aHostname, aSystemNumber);
    }

    public static RemoteProfile getRemoteProfile(String applname, String filename) throws DBException {
        AbapConnect stdConnect = RemoteProfile.getAbapConnect();
        myLogger.debug("Getting profile from " + stdConnect.getJcoHostname() + "_" + stdConnect.getJcoSystemNumber());
        DBProfileFactory myDataAccessFactory = new DBProfileFactory(stdConnect.createJcoClientInstance());
        return RemoteProfile.getRemoteProfileFromFactory(applname, filename, myDataAccessFactory);
    }

    public static synchronized RemoteProfile getRemoteProfileForUpdate(String applname, String filename) throws AccessException, DBException {
        AbapConnect stdConnect = RemoteProfile.getAbapConnect();
        myLogger.debug("Getting profile for update from " + stdConnect.getJcoHostname() + "_" + stdConnect.getJcoSystemNumber());
        DBProfileFactory myDataAccessFactory = new DBProfileFactory(stdConnect.createJcoClientInstance());
        return RemoteProfile.getRemoteProfileFromFactoryForUpdate(applname, filename, myDataAccessFactory, true);
    }

    public static RemoteProfile getRemoteProfileFromFactory(String applname, String filename, IProfileFactory aProfileFactory) throws DBException {
        RemoteProfile theProfile = new RemoteProfile(applname, filename);
        theProfile.setDataAccessFactory(aProfileFactory);
        theProfile.readRemoteProfileFromMedia();
        return theProfile;
    }

    public static synchronized RemoteProfile getRemoteProfileFromFactoryForUpdate(String applname, String filename, IProfileFactory aProfileFactory, boolean withLocalLocking) throws AccessException, DBException {
        RemoteProfile activeModifier;
        if (withLocalLocking && (activeModifier = RemoteProfile.getActiveLockingInstance(applname, filename, 3600000L)) != null) {
            throw new AccessException("Profile locked by another local session, please retry later.");
        }
        IProfileLock lockingInstance = aProfileFactory.newProfileLock();
        lockingInstance.lockProfile(applname, filename);
        RemoteProfile profileModifier = new RemoteProfile(applname, filename);
        profileModifier.setDataAccessFactory(aProfileFactory);
        profileModifier.setDoLocalLocking(withLocalLocking);
        profileModifier.setProfileLocker(lockingInstance);
        try {
            profileModifier.readRemoteProfileFromMedia();
        }
        catch (DBException dbe) {
            profileModifier.removeProfileLock();
            throw dbe;
        }
        if (withLocalLocking) {
            RemoteProfile.setActiveLockingInstance(applname, filename, profileModifier);
        }
        return profileModifier;
    }

    public static RemoteProfile getRemoteProfileFromFile(String applname, String filename, String realFilePath, String realFileName) throws DBException {
        RemoteProfile theProfile = new RemoteProfile(applname, filename);
        theProfile.readRemoteProfileFromFile(realFilePath, realFileName);
        theProfile.remoteProfileForFile = true;
        FSProfileFactory myDataAccessFactory = new FSProfileFactory(new File(realFilePath, realFileName).toString());
        theProfile.setDataAccessFactory(myDataAccessFactory);
        return theProfile;
    }

    protected static RemoteProfile getActiveLockingInstance(String applname, String filename, long timeout) {
        String profileKey = applname + KEY_SEPARATOR_STRING + filename;
        if (activeLockMap.containsKey(profileKey)) {
            ArrayList lockMapValue = (ArrayList)activeLockMap.get(profileKey);
            if (timeout > 0L) {
                Date lockDate = (Date)lockMapValue.get(1);
                if (new Date().getTime() - lockDate.getTime() > timeout) {
                    return null;
                }
                return (RemoteProfile)lockMapValue.get(0);
            }
            return (RemoteProfile)lockMapValue.get(0);
        }
        return null;
    }

    protected static void setActiveLockingInstance(String applname, String filename, RemoteProfile aRemoteProfile) {
        String profileKey = applname + KEY_SEPARATOR_STRING + filename;
        if (activeLockMap.containsKey(profileKey)) {
            activeLockMap.remove(profileKey);
        }
        ArrayList<Object> lockMapValue = new ArrayList<Object>();
        lockMapValue.add(0, aRemoteProfile);
        lockMapValue.add(1, new Date());
        activeLockMap.put(profileKey, lockMapValue);
    }

    protected static void removeActiveLockingInstance(String applname, String filename) {
        String profileKey = applname + KEY_SEPARATOR_STRING + filename;
        if (activeLockMap.containsKey(profileKey)) {
            activeLockMap.remove(profileKey);
        }
    }

    public static void cleanHangingLocks() {
        RemoteProfile unlockProfile = new RemoteProfile("", "");
        Set lockMapKeySet = activeLockMap.keySet();
        Iterator lockMapIter = lockMapKeySet.iterator();
        while (lockMapIter.hasNext()) {
            String nextFileName;
            String nextApplName;
            String nextLockMapKey = (String)lockMapIter.next();
            int sepIndex = nextLockMapKey.indexOf(KEY_SEPARATOR_STRING);
            if (sepIndex < 0) {
                nextApplName = "";
                nextFileName = nextLockMapKey;
            } else if (sepIndex < nextLockMapKey.length()) {
                nextApplName = nextLockMapKey.substring(0, sepIndex);
                nextFileName = nextLockMapKey.substring(sepIndex + 1);
            } else {
                nextApplName = nextLockMapKey;
                nextFileName = "";
            }
            unlockProfile.setApplication(nextApplName);
            unlockProfile.setProfileName(nextFileName);
            try {
                unlockProfile.removeProfileLock();
            }
            catch (DBException dbe) {
                myLogger.debug("DB Exception thrown during lock cleanup", dbe);
            }
            catch (AccessException ace) {
                myLogger.debug("Access Exception thrown during lock cleanup", ace);
            }
        }
        activeLockMap.clear();
        myLogger.debug("All profile locks cleaned up.");
    }

    private void removeProfileLock() throws AccessException, DBException {
        if (this.profileLocker == null) {
            if (this.dataAccessFactory != null) {
                this.profileLocker = this.dataAccessFactory.newProfileLock();
            } else {
                throw new DBException("Data access factory not set");
            }
        }
        try {
            this.profileLocker.freeProfile(this.myApplication, this.myProfileName);
        }
        catch (DBException dbe) {
            myLogger.debug("Error during free of a profile", dbe);
            throw dbe;
        }
    }

    protected String getApplication() {
        return this.myApplication;
    }

    protected void setApplication(String applname) {
        this.myApplication = applname;
    }

    protected String getProfileName() {
        return this.myProfileName;
    }

    protected void setProfileName(String filename) {
        this.myProfileName = filename;
    }

    protected IProfileLock getProfileLocker() {
        return this.profileLocker;
    }

    protected void setProfileLocker(IProfileLock aProfilesLock) {
        this.profileLocker = aProfilesLock;
    }

    protected IProfileFactory getDataAccessFactory() {
        return this.dataAccessFactory;
    }

    protected void setDataAccessFactory(IProfileFactory aProfileFactory) {
        this.dataAccessFactory = aProfileFactory;
    }

    protected boolean isDoLocalLocking() {
        return this.doLocalLocking;
    }

    protected void setDoLocalLocking(boolean aLockingFlag) {
        this.doLocalLocking = aLockingFlag;
    }

    protected HashMap getSectionHashMap() {
        return this.remoteSectionHashMap;
    }

    protected void setSectionHashmap(HashMap aSectionHashMap) {
        this.remoteSectionHashMap = aSectionHashMap;
    }

    protected boolean getProfileMapFilled() {
        return this.remoteProfileMapFilled;
    }

    protected void setProfileMapFilled(boolean aFlag) {
        this.remoteProfileMapFilled = aFlag;
    }

    protected Document getProfileDocument() {
        return this.remoteProfileDocument;
    }

    protected void setProfileDocument(Document aProfileDocument) {
        this.remoteProfileDocument = aProfileDocument;
    }

    protected boolean getProfileForFile() {
        return this.remoteProfileForFile;
    }

    protected void setProfileForFile(boolean aFlag) {
        this.remoteProfileForFile = aFlag;
    }

    public String getParameter(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    private ProfileParameter getParameterFromMap(String section, String name) {
        HashMap defaultSectionMap;
        Object defaultParamObject;
        HashMap reqSectionMap;
        Object reqParamObject;
        Object reqSectionObject;
        if (section != null && section.length() != 0 && !section.equals(DEFAULT_SECTION) && (reqSectionObject = this.remoteSectionHashMap.get(section)) != null && (reqParamObject = (reqSectionMap = ((ProfileSection)reqSectionObject).getParameterMap()).get(name)) != null) {
            return (ProfileParameter)reqParamObject;
        }
        Object defaultSectionObject = this.remoteSectionHashMap.get(DEFAULT_SECTION);
        if (defaultSectionObject != null && (defaultParamObject = (defaultSectionMap = ((ProfileSection)defaultSectionObject).getParameterMap()).get(name)) != null) {
            return (ProfileParameter)defaultParamObject;
        }
        return null;
    }

    public String getParameterDefault(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.getDefaultValue();
        }
        return null;
    }

    public String getParameterDescription(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.getDescription();
        }
        return null;
    }

    public String getParameterType(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.getType();
        }
        return null;
    }

    public String getParameterOwner(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.getOwner();
        }
        return null;
    }

    public String getParameterSeverity(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.getSeverity();
        }
        return null;
    }

    public boolean isParameterVisible(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.isVisible();
        }
        return false;
    }

    public String getParameterFirstRelease(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.getSince();
        }
        return null;
    }

    public String getParameterLastRelease(String section, String name) {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            return parameter.getTill();
        }
        return null;
    }

    public String getSectionDescription(String sectionName) {
        Object reqSectionObject;
        if (sectionName != null && sectionName.length() != 0 && (reqSectionObject = this.remoteSectionHashMap.get(sectionName)) != null) {
            return ((ProfileSection)reqSectionObject).getDescription();
        }
        return null;
    }

    public String[] findParameter(String name) {
        ArrayList<String> foundSections = new ArrayList<String>();
        Set allSections = this.remoteSectionHashMap.entrySet();
        Iterator iter = allSections.iterator();
        while (iter.hasNext()) {
            Map.Entry nextEntry = iter.next();
            HashMap nextMap = ((ProfileSection)nextEntry.getValue()).getParameterMap();
            if (name != null && name.length() != 0 && !nextMap.containsKey(name)) continue;
            foundSections.add((String)nextEntry.getKey());
        }
        return foundSections.toArray(new String[0]);
    }

    public ArrayList listContent() {
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        Set sectionEntries = this.remoteSectionHashMap.entrySet();
        Iterator sectionIter = sectionEntries.iterator();
        while (sectionIter.hasNext()) {
            Map.Entry nextSectionEntry = sectionIter.next();
            String[] sectElem = new String[]{(String)nextSectionEntry.getKey(), "", ""};
            paramList.add(sectElem);
            HashMap nextParameterMap = ((ProfileSection)nextSectionEntry.getValue()).getParameterMap();
            Set parameterEntries = nextParameterMap.entrySet();
            Iterator parameterIter = parameterEntries.iterator();
            while (parameterIter.hasNext()) {
                Map.Entry nextParameterEntry = parameterIter.next();
                ProfileParameter nextParam = (ProfileParameter)nextParameterEntry.getValue();
                String[] nextElem = new String[]{(String)nextSectionEntry.getKey(), (String)nextParameterEntry.getKey(), nextParam.getValue()};
                paramList.add(nextElem);
            }
        }
        return paramList;
    }

    public ArrayList listSection(String sectionName) {
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        Object reqSectionObject = this.remoteSectionHashMap.get(sectionName);
        if (reqSectionObject != null) {
            HashMap reqSectionMap = ((ProfileSection)reqSectionObject).getParameterMap();
            Set parameterEntries = reqSectionMap.entrySet();
            Iterator parameterIter = parameterEntries.iterator();
            while (parameterIter.hasNext()) {
                Map.Entry nextParameterEntry = parameterIter.next();
                ProfileParameter nextParam = (ProfileParameter)nextParameterEntry.getValue();
                String[] nextElem = new String[]{(String)nextParameterEntry.getKey(), nextParam.getValue()};
                paramList.add(nextElem);
            }
        }
        return paramList;
    }

    public Document generateDocument() {
        DocumentBuilder DomBuilder;
        try {
            DocumentBuilderFactory documentBuilderFactory = domFactory;
            synchronized (documentBuilderFactory) {
                DomBuilder = domFactory.newDocumentBuilder();
            }
        }
        catch (ParserConfigurationException pce) {
            myLogger.debug("XML parser not configured", pce);
            return null;
        }
        if (this.remoteProfileDocument == null) {
            return this.myXMLUtil.createProfileDocument(DomBuilder, this.remoteSectionHashMap);
        }
        String xmlRepresentation = this.buildXMLString(this.remoteProfileDocument);
        if (xmlRepresentation == null) {
            myLogger.debug("Internal XML parser error, unable to build the XML document for the profile.");
            return null;
        }
        RemoteProfile copyProfile = new RemoteProfile(this.myApplication, this.myProfileName);
        try {
            copyProfile.readRemoteProfile(new InputSource(new ByteArrayInputStream(xmlRepresentation.getBytes(PROFILE_ENCODING))));
        }
        catch (DBException dbe) {
            myLogger.debug("XML parser error during transform + parse, a new document is generated instead of a copy", dbe);
            return this.myXMLUtil.createProfileDocument(DomBuilder, this.remoteSectionHashMap);
        }
        catch (UnsupportedEncodingException unsee) {
            throw new InternalError(unsee.toString());
        }
        Document result = copyProfile.remoteProfileDocument;
        return result;
    }

    private void checkAccess(String operation, String section, String name, String value) throws AccessException {
        RemoteProfile activeModifier;
        if (this.doLocalLocking && !this.remoteProfileForFile && (activeModifier = RemoteProfile.getActiveLockingInstance(this.myApplication, this.myProfileName, 0L)) != this) {
            String objMsg = null;
            if (name != null) {
                objMsg = " of \"" + name.toString();
                if (value != null) {
                    objMsg = objMsg + ", " + value.toString();
                }
            }
            objMsg = objMsg != null ? objMsg + "\" in section \"" + section + "\"" : " of section \"" + section + "\"";
            String errMsg = "Profile not locked for " + operation + objMsg;
            myLogger.debug(errMsg);
            throw new AccessException(errMsg);
        }
    }

    public void createSection(String section) throws AccessException {
        this.checkAccess("create", section, null, null);
        if (section == null || section.length() == 0) {
            return;
        }
        if (!this.remoteSectionHashMap.containsKey(section)) {
            ProfileSection mySection = new ProfileSection(section);
            this.remoteSectionHashMap.put(section, mySection);
        }
        this.myXMLUtil.findOrAddSection(this.remoteProfileDocument, section);
    }

    public void setParameter(String section, String name, String value) throws AccessException {
        HashMap mySectionMap;
        this.checkAccess("change", section, name, value);
        if (section == null || section.length() == 0 || name == null || name.length() == 0) {
            return;
        }
        if (!this.remoteSectionHashMap.containsKey(section)) {
            ProfileSection mySection = new ProfileSection(section);
            mySectionMap = mySection.getParameterMap();
            this.remoteSectionHashMap.put(section, mySection);
        } else {
            mySectionMap = ((ProfileSection)this.remoteSectionHashMap.get(section)).getParameterMap();
        }
        ProfileParameter currParameter = this.getParameterFromMap(section, name);
        if (currParameter != null) {
            currParameter.setValue(value);
        } else {
            currParameter = new ProfileParameter(null, name, value);
            mySectionMap.put(name, currParameter);
        }
        this.myXMLUtil.updateOrInsertParameter(this.remoteProfileDocument, section, currParameter);
    }

    public void setParameterDefault(String section, String name, String value) throws AccessException {
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter == null) {
            String errMsg = "Name not found to set the default value: \"" + name + "\" in section \"" + section + "\"";
            myLogger.debug(errMsg);
            throw new AccessException(errMsg);
        }
        parameter.setDefaultValue(value);
        this.myXMLUtil.setParameterDefault(this.remoteProfileDocument, section, name, value);
    }

    public void deleteParameter(String section, String name) throws AccessException {
        this.checkAccess("delete", section, name, null);
        if (section == null || section.length() == 0 || name == null || name.length() == 0) {
            return;
        }
        if (!this.remoteSectionHashMap.containsKey(section)) {
            return;
        }
        HashMap mySectionMap = ((ProfileSection)this.remoteSectionHashMap.get(section)).getParameterMap();
        if (mySectionMap.containsKey(name)) {
            mySectionMap.remove(name);
            this.myXMLUtil.deleteParameter(this.remoteProfileDocument, section, name);
        }
        myLogger.debug("Parameter " + name + " in section " + section + " of profile " + this.myApplication + ", " + this.myProfileName + " deleted.");
    }

    public void resetParameter(String section, String name) throws AccessException {
        String defValue;
        ProfileParameter parameter = this.getParameterFromMap(section, name);
        if (parameter != null) {
            defValue = parameter.getDefaultValue();
            if (defValue == null) {
                defValue = "";
            }
        } else {
            String errMsg = "Name not found to reset the value: \"" + name + "\" in section \"" + section + "\"";
            myLogger.debug(errMsg);
            throw new AccessException(errMsg);
        }
        this.setParameter(section, name, defValue);
    }

    public void clearSection(String section) throws AccessException {
        this.checkAccess("clear", section, null, null);
        if (section == null || section.length() == 0) {
            this.remoteSectionHashMap.clear();
            this.remoteProfileDocument = null;
        } else {
            if (!this.remoteSectionHashMap.containsKey(section)) {
                return;
            }
            List clearedSections = this.myXMLUtil.clearSection(this.remoteProfileDocument, section);
            Iterator iter = clearedSections.iterator();
            while (iter.hasNext()) {
                String nextSectionName = (String)iter.next();
                this.remoteSectionHashMap.remove(nextSectionName);
            }
        }
        if (section == null) {
            myLogger.debug("All sections of profile " + this.myApplication + ", " + this.myProfileName + " cleared.");
        } else {
            myLogger.debug("Section " + section + " of profile " + this.myApplication + ", " + this.myProfileName + " cleared.");
        }
    }

    public void substituteContent(IRemoteProfile anRemoteProfile) throws AccessException {
        this.remoteProfileDocument = anRemoteProfile.generateDocument();
        if (this.remoteProfileDocument == null) {
            throw new AccessException("Failed to copy XML document (internal parser error)");
        }
        this.myXMLUtil.cleanDeleteElements(this.remoteProfileDocument);
        this.remoteSectionHashMap.clear();
        Element docRootElem = this.remoteProfileDocument.getDocumentElement();
        this.myXMLUtil.scanDocument(this.remoteProfileDocument, docRootElem, this.remoteSectionHashMap);
        myLogger.debug("Profile content substituted for " + this.myApplication + ", " + this.myProfileName);
    }

    public void mergeContent(IRemoteProfile anRemoteProfile) throws AccessException {
        this.remoteProfileDocument = anRemoteProfile.generateDocument();
        if (this.remoteProfileDocument == null) {
            throw new AccessException("Failed to copy XML document (internal parser error)");
        }
        this.myXMLUtil.adaptMergeTarget(this.remoteProfileDocument, this.remoteSectionHashMap);
        this.remoteSectionHashMap.clear();
        Element docRootElem = this.remoteProfileDocument.getDocumentElement();
        this.myXMLUtil.scanDocument(this.remoteProfileDocument, docRootElem, this.remoteSectionHashMap);
        myLogger.debug("Profile content merged for " + this.myApplication + ", " + this.myProfileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseChanges() throws AccessException, DBException {
        RemoteProfile activeModifier;
        if (this.doLocalLocking && (activeModifier = RemoteProfile.getActiveLockingInstance(this.myApplication, this.myProfileName, 0L)) != this) {
            String errMsg = "Profile not locked for release of this instance";
            myLogger.debug(errMsg);
            throw new AccessException(errMsg);
        }
        if (this.dataAccessFactory == null) throw new DBException("Data access factory not set");
        IProfileAccess profileAccessor = this.dataAccessFactory.newProfileAccess();
        try {
            try {
                String xmlRepresentation = this.buildXMLString(null);
                if (xmlRepresentation != null) {
                    profileAccessor.setProfile(this.myApplication, this.myProfileName, xmlRepresentation);
                }
                myLogger.error("Unable to save profile changes due to an internal parser error. Please try to change the profile again.");
            }
            catch (DBException dbe) {
                myLogger.debug("unable to write the profile to media", dbe);
                throw dbe;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.removeProfileLock();
            if (!this.doLocalLocking) throw throwable;
            RemoteProfile.removeActiveLockingInstance(this.myApplication, this.myProfileName);
            throw throwable;
        }
        this.removeProfileLock();
        if (!this.doLocalLocking) return;
        RemoteProfile.removeActiveLockingInstance(this.myApplication, this.myProfileName);
    }

    public void revertChanges() throws AccessException, DBException {
        RemoteProfile activeModifier;
        if (this.doLocalLocking && (activeModifier = RemoteProfile.getActiveLockingInstance(this.myApplication, this.myProfileName, 0L)) != this) {
            String errMsg = "Profile not locked for revert of this instance";
            myLogger.debug(errMsg);
            throw new AccessException(errMsg);
        }
        this.removeProfileLock();
        if (this.doLocalLocking) {
            RemoteProfile.removeActiveLockingInstance(this.myApplication, this.myProfileName);
        }
    }

    protected void readRemoteProfileFromMedia() throws DBException {
        String profileString;
        if (this.dataAccessFactory == null) {
            throw new DBException("Data access factory not set");
        }
        IProfileAccess profileAccessor = this.dataAccessFactory.newProfileAccess();
        try {
            profileString = profileAccessor.getProfile(this.myApplication, this.myProfileName);
            int lp = profileString.length();
            if (lp == 0) {
                myLogger.debug("Empty profile read");
            }
        }
        catch (DBException dbe) {
            myLogger.debug("Unable to read the profile from media", dbe);
            throw dbe;
        }
        if (profileString.length() == 0) {
            this.remoteSectionHashMap.clear();
            this.remoteProfileDocument = null;
            this.remoteProfileMapFilled = true;
        } else {
            try {
                this.readRemoteProfile(new InputSource(new ByteArrayInputStream(profileString.getBytes(PROFILE_ENCODING))));
            }
            catch (UnsupportedEncodingException unsee) {
                throw new InternalError(unsee.toString());
            }
        }
    }

    protected void readRemoteProfileFromFile(String filePath, String fileName) throws DBException {
        BufferedReader reader;
        File readFile = new File(filePath, fileName);
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(readFile), PROFILE_ENCODING));
        }
        catch (FileNotFoundException fnfe) {
            myLogger.debug("Input file " + readFile.toString() + " not found", fnfe);
            throw new DBException(fnfe);
        }
        catch (UnsupportedEncodingException uee) {
            myLogger.debug("Unsupported encoding UTF-8", uee);
            throw new DBException(uee);
        }
        this.readRemoteProfile(new InputSource(reader));
        try {
            reader.close();
        }
        catch (IOException ioe) {
            myLogger.debug("IO error during close of file " + readFile.toString(), ioe);
        }
    }

    private void readRemoteProfile(InputSource profileContent) throws DBException {
        Document document = null;
        try {
            DocumentBuilder builder;
            DocumentBuilderFactory documentBuilderFactory = domFactory;
            synchronized (documentBuilderFactory) {
                builder = domFactory.newDocumentBuilder();
            }
            document = builder.parse(profileContent);
        }
        catch (IOException ioe) {
            myLogger.debug("I/O error during read of a profile", ioe);
            this.logInputStream(profileContent);
            throw new DBException(ioe);
        }
        catch (SAXException saxe) {
            myLogger.debug("DOM parser error during read of a profile", saxe);
            this.logInputStream(profileContent);
            throw new DBException(saxe);
        }
        catch (ParserConfigurationException pce) {
            myLogger.debug("DOM parser not configured for profile read", pce);
            this.logInputStream(profileContent);
            throw new DBException(pce);
        }
        this.remoteSectionHashMap.clear();
        if (document != null) {
            Element docRootElem = document.getDocumentElement();
            this.myXMLUtil.scanDocument(document, docRootElem, this.remoteSectionHashMap);
        }
        this.remoteProfileDocument = document;
        this.remoteProfileMapFilled = true;
    }

    private String buildXMLString(Document source) {
        TransformerFactory factory;
        ByteArrayOutputStream writeStream = new ByteArrayOutputStream(65536);
        Thread currentThread = Thread.currentThread();
        ClassLoader savedLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            factory = TransformerFactory.newInstance();
            Object var7_6 = null;
            currentThread.setContextClassLoader(savedLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            currentThread.setContextClassLoader(savedLoader);
            throw throwable;
        }
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("encoding", PROFILE_ENCODING);
            Document writeDoc = source == null ? this.generateDocument() : source;
            if (writeDoc == null) {
                myLogger.debug("Null returned by transform, unable to generate XML");
                return null;
            }
            transformer.transform(new DOMSource(writeDoc), new StreamResult(writeStream));
        }
        catch (Exception e) {
            myLogger.debug("Unspecific exception in XML transform, unable to build the XML representation of the profile.", e);
            return null;
        }
        try {
            return writeStream.toString(PROFILE_ENCODING);
        }
        catch (UnsupportedEncodingException unsee) {
            throw new InternalError(unsee.toString());
        }
    }

    private void logInputStream(InputSource inputSource) {
        int PORTION_SIZE = 132;
        myLogger.fine("Logging profile input source ...");
        InputStream contIn = inputSource.getByteStream();
        if (contIn == null) {
            Reader contRe = inputSource.getCharacterStream();
            if (contRe != null) {
                int nb;
                char[] logPortion = new char[132];
                try {
                    contRe.reset();
                }
                catch (IOException ioe) {
                    myLogger.debug("Unable to reset input reader during log of profile input source", ioe);
                }
                do {
                    try {
                        nb = contRe.read(logPortion, 0, 132);
                        if (nb > 0) {
                            String logString = new String(logPortion, 0, nb);
                            myLogger.fine(logString);
                            continue;
                        }
                        myLogger.fine("End of profile input reader");
                    }
                    catch (IOException ioe) {
                        myLogger.debug("IO exception during log of input reader", ioe);
                    }
                    break;
                } while (nb > 0);
            } else {
                myLogger.fine("No profile content found to log.");
            }
        } else {
            int nb;
            byte[] logPortion = new byte[132];
            try {
                contIn.reset();
            }
            catch (IOException ioe) {
                myLogger.debug("Unable to reset input stream during log of profile input source", ioe);
            }
            do {
                try {
                    myLogger.fine("Number of remaining bytes = " + contIn.available());
                    nb = contIn.read(logPortion, 0, 132);
                    if (nb > 0) {
                        String logString;
                        try {
                            logString = new String(logPortion, 0, nb, PROFILE_ENCODING);
                        }
                        catch (UnsupportedEncodingException uee) {
                            logString = "UnsupportedEncodingException";
                        }
                        myLogger.fine(logString);
                        continue;
                    }
                    myLogger.fine("End of profile input stream");
                }
                catch (IOException ioe) {
                    myLogger.debug("IO exception during log of input stream", ioe);
                }
                break;
            } while (nb > 0);
        }
    }

    public boolean writeXMLToFile(String filePath, String fileName) {
        TransformerFactory factory;
        File proFile = new File(filePath, fileName);
        Thread currentThread = Thread.currentThread();
        ClassLoader savedLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            factory = TransformerFactory.newInstance();
            Object var8_7 = null;
            currentThread.setContextClassLoader(savedLoader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            currentThread.setContextClassLoader(savedLoader);
            throw throwable;
        }
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", PROFILE_ENCODING);
            Document writeDoc = this.generateDocument();
            if (writeDoc == null) {
                myLogger.debug("Null returned by transform, unable to generate XML for file");
                return false;
            }
            FileOutputStream fos = new FileOutputStream(proFile);
            transformer.transform(new DOMSource(writeDoc), new StreamResult(fos));
            fos.close();
        }
        catch (Exception e) {
            myLogger.error("Unspecific exception during transform, unable to write the profile to file " + proFile.toString(), e);
            return false;
        }
        return true;
    }

    private static AbapConnect getAbapConnect() throws DBException {
        if (abapConnect == null) {
            abapConnect = new AbapConnect();
            abapConnect.setupDefaultJcoCommunication();
        }
        return abapConnect;
    }

    public static AbapConnect refreshAbapConnect() throws DBException {
        abapConnect = null;
        return RemoteProfile.getAbapConnect();
    }

    public static void main(String[] args) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            System.out.println("Enter file name to be modified or created:");
            System.out.print(" file name = ");
            String workFileName = in.readLine();
            System.out.println("Enter second file name to be merged to the first one:");
            System.out.print(" file name = ");
            String mergeFileName = in.readLine();
            System.out.println("Enter path to these files:");
            System.out.print(" path = ");
            String workPath = in.readLine();
            FSProfileFactory myProfileFactory = new FSProfileFactory(workPath);
            RemoteProfile testProfile = RemoteProfile.getRemoteProfileFromFactoryForUpdate("test", workFileName, myProfileFactory, true);
            RemoteProfile mergeProfile = RemoteProfile.getRemoteProfileFromFactoryForUpdate("merge", mergeFileName, myProfileFactory, true);
            String value1 = testProfile.getParameter(null, "LandscapeDirectoryDataProvider.user");
            System.out.println("value 1 = " + value1);
            String value2 = mergeProfile.getParameter("LandscapeDirectory", "com.sap.aii.landscapedirectory.serviceuser.language");
            System.out.println("value 2 = " + value2);
            String value2a = testProfile.getParameter(DEFAULT_SECTION, "com.sap.aii.repository.serviceuser.pwd");
            System.out.println("value 2a = " + value2a);
            String value3 = testProfile.getParameterDefault("LandscapeDirectory", "com.sap.aii.landscapedirectory.serviceuser.language");
            System.out.println("default value = " + value3);
            String value4 = testProfile.getParameterDescription("LandscapeDirectory", "com.sap.aii.landscapedirectory.serviceuser.language");
            System.out.println("parameter description = " + value4);
            String value5 = testProfile.getParameterType("LandscapeDirectory", "com.sap.aii.landscapedirectory.serviceuser.language");
            System.out.println("parameter type 1 = " + value5);
            String value6 = testProfile.getParameterType("LandscapeDirectory", "LcrTraceLevel");
            System.out.println("parameter type 2 = " + value6);
            String value7 = testProfile.getParameterSeverity("LandscapeDirectory", "PersistenceMode");
            System.out.println("parameter severity = " + value7);
            boolean value8 = testProfile.isParameterVisible("LandscapeDirectory", "com.sap.aii.landscapedirectory.serviceuser.pwd");
            System.out.println("parameter visibility = " + value8);
            String value9 = testProfile.getParameterOwner("LandscapeDirectory", "com.sap.aii.landscapedirectory.serviceuser.name");
            System.out.println("parameter owner = " + value9);
            String value10 = testProfile.getParameterFirstRelease("LandscapeDirectory", "com.sap.aii.landscapedirectory.serviceuser.language");
            System.out.println("parameter start = " + value10);
            String value11 = testProfile.getParameterLastRelease("LandscapeDirectory", "TestFlag");
            System.out.println("parameter end = " + value11);
            String[] value12 = testProfile.findParameter("formatter[FullTrace]");
            System.out.println(value12.toString());
            ArrayList value13 = testProfile.listSection("LandscapeDirectory");
            System.out.println(value13.toString());
            ArrayList value14 = testProfile.listContent();
            System.out.println(value14.toString());
            String value15 = testProfile.getSectionDescription("LandscapeDirectory");
            System.out.println("section description = " + value15);
            Document value16 = testProfile.generateDocument();
            System.out.println(value16.toString());
            testProfile.createSection("NewSection");
            testProfile.setParameter("NewSection", "TestParameter", "X");
            testProfile.setParameter("LandscapeDirectory", "NeuerParameter", "XXX");
            testProfile.setParameter("LandscapeDirectory", "LcrTraceLevel", "6");
            testProfile.setParameterDefault("LandscapeDirectory", "NeuerParameter", DEFAULT_SECTION);
            testProfile.setParameterDefault("LandscapeDirectory", "LcrTraceLevel", "1");
            testProfile.deleteParameter(DEFAULT_SECTION, "com.sap.aii.server.name.repository");
            testProfile.resetParameter("LandscapeDirectory", "LcrTraceLevel");
            testProfile.clearSection("XiBasisOas.ExclusiveLockService.Implementation");
            testProfile.mergeContent(mergeProfile);
            testProfile.releaseChanges();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        catch (AccessException ace) {
            System.out.println("Profile locked, aborted");
            return;
        }
        catch (DBException dbe) {
            dbe.printStackTrace();
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

