/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.rprof.dbprofiles.log.Logger;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class ProfileParameter {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$rprof$dbprofiles$ProfileParameter == null ? (class$com$sap$rprof$dbprofiles$ProfileParameter = ProfileParameter.class$("com.sap.rprof.dbprofiles.ProfileParameter")) : class$com$sap$rprof$dbprofiles$ProfileParameter).getName());
    static final String VAL_ENCODING = "UTF-8";
    static final String CFACTOR = "Moloko";
    static final int CRADIX = 29;
    private String name;
    private String type;
    private String value;
    private String defaultValue;
    private String description;
    private boolean visible;
    private String severity;
    private boolean delete;
    private boolean encoded;
    private String owner;
    private String since;
    private String till;
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$ProfileParameter;

    public ProfileParameter(String type, String name, String value) {
        this.init(type, name);
        this.setValue(value);
    }

    public ProfileParameter(String type, String name, String value, boolean valueEncoded) {
        this.init(type, name);
        if (valueEncoded) {
            this.value = value;
            this.encoded = true;
        } else {
            this.setValue(value);
        }
    }

    private void init(String type, String name) {
        this.type = type;
        this.name = name;
        if (type == null) {
            this.type = name.endsWith(".pwd") ? "pwd" : "string";
        }
        this.severity = "medium";
        this.visible = true;
        this.delete = false;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getSince() {
        return this.since;
    }

    public String getTill() {
        return this.till;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        if (this.encoded) {
            return ProfileParameter.decVal(this.value);
        }
        return this.value;
    }

    public String getDocumentValue() {
        return this.value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setDelete(boolean b) {
        this.delete = b;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setSeverity(String string) {
        this.severity = string;
    }

    public void setSince(String string) {
        this.since = string;
    }

    public void setTill(String string) {
        this.till = string;
    }

    public void setValue(String string) {
        if (this.type.equals("pwd")) {
            if (string.length() == 0) {
                this.value = string;
                this.encoded = true;
            } else {
                this.value = ProfileParameter.encVal(string);
                this.encoded = this.value != string;
            }
        } else {
            this.value = string;
            this.encoded = false;
        }
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    static String encVal(String val) {
        if (val.length() == 0) {
            return val;
        }
        try {
            byte[] ba1 = CFACTOR.getBytes(VAL_ENCODING);
            BigInteger bi1 = new BigInteger(ba1);
            byte[] ba2 = val.getBytes(VAL_ENCODING);
            BigInteger bi2 = new BigInteger(ba2);
            BigInteger product = bi1.multiply(bi2);
            return product.toString(29);
        }
        catch (UnsupportedEncodingException usee) {
            myLogger.debug("UnsupportedEncodingException thrown, try to use original value", usee);
            return val;
        }
    }

    private static String decVal(String val) {
        if (val.length() == 0) {
            return val;
        }
        try {
            byte[] ba1 = CFACTOR.getBytes(VAL_ENCODING);
            BigInteger bi1 = new BigInteger(ba1);
            BigInteger product = new BigInteger(val, 29);
            BigInteger bi2 = product.divide(bi1);
            byte[] ba2 = bi2.toByteArray();
            return new String(ba2, VAL_ENCODING);
        }
        catch (UnsupportedEncodingException usee) {
            myLogger.debug("UnsupportedEncodingException thrown, try to use original value", usee);
            return val;
        }
        catch (NumberFormatException nfe) {
            myLogger.debug("NumberFormatException thrown, try to use original value", nfe);
            return val;
        }
        catch (ArithmeticException ae) {
            myLogger.debug("ArithmeticException thrown, try to use original value", ae);
            return val;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

