/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.util.SecureStoreAccess;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;

public class ProfileDestinationStore
implements Serializable {
    static final long serialVersionUID = -1695705939745603560L;
    static final String RPROF_CLIENT_PARAM_NAME = "client";
    static final String RPROF_HOST_PARAM_NAME = "hostname";
    static final String RPROF_USER_PARAM_NAME = "user";
    static final String RPROF_PWD_PARAM_NAME = "password";
    static final String RPROF_LANG_PARAM_NAME = "language";
    static final String RPROF_SYSNUM_PARAM_NAME = "systemNumber";
    static final String destinationComment = "Destination properties to access the Exchange Profile";
    private static final int classVersion = 0;
    private int instanceVersion = 0;
    byte[] destinationStream = null;
    transient Properties destinationProperties;

    public ProfileDestinationStore() {
        this.destinationProperties = new Properties();
    }

    public ProfileDestinationStore(Properties connectProperties) {
        this.destinationProperties = (Properties)((Hashtable)connectProperties).clone();
    }

    public static ProfileDestinationStore getProfileDestination() throws AccessException {
        ProfileDestinationStore currentDests = SecureStoreAccess.loadConfigFromSecureStore();
        return currentDests;
    }

    public void setProfileDestination(String client, String host, String user, String password, String language, String sysnum) {
        this.destinationProperties.setProperty(RPROF_CLIENT_PARAM_NAME, client);
        this.destinationProperties.setProperty(RPROF_HOST_PARAM_NAME, host);
        this.destinationProperties.setProperty(RPROF_USER_PARAM_NAME, user);
        this.destinationProperties.setProperty(RPROF_PWD_PARAM_NAME, password);
        this.destinationProperties.setProperty(RPROF_LANG_PARAM_NAME, language);
        this.destinationProperties.setProperty(RPROF_SYSNUM_PARAM_NAME, sysnum);
    }

    public String getHost() {
        return this.destinationProperties.getProperty(RPROF_HOST_PARAM_NAME);
    }

    public int getSystemNumber() {
        int iport;
        String port = this.destinationProperties.getProperty(RPROF_SYSNUM_PARAM_NAME);
        if (port == null) {
            return -1;
        }
        try {
            iport = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        return iport;
    }

    public String getSystemNumberStr() {
        return this.destinationProperties.getProperty(RPROF_SYSNUM_PARAM_NAME);
    }

    public String getUser() {
        return this.destinationProperties.getProperty(RPROF_USER_PARAM_NAME);
    }

    String getPwd() {
        return this.destinationProperties.getProperty(RPROF_PWD_PARAM_NAME);
    }

    public String getLanguage() {
        return this.destinationProperties.getProperty(RPROF_LANG_PARAM_NAME);
    }

    public String getClient() {
        return this.destinationProperties.getProperty(RPROF_CLIENT_PARAM_NAME);
    }

    public Properties getProperties() {
        return this.destinationProperties;
    }

    public boolean isValid() {
        return this.getClient() != null && this.getUser() != null && this.getPwd() != null && this.getLanguage() != null;
    }

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        switch (this.instanceVersion) {
            default: 
        }
        this.instanceVersion = 0;
        this.buildDerivedProperties();
    }

    private void writeObject(ObjectOutputStream objOut) throws IOException {
        this.buildSerializedContent();
        objOut.defaultWriteObject();
    }

    private void buildDerivedProperties() throws IOException {
        if (this.destinationStream != null) {
            this.destinationProperties = new Properties();
            this.destinationProperties.load(new ByteArrayInputStream(this.destinationStream));
        }
    }

    private void buildSerializedContent() throws IOException {
        ByteArrayOutputStream destOut = new ByteArrayOutputStream();
        this.destinationProperties.store(destOut, destinationComment);
        this.destinationStream = destOut.toByteArray();
    }

    void dummyMethod() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream testBAOS = new ByteArrayOutputStream();
        this.writeObject(new ObjectOutputStream(testBAOS));
        byte[] testBA = testBAOS.toByteArray();
        this.readObject(new ObjectInputStream(new ByteArrayInputStream(testBA)));
    }
}

