/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.services.applocking.LogicalLocking;
import com.sap.engine.services.applocking.LogicalLockingFactory;
import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.IProfileLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JDBCProfileLock
implements IProfileLock {
    private static final String LOGICAL_LOCKING_DESCRIPTION = "Namespace for remote profile locks";
    private static final String LOGICAL_LOCKING_NAMESPACE = "com.sap.rprof";
    private static final String LOCK_NAME = "com.sap.rprof:AII_PROFILES";
    private static LogicalLockingFactory logicalLockingFactory;
    private LogicalLocking logicalLocking;
    private DBException rememberedException;

    public JDBCProfileLock() {
        try {
            if (logicalLockingFactory == null) {
                Thread currentThread = Thread.currentThread();
                ClassLoader saveLoader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(this.getClass().getClassLoader());
                try {
                    InitialContext initialContext = new InitialContext();
                    logicalLockingFactory = (LogicalLockingFactory)initialContext.lookup("LogicalLockingFactory");
                    Object var5_6 = null;
                    currentThread.setContextClassLoader(saveLoader);
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    currentThread.setContextClassLoader(saveLoader);
                    throw throwable;
                }
            }
            this.logicalLocking = logicalLockingFactory.createLogicalLocking(LOGICAL_LOCKING_NAMESPACE, LOGICAL_LOCKING_DESCRIPTION);
        }
        catch (NamingException ne) {
            this.rememberedException = new DBException(ne);
        }
        catch (TechnicalLockException tle) {
            this.rememberedException = new DBException((Exception)((Object)tle));
        }
    }

    public void lockProfile(String applName, String fileName) throws DBException, AccessException {
        this.throwRememberedException();
        String argument = this.checkArguments(applName, fileName);
        try {
            this.logicalLocking.lock((byte)2, LOCK_NAME, argument, 'X');
        }
        catch (LockException ex) {
            throw new DBException((Exception)((Object)ex));
        }
        catch (TechnicalLockException e) {
            throw new DBException((Exception)((Object)e));
        }
    }

    public void freeProfile(String applName, String fileName) throws DBException {
        this.throwRememberedException();
        String argument = this.checkArguments(applName, fileName);
        try {
            this.logicalLocking.unlock((byte)2, LOCK_NAME, argument, 'X');
        }
        catch (TechnicalLockException e) {
            throw new DBException((Exception)((Object)e));
        }
    }

    private String checkArguments(String applName, String fileName) throws DBException {
        if (applName == null || applName.length() < 1 || applName.length() > 10) {
            throw new DBException("APPLNAME must have 1 to 10 characters.");
        }
        if (fileName == null || fileName.length() < 1 || fileName.length() > 60) {
            throw new DBException("FILENAME must have 1 to 60 characters.");
        }
        return applName + ":" + fileName;
    }

    private void throwRememberedException() throws DBException {
        if (this.rememberedException != null) {
            throw this.rememberedException;
        }
    }
}

