/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.IProfileAccess;
import com.sap.rprof.dbprofiles.Util;
import com.sap.rprof.dbprofiles.jdbc.BC_RPROF_PROFILE;
import com.sap.rprof.dbprofiles.jdbc.RprofContextProvider;
import com.sap.rprof.dbprofiles.jdbc.SLDContext;
import com.sap.rprof.dbprofiles.log.LocationLogger;
import com.sap.rprof.dbprofiles.log.Logger;
import java.sql.SQLException;

public class JDBCProfile
implements IProfileAccess {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$rprof$dbprofiles$JDBCProfile == null ? (class$com$sap$rprof$dbprofiles$JDBCProfile = JDBCProfile.class$("com.sap.rprof.dbprofiles.JDBCProfile")) : class$com$sap$rprof$dbprofiles$JDBCProfile).getName());
    private SLDContext myDBContext;
    private boolean myLoggingFlag;
    public static final String DBCheckMessage = "Check your database for sanity or check your server logs and traces for more details";
    public static final String DBContextReleaseMessage = "Failed to release SQLJ database context. ";
    public static final String DBContextAcquireMessage = "Failed to acquire SQLJ database context. ";
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$JDBCProfile;

    public JDBCProfile(boolean logFlag) {
        this.myLoggingFlag = logFlag;
    }

    private void getContext() throws DBException {
        try {
            this.myDBContext = RprofContextProvider.getContext(this.myLoggingFlag);
        }
        catch (Exception e) {
            this.myDBContext = null;
            String tMsg = "Failed to acquire SQLJ database context. Check your database for sanity or check your server logs and traces for more details";
            LocationLogger.error(myLogger, tMsg, e, "(com/sap/rprof/dbprofiles/JDBCProfile.java:51)");
            throw new DBException(e);
        }
    }

    private void cleanup() throws Exception {
        if (this.myDBContext != null) {
            RprofContextProvider.releaseContext(this.myDBContext, this.myLoggingFlag);
            this.myDBContext = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getProfile(String applName, String fileName) throws DBException {
        BC_RPROF_PROFILE tabAcc = null;
        this.checkArguments(applName, fileName);
        try {
            try {
                this.getContext();
                if (BC_RPROF_PROFILE.s_exists(this.myDBContext, applName, fileName, this.myLoggingFlag)) {
                    tabAcc = BC_RPROF_PROFILE.s_select(this.myDBContext, applName, fileName, this.myLoggingFlag);
                } else {
                    LocationLogger.debug(myLogger, "JDBC profile " + applName + ", " + fileName + " not existing", "(com/sap/rprof/dbprofiles/JDBCProfile.java:84)");
                }
            }
            catch (SQLException sqle) {
                String tMsg = "Failed to test profile existence for application <" + applName + "> and profile <" + fileName + ">. " + DBCheckMessage;
                LocationLogger.error(myLogger, tMsg, sqle, "(com/sap/rprof/dbprofiles/JDBCProfile.java:89)");
                throw new DBException(sqle);
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            try {
                this.cleanup();
                throw throwable;
            }
            catch (Exception e) {
                String tMsg = "Failed to release SQLJ database context. Check your database for sanity or check your server logs and traces for more details";
                LocationLogger.error(myLogger, tMsg, e, "(com/sap/rprof/dbprofiles/JDBCProfile.java:98)");
                throw new DBException(e);
            }
        }
        try {}
        catch (Exception e) {
            String tMsg = "Failed to release SQLJ database context. Check your database for sanity or check your server logs and traces for more details";
            LocationLogger.error(myLogger, tMsg, e, "(com/sap/rprof/dbprofiles/JDBCProfile.java:98)");
            throw new DBException(e);
        }
        this.cleanup();
        String tResult = tabAcc != null ? Util.fromUTF8(tabAcc.ivarPROFILE_XML) : "";
        if (tResult != null) {
            LocationLogger.debug(myLogger, "tResult", tResult, "(com/sap/rprof/dbprofiles/JDBCProfile.java:109)");
            return tResult;
        }
        LocationLogger.debug(myLogger, "tResult: <null>", "(com/sap/rprof/dbprofiles/JDBCProfile.java:111)");
        return tResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setProfile(String applName, String fileName, String newContent) throws DBException {
        this.checkArguments(applName, fileName);
        BC_RPROF_PROFILE tabAcc = new BC_RPROF_PROFILE(applName, fileName);
        byte[] tBytes = Util.toUTF8(newContent);
        BC_RPROF_PROFILE tabMod = new BC_RPROF_PROFILE(applName, fileName, newContent, tBytes);
        try {
            try {
                this.getContext();
                tabAcc.modify(this.myDBContext, tabMod, this.myLoggingFlag);
            }
            catch (SQLException sqle) {
                String tMsg = "Failed to modify profile content for application <" + applName + "> and profile <" + fileName + ">. " + DBCheckMessage;
                LocationLogger.error(myLogger, tMsg, sqle, "(com/sap/rprof/dbprofiles/JDBCProfile.java:147)");
                throw new DBException(sqle);
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            try {
                this.cleanup();
                throw throwable;
            }
            catch (Exception e) {
                String tMsg = "Failed to release SQLJ database context. Check your database for sanity or check your server logs and traces for more details";
                LocationLogger.error(myLogger, tMsg, e, "(com/sap/rprof/dbprofiles/JDBCProfile.java:156)");
                throw new DBException(e);
            }
        }
        try {}
        catch (Exception e) {
            String tMsg = "Failed to release SQLJ database context. Check your database for sanity or check your server logs and traces for more details";
            LocationLogger.error(myLogger, tMsg, e, "(com/sap/rprof/dbprofiles/JDBCProfile.java:156)");
            throw new DBException(e);
        }
        this.cleanup();
    }

    private void checkArguments(String applName, String fileName) throws DBException {
        if (applName == null || applName.length() < 1 || applName.length() > 10) {
            throw new DBException("APPLNAME must have 1 to 10 characters.");
        }
        if (fileName == null || fileName.length() < 1 || fileName.length() > 60) {
            throw new DBException("FILENAME must have 1 to 60 characters.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

