/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.IProfileAccess;
import com.sap.rprof.dbprofiles.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class FSProfileAccess
implements IProfileAccess {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$rprof$dbprofiles$FSProfileAccess == null ? (class$com$sap$rprof$dbprofiles$FSProfileAccess = FSProfileAccess.class$("com.sap.rprof.dbprofiles.FSProfileAccess")) : class$com$sap$rprof$dbprofiles$FSProfileAccess).getName());
    private static final String PROFILE_ENCODING = "UTF-8";
    private String profileDir;
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$FSProfileAccess;

    public FSProfileAccess(String accessPath) {
        this.profileDir = accessPath;
    }

    public String getProfilePath() {
        return this.profileDir;
    }

    public void setProfilePath(String accessPath) {
        this.profileDir = accessPath;
    }

    public String getProfile(String applName, String fileName) throws DBException {
        int nc;
        BufferedReader reader;
        String myProfileString = null;
        StringBuffer profileBuffer = new StringBuffer(65536);
        File readFile = new File(this.profileDir, fileName);
        char[] inbuf = new char[512];
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(readFile), PROFILE_ENCODING));
        }
        catch (FileNotFoundException fnfe) {
            myLogger.debug("Profile input file " + readFile.toString() + " not found", fnfe);
            return "";
        }
        catch (UnsupportedEncodingException uee) {
            myLogger.error("Unsupported encoding, change the profile encoding from UTF-8 to UTF-8.", uee);
            throw new DBException(uee);
        }
        do {
            try {
                nc = reader.read(inbuf, 0, 512);
                if (nc <= 0) continue;
                profileBuffer.append(inbuf, 0, nc);
            }
            catch (IOException ioe) {
                myLogger.error("IO error during read of profile file " + readFile.toString() + ", check the file system for sanity.", ioe);
                throw new DBException(ioe);
            }
        } while (nc >= 0);
        try {
            reader.close();
        }
        catch (IOException ioe) {
            myLogger.debug("IO error during close of profile file " + readFile.toString(), ioe);
        }
        myProfileString = profileBuffer.toString();
        return myProfileString;
    }

    public void setProfile(String applName, String fileName, String contents) throws DBException {
        OutputStreamWriter myFileWriter;
        File writeFile = new File(this.profileDir, fileName);
        try {
            myFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(writeFile), PROFILE_ENCODING);
            myFileWriter.write(contents);
        }
        catch (IOException ioe) {
            myLogger.error("IO error during write of profile file " + writeFile.toString() + ", check the file system for sanity.", ioe);
            throw new DBException(ioe);
        }
        try {
            myFileWriter.close();
        }
        catch (IOException ioe) {
            myLogger.debug("IO error during close of profile file " + writeFile.toString(), ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

