/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.RemoteProfile;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;

public class ExchangeProfile
extends RemoteProfile {
    public static final String exchangeApplication = "AIICOMMON";
    public static final String exchangeProfileName = "exchange_profile.xml";

    private ExchangeProfile() {
        super(exchangeApplication, exchangeProfileName);
    }

    public static ExchangeProfile getExchangeProfile() throws DBException {
        RemoteProfile myRemoteProfile = RemoteProfile.getRemoteProfile(exchangeApplication, exchangeProfileName);
        ExchangeProfile myExchangeProfile = new ExchangeProfile();
        myExchangeProfile.setSectionHashmap(myRemoteProfile.getSectionHashMap());
        myExchangeProfile.setProfileMapFilled(myRemoteProfile.getProfileMapFilled());
        myExchangeProfile.setProfileDocument(myRemoteProfile.getProfileDocument());
        myExchangeProfile.setProfileForFile(myRemoteProfile.getProfileForFile());
        myExchangeProfile.setDataAccessFactory(myRemoteProfile.getDataAccessFactory());
        return myExchangeProfile;
    }

    public static synchronized ExchangeProfile getExchangeProfileForUpdate() throws AccessException, DBException {
        RemoteProfile myRemoteProfile = RemoteProfile.getRemoteProfileForUpdate(exchangeApplication, exchangeProfileName);
        ExchangeProfile myExchangeProfile = new ExchangeProfile();
        myExchangeProfile.setProfileLocker(myRemoteProfile.getProfileLocker());
        myExchangeProfile.setSectionHashmap(myRemoteProfile.getSectionHashMap());
        myExchangeProfile.setProfileMapFilled(myRemoteProfile.getProfileMapFilled());
        myExchangeProfile.setProfileDocument(myRemoteProfile.getProfileDocument());
        myExchangeProfile.setProfileForFile(myRemoteProfile.getProfileForFile());
        myExchangeProfile.setDataAccessFactory(myRemoteProfile.getDataAccessFactory());
        myExchangeProfile.setDoLocalLocking(myRemoteProfile.isDoLocalLocking());
        RemoteProfile.setActiveLockingInstance(exchangeApplication, exchangeProfileName, myExchangeProfile);
        return myExchangeProfile;
    }

    public static ExchangeProfile getExchangeProfileFromFile(String realFilePath, String realFileName) throws DBException {
        ExchangeProfile theProfile = new ExchangeProfile();
        theProfile.readRemoteProfileFromFile(realFilePath, realFileName);
        theProfile.setProfileForFile(true);
        return theProfile;
    }

    public static void main(String[] args) {
        ExchangeProfile dbProfile;
        ExchangeProfile fileProfile;
        Properties connectProperties = new Properties();
        connectProperties.setProperty("client", args[0]);
        connectProperties.setProperty("user", args[1]);
        connectProperties.setProperty("password", args[2]);
        connectProperties.setProperty("language", args[3]);
        connectProperties.setProperty("hostname", args[4]);
        connectProperties.setProperty("systemNumber", args[5]);
        try {
            FileOutputStream outStream = new FileOutputStream("dbconnect.properties");
            connectProperties.store(outStream, "Properties for Access to the Exchange Profile");
        }
        catch (Exception e) {
            // empty catch block
        }
        RemoteProfile.setAbapConnect(args[0], args[1], args[2], args[3], args[4], args[5]);
        try {
            fileProfile = ExchangeProfile.getExchangeProfileFromFile(".", exchangeProfileName);
        }
        catch (DBException de) {
            System.out.println("Unable to read the profile from file exchange_profile.xml");
            return;
        }
        try {
            dbProfile = ExchangeProfile.getExchangeProfileForUpdate();
        }
        catch (AccessException ae) {
            System.out.println("Cannot access profile for update: " + ae.getMessage());
            return;
        }
        catch (DBException de) {
            System.out.println("Error during read profile from DB");
            return;
        }
        System.out.println("Description of parameter PersistenceMode");
        System.out.println("======================================================");
        System.out.println(fileProfile.getParameterDescription("LandscapeDirectory", "PersistenceMode"));
        ArrayList fileContent = fileProfile.listContent();
        System.out.println("File content: (section / name / value)");
        System.out.println("======================================================");
        int i = 0;
        while (i < fileContent.size()) {
            String[] paraLine = (String[])fileContent.get(i);
            System.out.println(paraLine[0] + " / " + paraLine[1] + " / " + paraLine[2]);
            ++i;
        }
        ArrayList oldContent = dbProfile.listContent();
        System.out.println("======================================================");
        System.out.println("Old DB content: (section / name / value)");
        System.out.println("======================================================");
        int i2 = 0;
        while (i2 < oldContent.size()) {
            String[] paraLine = (String[])oldContent.get(i2);
            System.out.println(paraLine[0] + " / " + paraLine[1] + " / " + paraLine[2]);
            ++i2;
        }
        try {
            dbProfile.substituteContent(fileProfile);
        }
        catch (AccessException ae) {
            System.out.println("Unable to subsitute profile content: " + ae.getMessage());
        }
        ArrayList newContent = dbProfile.listContent();
        System.out.println("======================================================");
        System.out.println("New DB content: (section / name / value)");
        System.out.println("======================================================");
        int i3 = 0;
        while (i3 < newContent.size()) {
            String[] paraLine = (String[])newContent.get(i3);
            System.out.println(paraLine[0] + " / " + paraLine[1] + " / " + paraLine[2]);
            ++i3;
        }
        System.out.println("======================================================");
        System.out.println("              Data Manipulation Tests");
        System.out.println("======================================================");
        try {
            String[] hostSections = dbProfile.findParameter("host");
            int i4 = 0;
            while (i4 < hostSections.length) {
                System.out.println("Section with parameter \"host\": " + hostSections[i4]);
                ++i4;
            }
            dbProfile.deleteParameter("default", "LandscapeDirectoryPort");
            dbProfile.deleteParameter("default", "FantasieParameter");
            System.out.println("2 Parameters in section \"default\" deleted");
            dbProfile.setParameter("LandscapeDirectory", "PersistenceMode", "FPERS");
            System.out.println("Parameter \"PersistenceMode\" in section \"LandscapeDirectory\" changed");
            String updatedValue = dbProfile.getParameter("LandscapeDirectory", "host");
            System.out.println("Updated value = " + updatedValue);
            dbProfile.createSection("LandscapeDirectory2");
            dbProfile.setParameter("LandscapeDirectory2", "host", "P12345");
            dbProfile.setParameter("LandscapeDirectory2", "port", "1080");
            String insertedValue = dbProfile.getParameter("LandscapeDirectory2", "host");
            System.out.println("Inserted value = " + insertedValue);
            dbProfile.clearSection("IntegrationRepository");
            dbProfile.clearSection("Fantasie-Section");
            System.out.println("Sections IntegrationRepository and Fantasie-Section removed");
        }
        catch (AccessException ae) {
            System.out.println("Access Exception: " + ae.getMessage());
        }
        try {
            dbProfile.releaseChanges();
        }
        catch (AccessException ae) {
            System.out.println("Unable to release profile content: " + ae.getMessage());
            return;
        }
        catch (DBException dbe) {
            System.out.println("Unable to write profile content to DB: " + dbe.getMessage());
            return;
        }
        ExchangeProfile writeProfile = dbProfile;
        if (writeProfile.writeXMLToFile(".", "exchange_prof_new.xml")) {
            System.out.println("XML Result written to file exchange_prof_new.xml");
        } else {
            System.out.println("Error during write to file");
        }
    }
}

