/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.JCO;
import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.IProfileLock;
import com.sap.rprof.dbprofiles.log.Logger;

public class DBProfilesLock
implements IProfileLock {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$rprof$dbprofiles$DBProfilesLock == null ? (class$com$sap$rprof$dbprofiles$DBProfilesLock = DBProfilesLock.class$("com.sap.rprof.dbprofiles.DBProfilesLock")) : class$com$sap$rprof$dbprofiles$DBProfilesLock).getName());
    private static final String RFC_LOCK_PROFILE = "LCRDB_LOCK_PROFILE";
    private static final String RFC_FREE_PROFILE = "LCRDB_FREE_PROFILE";
    private static final int GC_FOREIGN_LOCK = 104;
    private static final int GC_NO_SUCH_PROFILE = 207;
    private static final String P_APPLNAME = "APPLNAME";
    private static final String P_FILENAME = "FILENAME";
    private static final String P_RETURN = "RETURN";
    private static final String P_PROFILE = "PROFILE";
    private JCO.Client jcoClient;
    private boolean isConnected = false;
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$DBProfilesLock;

    public DBProfilesLock(String aSAPClient, String aUserId, String aPassword, String aLanguage, String aHostname, String aSystemNumber) {
        this.jcoClient = JCO.createClient((String)aSAPClient, (String)aUserId, (String)aPassword, (String)aLanguage, (String)aHostname, (String)aSystemNumber);
    }

    public DBProfilesLock(String aSAPClient, String aUserId, String aPassword, String aLanguage, String aMSHost, String aR3Name, String aGroup) {
        this.jcoClient = JCO.createClient((String)aSAPClient, (String)aUserId, (String)aPassword, (String)aLanguage, (String)aMSHost, (String)aR3Name, (String)aGroup);
    }

    public DBProfilesLock(JCO.Client aJcoClient) {
        this.jcoClient = aJcoClient;
    }

    public void lockProfile(String applName, String fileName) throws DBException, AccessException {
        this.checkArguments(applName, fileName);
        try {
            if (!this.isConnected) {
                this.jcoClient.connect();
            }
            this.isConnected = true;
            try {
                JCO.Function jcoFunction = this.initFunction(RFC_LOCK_PROFILE, applName, fileName, null);
                this.jcoClient.execute(jcoFunction);
                if (this.checkReturn(jcoFunction) == 104) {
                    throw new AccessException("Profile already locked by another session running remote, please retry later.");
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
        catch (JCO.Exception jcoEx) {
            throw new DBException((Exception)((Object)jcoEx));
        }
    }

    /*
     * Loose catch block
     */
    public void freeProfile(String applName, String fileName) throws DBException {
        block10: {
            this.checkArguments(applName, fileName);
            try {
                if (!this.isConnected) {
                    this.jcoClient.connect();
                }
                JCO.Function jcoFunction = this.initFunction(RFC_FREE_PROFILE, applName, fileName, null);
                this.jcoClient.execute(jcoFunction);
                this.checkReturn(jcoFunction);
                Object var5_6 = null;
                try {
                    this.jcoClient.disconnect();
                    this.isConnected = false;
                }
                catch (JCO.Exception jcoe) {
                    myLogger.debug("JCO exception during disconnect", jcoe);
                }
                break block10;
                {
                    catch (JCO.Exception jcoEx) {
                        throw new DBException((Exception)((Object)jcoEx));
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        this.jcoClient.disconnect();
                        this.isConnected = false;
                    }
                    catch (JCO.Exception jcoe) {
                        myLogger.debug("JCO exception during disconnect", jcoe);
                    }
                    throw throwable;
                }
            }
            catch (JCO.Exception jcoEx) {
                throw new DBException((Exception)((Object)jcoEx));
            }
        }
    }

    private void checkArguments(String applName, String fileName) throws DBException {
        if (applName == null || applName.length() < 1 || applName.length() > 10) {
            throw new DBException("APPLNAME must have 1 to 10 characters.");
        }
        if (fileName == null || fileName.length() < 1 || fileName.length() > 60) {
            throw new DBException("FILENAME must have 1 to 60 characters.");
        }
    }

    private JCO.Function initFunction(String functionName, String applName, String fileName, String contents) {
        JCO.Repository repository = new JCO.Repository("AII_PROFILES", this.jcoClient);
        IFunctionTemplate jcoFunctionTemplate = repository.getFunctionTemplate(functionName);
        JCO.Function jcoFunction = jcoFunctionTemplate.getFunction();
        JCO.ParameterList importParams = jcoFunction.getImportParameterList();
        importParams.setValue(applName, P_APPLNAME);
        importParams.setValue(fileName, P_FILENAME);
        if (contents != null) {
            importParams.setValue(contents, P_PROFILE);
        }
        return jcoFunction;
    }

    private int checkReturn(JCO.Function jcoFunction) throws DBException {
        int returnValue = jcoFunction.getExportParameterList().getField(P_RETURN).getInt();
        switch (returnValue) {
            case 0: {
                break;
            }
            case 207: {
                break;
            }
            case 104: {
                break;
            }
            default: {
                throw new DBException("RFC call returned an error code: " + returnValue);
            }
        }
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

