/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.mw.jco.JCO;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.IProfileAccess;
import com.sap.rprof.dbprofiles.log.Logger;

public class DBProfiles
implements IProfileAccess {
    private static final Logger myLogger = Logger.getLogger((class$com$sap$rprof$dbprofiles$DBProfiles == null ? (class$com$sap$rprof$dbprofiles$DBProfiles = DBProfiles.class$("com.sap.rprof.dbprofiles.DBProfiles")) : class$com$sap$rprof$dbprofiles$DBProfiles).getName());
    private static final String RFC_GET_PROFILE = "LCRDB_GET_PROFILE";
    private static final String RFC_SET_PROFILE = "LCRDB_SET_PROFILE";
    private static final int GC_FOREIGN_LOCK = 104;
    private static final int GC_NO_SUCH_PROFILE = 207;
    private static final String P_APPLNAME = "APPLNAME";
    private static final String P_FILENAME = "FILENAME";
    private static final String P_RETURN = "RETURN";
    private static final String P_PROFILE = "PROFILE";
    private JCO.Client jcoClient;
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$DBProfiles;

    public DBProfiles(String aSAPClient, String aUserId, String aPassword, String aLanguage, String aHostname, String aSystemNumber) {
        this.jcoClient = JCO.createClient((String)aSAPClient, (String)aUserId, (String)aPassword, (String)aLanguage, (String)aHostname, (String)aSystemNumber);
    }

    public DBProfiles(String aSAPClient, String aUserId, String aPassword, String aLanguage, String aMSHost, String aR3Name, String aGroup) {
        this.jcoClient = JCO.createClient((String)aSAPClient, (String)aUserId, (String)aPassword, (String)aLanguage, (String)aMSHost, (String)aR3Name, (String)aGroup);
    }

    public DBProfiles(JCO.Client aJcoClient) {
        this.jcoClient = aJcoClient;
    }

    public String getProfile(String applName, String fileName) throws DBException {
        this.checkArguments(applName, fileName);
        try {
            String string;
            this.jcoClient.connect();
            try {
                JCO.Function jcoFunction = this.initFunction(RFC_GET_PROFILE, applName, fileName, null);
                this.jcoClient.execute(jcoFunction);
                this.checkReturn(jcoFunction);
                string = jcoFunction.getExportParameterList().getField(P_PROFILE).getString();
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    this.jcoClient.disconnect();
                }
                catch (JCO.Exception jcoe) {
                    myLogger.debug("JCO exception during disconnect", jcoe);
                }
                throw throwable;
            }
            try {
                this.jcoClient.disconnect();
            }
            catch (JCO.Exception jcoe) {
                myLogger.debug("JCO exception during disconnect", jcoe);
            }
            return string;
        }
        catch (JCO.Exception jcoEx) {
            throw new DBException((Exception)((Object)jcoEx));
        }
    }

    public void setProfile(String applName, String fileName, String contents) throws DBException {
        this.checkArguments(applName, fileName);
        try {
            this.jcoClient.connect();
            try {
                JCO.Function jcoFunction = this.initFunction(RFC_SET_PROFILE, applName, fileName, contents);
                this.jcoClient.execute(jcoFunction);
                this.checkReturn(jcoFunction);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    this.jcoClient.disconnect();
                }
                catch (JCO.Exception jcoe) {
                    myLogger.debug("JCO exception during disconnect", jcoe);
                }
                throw throwable;
            }
            try {
                this.jcoClient.disconnect();
            }
            catch (JCO.Exception jcoe) {
                myLogger.debug("JCO exception during disconnect", jcoe);
            }
        }
        catch (JCO.Exception jcoEx) {
            throw new DBException((Exception)((Object)jcoEx));
        }
    }

    private void checkArguments(String applName, String fileName) throws DBException {
        if (applName == null || applName.length() < 1 || applName.length() > 10) {
            throw new DBException("APPLNAME must have 1 to 10 characters.");
        }
        if (fileName == null || fileName.length() < 1 || fileName.length() > 60) {
            throw new DBException("FILENAME must have 1 to 60 characters.");
        }
    }

    private JCO.Function initFunction(String functionName, String applName, String fileName, String contents) {
        JCO.Repository repository = new JCO.Repository("AII_PROFILES", this.jcoClient);
        JCO.Function jcoFunction = repository.getFunctionTemplate(functionName).getFunction();
        JCO.ParameterList importParams = jcoFunction.getImportParameterList();
        importParams.setValue(applName, P_APPLNAME);
        importParams.setValue(fileName, P_FILENAME);
        if (contents != null) {
            importParams.setValue(contents, P_PROFILE);
        }
        return jcoFunction;
    }

    private int checkReturn(JCO.Function jcoFunction) throws DBException {
        int returnValue = jcoFunction.getExportParameterList().getField(P_RETURN).getInt();
        switch (returnValue) {
            case 0: {
                break;
            }
            case 207: {
                break;
            }
            case 104: {
                break;
            }
            default: {
                throw new DBException("RFC call returned an error code: " + returnValue);
            }
        }
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

