/*
 * Decompiled with CFR 0.152.
 */
package com.sap.rprof.dbprofiles;

import com.sap.mw.jco.JCO;
import com.sap.rprof.dbprofiles.AccessException;
import com.sap.rprof.dbprofiles.DBException;
import com.sap.rprof.dbprofiles.JDBCProfileFactory;
import com.sap.rprof.dbprofiles.ProfileDestinationStore;
import com.sap.rprof.dbprofiles.RemoteProfile;
import com.sap.rprof.dbprofiles.log.Logger;
import com.sap.rprof.dbprofiles.util.SecureStoreAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AbapConnect
implements Serializable {
    public static final boolean DBPROFILES_TRACING = false;
    private static final String DB_CON_PROP_FILENAME = "dbconnect.properties";
    public static final String UPLOAD_DIR_PARAMETER = "java:comp/env/UploadDirectory";
    public static final String SYS_DIR_PARAM_NAME = "com.sap.systemdir";
    public static final String SYS_DIR_PARAM_NAME2 = "sys.global.dir";
    public static final String POOL_ALIAS_PARAMETER = "jdbc/SAP/BC_SLD";
    private static final String ABAP_PROFILE_FILE = "dbconnect.xml";
    private static final String ABAP_SECT = "default";
    private static final String ABAP_ENV_CLIENT = "RprofAbapClient";
    private static final String ABAP_ENV_USER = "RprofAbapUser";
    private static final String ABAP_ENV_PWD = "RprofAbapPwd";
    private static final String ABAP_ENV_LANG = "RprofAbapLanguage";
    private static final String ABAP_ENV_HOST = "RprofAbapHost";
    private static final String ABAP_ENV_SYSNR = "RprofAbapSysNr";
    private static final String CFACTOR = "Hendrix";
    private static final int CRADIX = 21;
    private static final Logger myLogger = Logger.getLogger((class$com$sap$rprof$dbprofiles$AbapConnect == null ? (class$com$sap$rprof$dbprofiles$AbapConnect = AbapConnect.class$("com.sap.rprof.dbprofiles.AbapConnect")) : class$com$sap$rprof$dbprofiles$AbapConnect).getName());
    private static AbapConnect standardAbapConnect = null;
    private String jCOClient = null;
    private String jCOUser = null;
    private String jCOPassword = null;
    private String jCOLanguage = null;
    private String jCOHostname = null;
    private String jCOSystemNumber = null;
    private String jCORouter = null;
    private String jCOSysId = null;
    private String jCOLogonGroup = null;
    private boolean jCOFastConnection = true;
    private boolean jCOLoadBalanced = false;
    private boolean jCOActivated = false;
    static /* synthetic */ Class class$com$sap$rprof$dbprofiles$AbapConnect;

    public void setupDefaultJcoCommunication() throws DBException {
        ProfileDestinationStore profileDest;
        boolean fromSecStore = true;
        try {
            profileDest = SecureStoreAccess.loadConfigFromSecureStore();
            if (profileDest != null) {
                myLogger.debug("Current ABAP connect in secure store points to " + profileDest.getHost() + "_" + profileDest.getSystemNumberStr());
            } else {
                myLogger.debug("No ABAP connect found in secure store");
            }
        }
        catch (AccessException ace) {
            myLogger.debug("Access Exception, switching to FS fallback", ace);
            profileDest = null;
        }
        if (profileDest == null) {
            File propFile;
            Properties prop = new Properties();
            String systemDir = AbapConnect.getDefaultWorkDir();
            if (systemDir == null) {
                systemDir = ".";
            }
            if (!(propFile = new File(systemDir, DB_CON_PROP_FILENAME)).exists()) {
                propFile = new File(".", DB_CON_PROP_FILENAME);
            }
            try {
                prop.load(new FileInputStream(propFile));
            }
            catch (IOException e) {
                throw new DBException("dbconnect.prop: failed to load properties file " + propFile.toString());
            }
            profileDest = new ProfileDestinationStore(prop);
            myLogger.debug("Current ABAP connect in file system points to " + profileDest.getHost() + "_" + profileDest.getSystemNumberStr());
            fromSecStore = false;
        }
        String origin = fromSecStore ? " in secure store" : " in file system";
        this.jCOLoadBalanced = false;
        this.jCOClient = profileDest.getClient();
        if (this.jCOClient == null) {
            throw new DBException("dbconnect.properties: client: no such property" + origin);
        }
        this.jCOUser = profileDest.getUser();
        if (this.jCOUser == null) {
            throw new DBException("dbconnect.properties: user: no such property" + origin);
        }
        String password = profileDest.getPwd();
        if (password == null) {
            throw new DBException("dbconnect.properties: password: no such property" + origin);
        }
        this.jCOPassword = this.buildEncWrd(password);
        this.jCOLanguage = profileDest.getLanguage();
        if (this.jCOLanguage == null) {
            throw new DBException("dbconnect.properties: language: no such property" + origin);
        }
        this.jCOHostname = profileDest.getHost();
        int sysnum = profileDest.getSystemNumber();
        this.jCOSystemNumber = sysnum >= 0 ? Integer.toString(sysnum) : null;
        if (this.jCOSystemNumber != null || this.jCOHostname != null) {
            this.jCOFastConnection = false;
        }
    }

    public static String getDefaultWorkDir() {
        String globalDir;
        try {
            globalDir = System.getProperty(SYS_DIR_PARAM_NAME2);
            if (globalDir != null) {
                return new File(globalDir).toString();
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            InitialContext initialContext = new InitialContext();
            globalDir = initialContext.lookup(UPLOAD_DIR_PARAMETER).toString();
            if (globalDir != null) {
                return new File(globalDir).toString();
            }
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            globalDir = System.getProperty(SYS_DIR_PARAM_NAME);
            if (globalDir != null) {
                return new File(globalDir).toString();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public void writeDefaultJcoCommunicationToFile() throws DBException {
        Properties prop = new Properties();
        prop.setProperty("client", this.jCOClient);
        prop.setProperty("user", this.jCOUser);
        prop.setProperty("password", this.getJcoPassword());
        prop.setProperty("language", this.jCOLanguage);
        prop.setProperty("hostname", this.jCOHostname);
        prop.setProperty("systemNumber", this.jCOSystemNumber);
        try {
            FileOutputStream out = new FileOutputStream(new File(DB_CON_PROP_FILENAME));
            prop.store(out, "Destination properties to access the Exchange Profile");
            ((OutputStream)out).close();
        }
        catch (IOException ioe) {
            throw new DBException(ioe);
        }
    }

    public String getJcoClient() {
        return this.jCOClient;
    }

    public String getJcoUser() {
        return this.jCOUser;
    }

    String getJcoPassword() {
        String dpw;
        if (this.jCOPassword.length() == 0) {
            return "";
        }
        try {
            byte[] ba1 = CFACTOR.getBytes("UTF-8");
            BigInteger bi1 = new BigInteger(ba1);
            BigInteger product = new BigInteger(this.jCOPassword, 21);
            BigInteger bi2 = product.divide(bi1);
            byte[] ba2 = bi2.toByteArray();
            dpw = new String(ba2, "UTF-8");
        }
        catch (UnsupportedEncodingException usee) {
            dpw = this.jCOPassword;
            myLogger.debug("UnsupportedEncodingException thrown, try to use original string", usee);
        }
        catch (NumberFormatException nfe) {
            dpw = this.jCOPassword;
            myLogger.debug("NumberFormatException thrown, try to use original string", nfe);
        }
        catch (ArithmeticException ae) {
            dpw = this.jCOPassword;
            myLogger.debug("ArithmeticException thrown, try to use original string", ae);
        }
        return dpw;
    }

    public String getJcoLanguage() {
        return this.jCOLanguage;
    }

    public String getJcoHostname() {
        return this.jCOHostname;
    }

    public String getJcoSystemNumber() {
        return this.jCOSystemNumber;
    }

    public String getJcoRouter() {
        return this.jCORouter;
    }

    public String getJcoSysId() {
        return this.jCOSysId;
    }

    public String getJcoLogonGroup() {
        return this.jCOLogonGroup;
    }

    public boolean isJcoLoadBalanced() {
        return this.jCOLoadBalanced;
    }

    public boolean isConfiguredToUseFastConnection() {
        return this.jCOFastConnection;
    }

    public boolean isFastConnectionAvailable() {
        return this.getFastJcoClient() != null;
    }

    public boolean isActivated() {
        return this.jCOActivated;
    }

    public void setupJcoCommunicationToSister(String aClient, String aUser, String aPassword, String aLanguage) {
        this.jCOLoadBalanced = false;
        this.jCOClient = aClient;
        this.jCOUser = aUser;
        this.jCOPassword = this.buildEncWrd(aPassword);
        this.jCOLanguage = aLanguage;
        this.enableFastConnection();
    }

    public void setupJcoCommunication(String aClient, String aUser, String aPassword, String aLanguage, String aHostname, String aSystemNumber) {
        this.jCOLoadBalanced = false;
        this.jCOClient = aClient;
        this.jCOUser = aUser;
        this.jCOPassword = this.buildEncWrd(aPassword);
        this.jCOLanguage = aLanguage;
        this.jCOHostname = aHostname;
        this.jCOSystemNumber = aSystemNumber;
        this.disableFastConnection();
    }

    public void setupJcoCommunicationLoadBalanced(String aClient, String aUser, String aPassword, String aLanguage, String aRouter, String aSysId, String aLogonGroup) {
        this.jCOLoadBalanced = true;
        this.jCOClient = aClient;
        this.jCOUser = aUser;
        this.jCOPassword = this.buildEncWrd(aPassword);
        this.jCOLanguage = aLanguage;
        this.jCORouter = aRouter;
        this.jCOSysId = aSysId;
        this.jCOLogonGroup = aLogonGroup;
        this.disableFastConnection();
    }

    public void disableFastConnection() {
        this.jCOFastConnection = false;
    }

    public void enableFastConnection() {
        this.jCOFastConnection = true;
    }

    private String buildEncWrd(String value) {
        String cpw;
        if (value.length() == 0) {
            return "";
        }
        try {
            byte[] ba1 = CFACTOR.getBytes("UTF-8");
            BigInteger bi1 = new BigInteger(ba1);
            byte[] ba2 = value.getBytes("UTF-8");
            BigInteger bi2 = new BigInteger(ba2);
            BigInteger product = bi1.multiply(bi2);
            cpw = product.toString(21);
        }
        catch (UnsupportedEncodingException usee) {
            cpw = value;
            myLogger.debug("UnsupportedEncodingException thrown, use original string", usee);
        }
        return cpw;
    }

    public JCO.Client createJcoClientInstance() throws DBException {
        JCO.Client preferedClient;
        if (this.jCOFastConnection && (preferedClient = this.getFastJcoClient()) != null) {
            return preferedClient;
        }
        if (!this.jCOLoadBalanced && this.jCOHostname != null) {
            return JCO.createClient((String)this.jCOClient, (String)this.jCOUser, (String)this.getJcoPassword(), (String)this.jCOLanguage, (String)this.jCOHostname, (String)this.jCOSystemNumber);
        }
        if (this.jCOLoadBalanced && this.jCORouter != null) {
            return JCO.createClient((String)this.jCOClient, (String)this.jCOUser, (String)this.getJcoPassword(), (String)this.jCOLanguage, (String)this.jCORouter, (String)this.jCOSysId, (String)this.jCOLogonGroup);
        }
        throw new DBException("ABAP connection object not setup.");
    }

    private JCO.Client getFastJcoClient() {
        String myWebAsProfile;
        JCO.Client myFastJcoClient = null;
        try {
            myWebAsProfile = System.getProperty("SAPPROFILE");
        }
        catch (RuntimeException e) {
            myLogger.debug("Unable to get the system property SAPPROFILE", e);
            myWebAsProfile = null;
        }
        if (myWebAsProfile != null && myWebAsProfile.length() != 0) {
            if (this.getJcoClient() != null && this.getJcoUser() != null && this.getJcoPassword() != null && this.getJcoLanguage() != null) {
                Properties fastRfcProp = new Properties();
                ((Hashtable)fastRfcProp).put("jco.client.profile_name", myWebAsProfile);
                ((Hashtable)fastRfcProp).put("jco.client.client", this.getJcoClient());
                ((Hashtable)fastRfcProp).put("jco.client.user", this.getJcoUser());
                ((Hashtable)fastRfcProp).put("jco.client.passwd", this.getJcoPassword());
                ((Hashtable)fastRfcProp).put("jco.client.lang", this.getJcoLanguage());
                ((Hashtable)fastRfcProp).put("jco.client.type", "F");
                myFastJcoClient = JCO.createClient((Properties)fastRfcProp);
            } else {
                myLogger.debug("Unable to create Fast jCO client due to missing connection setup");
            }
        } else {
            myLogger.debug("Unable to create Fast jCO client due to missing system property SAPPROFILE");
        }
        return myFastJcoClient;
    }

    public static boolean isDBPoolAvailable() {
        InitialContext initialContext;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException ne) {
            myLogger.finest("No naming service in this runtime environment.", ne);
            return false;
        }
        try {
            initialContext.lookup(POOL_ALIAS_PARAMETER);
        }
        catch (NamingException ne) {
            myLogger.finest("No naming service in this runtime environment.", ne);
            return false;
        }
        return true;
    }

    public static AbapConnect evaluateStandardConnect(String application) throws DBException {
        if (standardAbapConnect != null) {
            return standardAbapConnect;
        }
        AbapConnect myAc = new AbapConnect();
        if (!AbapConnect.isDBPoolAvailable()) {
            return null;
        }
        myAc.setupProfileJcoCommunication(application);
        standardAbapConnect = myAc;
        return myAc;
    }

    private static RemoteProfile getJDBCProfile(String application, boolean returnReadOnly) throws DBException {
        RemoteProfile result = null;
        JDBCProfileFactory myProfileFactory = new JDBCProfileFactory(false);
        if (returnReadOnly) {
            result = RemoteProfile.getRemoteProfileFromFactory(application, ABAP_PROFILE_FILE, myProfileFactory);
        } else {
            try {
                result = RemoteProfile.getRemoteProfileFromFactoryForUpdate(application, ABAP_PROFILE_FILE, myProfileFactory, true);
            }
            catch (AccessException ace) {
                throw new DBException(ace);
            }
        }
        return result;
    }

    private void setupProfileJcoCommunication(String application) throws DBException {
        RemoteProfile rprofProfile = AbapConnect.getJDBCProfile(application, true);
        this.jCOLoadBalanced = false;
        this.jCOClient = rprofProfile.getParameter(null, ABAP_ENV_CLIENT);
        if (this.jCOClient == null) {
            throw new DBException("dbconnect.xml: client: no such property");
        }
        this.jCOUser = rprofProfile.getParameter(null, ABAP_ENV_USER);
        if (this.jCOUser == null) {
            throw new DBException("dbconnect.xml: user: no such property");
        }
        String password = rprofProfile.getParameter(null, ABAP_ENV_PWD);
        if (password == null) {
            throw new DBException("dbconnect.xml: password: no such property");
        }
        this.jCOPassword = this.buildEncWrd(password);
        this.jCOLanguage = rprofProfile.getParameter(null, ABAP_ENV_LANG);
        if (this.jCOLanguage == null) {
            throw new DBException("dbconnect.xml: language: no such property");
        }
        this.jCOHostname = rprofProfile.getParameter(null, ABAP_ENV_HOST);
        this.jCOSystemNumber = rprofProfile.getParameter(null, ABAP_ENV_SYSNR);
        if (this.jCOSystemNumber != null || this.jCOHostname != null) {
            this.jCOFastConnection = false;
        }
    }

    public boolean setAsStandardConnect(String application) throws DBException {
        standardAbapConnect = this;
        if (!AbapConnect.isDBPoolAvailable()) {
            return false;
        }
        this.writeProfileJcoCommunication(application);
        return true;
    }

    private void writeProfileJcoCommunication(String application) throws DBException {
        RemoteProfile rprofProfile = AbapConnect.getJDBCProfile(application, false);
        try {
            rprofProfile.setParameter(ABAP_SECT, ABAP_ENV_CLIENT, this.jCOClient);
            rprofProfile.setParameter(ABAP_SECT, ABAP_ENV_USER, this.jCOUser);
            rprofProfile.setParameter(ABAP_SECT, ABAP_ENV_PWD, this.jCOPassword);
            rprofProfile.setParameter(ABAP_SECT, ABAP_ENV_LANG, this.jCOLanguage);
            rprofProfile.setParameter(ABAP_SECT, ABAP_ENV_HOST, this.jCOHostname);
            rprofProfile.setParameter(ABAP_SECT, ABAP_ENV_SYSNR, this.jCOSystemNumber);
            rprofProfile.releaseChanges();
        }
        catch (AccessException ace) {
            throw new DBException(ace);
        }
    }

    public boolean setActive(String application) throws DBException {
        this.jCOActivated = true;
        return this.setAsStandardConnect(application);
    }

    public boolean setInactive(String application) throws DBException {
        this.jCOActivated = false;
        return this.setAsStandardConnect(application);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

