/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ping;

import com.sap.ide.ping.CheckboxTableTreeViewer;
import com.sap.ide.ping.ServerData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class PingServerDialog
extends Window {
    protected static List contentProviderList = null;
    private String[] columnHeaders = new String[]{"", "Url", "State", "Response Time"};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(20, 40, false), new ColumnWeightData(200, 200, true), new ColumnWeightData(74, 20, true), new ColumnWeightData(26, 70, true)};
    CheckboxTableTreeViewer treeViewer;

    protected PingServerDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
    }

    protected Control createContents(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 1;
        this.treeViewer = new CheckboxTableTreeViewer(parent, 2048);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        TableLayout tLayout = new TableLayout();
        this.treeViewer.getTableTree().getTable().setLayout((Layout)tLayout);
        this.treeViewer.getTableTree().getTable().setHeaderVisible(true);
        tLayout = (TableLayout)this.treeViewer.getTableTree().getTable().getLayout();
        int i = 0;
        while (i < this.columnHeaders.length) {
            tLayout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.treeViewer.getTableTree().getTable(), i == 3 ? 131072 : 16384, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
        ServerContentProvider provider = new ServerContentProvider();
        if (contentProviderList != null) {
            List list = contentProviderList;
            synchronized (list) {
                Iterator it = contentProviderList.iterator();
                while (it.hasNext()) {
                    ITreeContentProvider prv = (ITreeContentProvider)it.next();
                    provider.addProvider(prv);
                }
            }
        }
        this.treeViewer.setContentProvider((IContentProvider)provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ServerDataLabelProvider());
        this.treeViewer.setInput("root");
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean state = event.getChecked();
                Object element = event.getElement();
                if (element instanceof ServerData) {
                    ServerData data = (ServerData)element;
                    if (data.hasChildren()) {
                        PingServerDialog.this.treeViewer.setSubtreeChecked(element, state);
                        PingServerDialog.this.treeViewer.setGrayed(element, false);
                    }
                    if (!state) {
                        data.reset();
                        PingServerDialog.this.updateServerData(data, (StructuredViewer)PingServerDialog.this.treeViewer);
                        ServerData parentData = data.getParent();
                        while (parentData != null) {
                            PingServerDialog.this.treeViewer.setChecked(parentData, state);
                            PingServerDialog.this.treeViewer.setGrayed(parentData, false);
                            parentData.reset();
                            PingServerDialog.this.updateServerData(parentData, (StructuredViewer)PingServerDialog.this.treeViewer);
                            parentData = parentData.getParent();
                        }
                    }
                }
            }
        });
        Composite buttonContainer = new Composite(parent, 0);
        buttonContainer.setLayoutData((Object)new GridData(2));
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = false;
        rowLayout.justify = true;
        rowLayout.type = 512;
        rowLayout.marginLeft = 5;
        rowLayout.marginTop = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginBottom = 5;
        rowLayout.spacing = 5;
        buttonContainer.setLayout((Layout)rowLayout);
        Button pingButton = new Button(buttonContainer, 0);
        pingButton.setText("Ping");
        pingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PingServerDialog.this.pingCheckedServer();
            }
        });
        Button selectAllButton = new Button(buttonContainer, 0);
        selectAllButton.setText("Select All");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PingServerDialog.this.treeViewer.expandAll();
                PingServerDialog.this.treeViewer.setAllChecked(true);
            }
        });
        Button deselectAllButton = new Button(buttonContainer, 0);
        deselectAllButton.setText("Deselect All");
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PingServerDialog.this.treeViewer.setAllChecked(false);
                TableTreeItem[] items = PingServerDialog.this.treeViewer.getTableTree().getItems();
                if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].getData() instanceof ServerData) {
                            ServerData data = (ServerData)items[i].getData();
                            data.reset();
                            PingServerDialog.this.updateServerData(data, (StructuredViewer)PingServerDialog.this.treeViewer);
                            PingServerDialog.this.resetAllChildren(data, (StructuredViewer)PingServerDialog.this.treeViewer);
                        }
                        ++i;
                    }
                }
            }
        });
        this.getShell().setText("Ping Infrastructure Servers");
        return parent;
    }

    protected void pingCheckedServer() {
        this.treeViewer.getContentProvider().dispose();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] objects = PingServerDialog.this.treeViewer.getCheckedElements();
                if (objects != null) {
                    int i = 0;
                    while (i < objects.length) {
                        if (objects[i] instanceof ServerData) {
                            ((ServerData)objects[i]).runCheck();
                            PingServerDialog.this.updateServerData((ServerData)objects[i], (StructuredViewer)PingServerDialog.this.treeViewer);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private void updateServerData(ServerData data, StructuredViewer treeViewer) {
        while (data != null) {
            treeViewer.update((Object)data, new String[]{"Server", "State", "Response Time"});
            data = data.getParent();
        }
    }

    private void resetAllChildren(ServerData data, StructuredViewer treeViewer) {
        data.reset();
        this.updateServerData(data, treeViewer);
        ServerData[] childs = data.getChildren();
        if (childs != null) {
            int i = 0;
            while (i < childs.length) {
                childs[i].reset();
                this.updateServerData(childs[i], treeViewer);
                this.resetAllChildren(childs[i], treeViewer);
                ++i;
            }
        }
    }

    public void create() {
        super.create();
        Point size = this.getInitialSize();
        Point location = this.getInitialLocation(size);
        this.getShell().setBounds(location.x, location.y, 500, 500);
    }

    public static void addTreeContentProvider(ITreeContentProvider provider) {
        if (contentProviderList == null) {
            contentProviderList = new ArrayList();
        }
        List list = contentProviderList;
        synchronized (list) {
            contentProviderList.add(provider);
        }
    }

    protected class ServerDataLabelProvider
    implements ITableLabelProvider {
        protected ServerDataLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ServerData) {
                ServerData data = (ServerData)element;
                switch (columnIndex) {
                    case 1: {
                        return data.getImage();
                    }
                    case 2: {
                        if ("failed".equals(data.getState())) {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                        }
                        if ("ok".equals(data.getState())) {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_COMPLETE_TSK");
                        }
                        if ("unautorized".equals(data.getState())) {
                            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                        }
                        if (!"unknown".equals(data.getState())) break;
                        return null;
                    }
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ServerData) {
                ServerData data = (ServerData)element;
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return data.getName();
                    }
                    case 2: {
                        return "";
                    }
                    case 3: {
                        if (data.getResponseTime() >= 0L) {
                            return data.getResponseTime() + " ms";
                        }
                        return "";
                    }
                }
                return "";
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class ServerContentProvider
    implements ITreeContentProvider {
        List contentProviderList = new ArrayList();

        public void addProvider(ITreeContentProvider provider) {
            this.contentProviderList.add(provider);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                if ("root".equals(parentElement)) {
                    ArrayList<Object> childs = new ArrayList<Object>();
                    Iterator it = this.contentProviderList.iterator();
                    while (it.hasNext()) {
                        ITreeContentProvider provider = (ITreeContentProvider)it.next();
                        Object[] array = provider.getChildren(parentElement);
                        if (array == null) continue;
                        childs.addAll(Arrays.asList(array));
                    }
                    return childs.toArray(new Object[childs.size()]);
                }
                return null;
            }
            if (parentElement instanceof ServerData) {
                return ((ServerData)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ServerData) {
                return ((ServerData)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof String) {
                if ("root".equals(element)) {
                    boolean value = false;
                    Iterator it = this.contentProviderList.iterator();
                    while (it.hasNext()) {
                        ITreeContentProvider provider = (ITreeContentProvider)it.next();
                        value |= provider.hasChildren(element);
                    }
                    return value;
                }
            } else if (element instanceof ServerData) {
                return ((ServerData)element).hasChildren();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] objs = this.getChildren(inputElement);
            if (objs == null) {
                return new Object[0];
            }
            return objs;
        }

        public void dispose() {
            Iterator it = this.contentProviderList.iterator();
            while (it.hasNext()) {
                ITreeContentProvider provider = (ITreeContentProvider)it.next();
                provider.dispose();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Iterator it = this.contentProviderList.iterator();
            while (it.hasNext()) {
                ITreeContentProvider provider = (ITreeContentProvider)it.next();
                provider.inputChanged(viewer, oldInput, newInput);
            }
        }
    }
}

