/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.ping;

import com.sap.ide.ping.ServerData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CheckboxTableTreeViewer
extends TableTreeViewer
implements ICheckable {
    private ListenerList checkStateListeners = new ListenerList(3);
    private TableTreeItem lastClickedItem = null;

    public CheckboxTableTreeViewer(Composite parent) {
        this(parent, 2048);
    }

    public CheckboxTableTreeViewer(Composite parent, int style) {
        this(new TableTree(parent, 0x20 | style));
    }

    public CheckboxTableTreeViewer(TableTree tree) {
        super(tree);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add((Object)listener);
    }

    private void applyState(Set checked, Set grayed, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Object data;
            Item item = items[i];
            if (item instanceof TableTreeItem && (data = item.getData()) != null) {
                TableTreeItem ti = (TableTreeItem)item;
                ti.setChecked(checked.contains(data));
            }
            this.applyState(checked, grayed, (Widget)item);
            ++i;
        }
    }

    protected void fireCheckStateChanged(CheckStateChangedEvent event) {
        Object[] listeners = this.checkStateListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ICheckStateListener)listeners[i]).checkStateChanged(event);
            ++i;
        }
    }

    private void gatherState(Set checked, Set grayed, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            TableTreeItem ti;
            Object data;
            Item item = items[i];
            if (item instanceof TableTreeItem && (data = item.getData()) != null && (ti = (TableTreeItem)item).getChecked()) {
                checked.add(data);
            }
            this.gatherState(checked, grayed, (Widget)item);
            ++i;
        }
    }

    public boolean getChecked(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableTreeItem) {
            return ((TableTreeItem)widget).getChecked();
        }
        return false;
    }

    public void setAllChecked(boolean state) {
        this.setAllChecked(state, this.getTableTree().getItems());
    }

    private void setAllChecked(boolean state, TableTreeItem[] children) {
        int i = 0;
        while (i < children.length) {
            TableTreeItem item = children[i];
            item.setChecked(state);
            this.setAllChecked(state, (TableTreeItem[])this.getChildren((Widget)item));
            ++i;
        }
    }

    public void setAllExpanded(boolean state) {
        this.setAllExpanded(state, this.getTableTree().getItems());
    }

    private void setAllExpanded(boolean state, TableTreeItem[] children) {
        int i = 0;
        while (i < children.length) {
            TableTreeItem item = children[i];
            item.setExpanded(state);
            this.setAllExpanded(state, (TableTreeItem[])this.getChildren((Widget)item));
            ++i;
        }
    }

    public Object[] getCheckedElements() {
        ArrayList v = new ArrayList();
        Control tree = this.getControl();
        this.internalCollectChecked(v, (Widget)tree);
        return v.toArray();
    }

    protected void handleDoubleSelect(SelectionEvent event) {
        if (this.lastClickedItem != null) {
            TableTreeItem item = this.lastClickedItem;
            Object data = item.getData();
            if (data != null) {
                boolean state = item.getChecked();
                this.setChecked(data, !state);
                this.fireCheckStateChanged(new CheckStateChangedEvent((ICheckable)this, data, !state));
            }
            this.lastClickedItem = null;
        } else {
            super.handleDoubleSelect(event);
        }
    }

    protected void handleSelect(SelectionEvent event) {
        this.lastClickedItem = null;
        if (event.detail == 32) {
            TableTreeItem item;
            this.lastClickedItem = item = (TableTreeItem)event.item;
            super.handleSelect(event);
            Object data = item.getData();
            if (data != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent((ICheckable)this, data, item.getChecked()));
            }
        } else {
            super.handleSelect(event);
        }
    }

    private void internalCollectChecked(List result, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Object data;
            Item item = items[i];
            if (item instanceof TableTreeItem && ((TableTreeItem)item).getChecked() && (data = item.getData()) != null) {
                result.add(data);
            }
            this.internalCollectChecked(result, (Widget)item);
            ++i;
        }
    }

    private void internalSetChecked(Set checkedElements, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            boolean checked;
            TableTreeItem item = (TableTreeItem)items[i];
            Object data = item.getData();
            if (data != null && (checked = checkedElements.contains(data)) != item.getChecked()) {
                item.setChecked(checked);
            }
            this.internalSetChecked(checkedElements, (Widget)item);
            ++i;
        }
    }

    protected void preservingSelection(Runnable updateCode) {
        int n = this.getItemCount(this.getControl());
        HashSet checkedNodes = new HashSet(n);
        HashSet grayedNodes = new HashSet(n);
        this.gatherState(checkedNodes, grayedNodes, (Widget)this.getControl());
        super.preservingSelection(updateCode);
        this.applyState(checkedNodes, grayedNodes, (Widget)this.getControl());
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.remove((Object)listener);
    }

    public boolean setChecked(Object element, boolean state) {
        Widget widget = this.internalExpand(element, false);
        if (widget instanceof TableTreeItem) {
            ((TableTreeItem)widget).setChecked(state);
            return true;
        }
        return false;
    }

    private void setCheckedChildren(Item item, boolean state) {
        this.createChildren((Widget)item);
        Item[] items = this.getChildren((Widget)item);
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Item it = items[i];
                if (it.getData() != null && it instanceof TableTreeItem) {
                    TableTreeItem treeItem = (TableTreeItem)it;
                    treeItem.setChecked(state);
                    if (!state & treeItem.getData() instanceof ServerData) {
                        ((ServerData)treeItem.getData()).reset();
                        this.update(treeItem.getData(), new String[]{"Server", "State", "Response Time"});
                    }
                    this.setCheckedChildren((Item)treeItem, state);
                }
                ++i;
            }
        }
    }

    public void setCheckedElements(Object[] elements) {
        HashSet<Object> checkedElements = new HashSet<Object>(elements.length * 2 + 1);
        int i = 0;
        while (i < elements.length) {
            this.internalExpand(elements[i], false);
            checkedElements.add(elements[i]);
            ++i;
        }
        Control tree = this.getControl();
        tree.setRedraw(false);
        this.internalSetChecked(checkedElements, (Widget)tree);
        tree.setRedraw(true);
    }

    public boolean setGrayed(Object element, boolean state) {
        Widget widget = this.internalExpand(element, false);
        if (widget instanceof TableTreeItem) {
            TableTreeItem item = (TableTreeItem)widget;
            Table table = item.getParent().getTable();
            TableItem[] items = table.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() == widget) {
                    items[i].setGrayed(state);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean setSubtreeChecked(Object element, boolean state) {
        Widget widget = this.internalExpand(element, false);
        if (widget instanceof TableTreeItem) {
            TableTreeItem item = (TableTreeItem)widget;
            item.setChecked(state);
            this.setCheckedChildren((Item)item, state);
            return true;
        }
        return false;
    }
}

