/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.login.actions;

import com.sap.ide.login.LoginImage;
import com.sap.ide.login.LoginListener;
import com.sap.ide.login.LoginMessages;
import com.sap.ide.login.LoginStatusItem;
import com.sap.ide.login.UserValidator;
import com.sap.ide.ping.PingServerAction;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.WorkbenchWindow;

public class LoginActionDelegate
implements IWorkbenchWindowActionDelegate,
LoginListener {
    private static LoginStatusItem item = null;
    private static WorkbenchWindow windowX = null;
    private static IAction loginAction = null;
    private static IAction pingAction = null;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$login$actions$LoginActionDelegate == null ? (class$com$sap$ide$login$actions$LoginActionDelegate = LoginActionDelegate.class$("com.sap.ide.login.actions.LoginActionDelegate")) : class$com$sap$ide$login$actions$LoginActionDelegate));
    private static final String LOGIN_ACTION_ID = "com.sap.ide.login.actions.Login";
    public static final String LOGIN_ACTION_SET_ID = "com.sap.ide.login.LoginActionSet";
    static /* synthetic */ Class class$com$sap$ide$login$actions$LoginActionDelegate;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        if (item == null && window != null && window instanceof WorkbenchWindow) {
            windowX = (WorkbenchWindow)window;
            IActionBars bars = windowX.getActionBars();
            IStatusLineManager manager = bars.getStatusLineManager();
            item = new LoginStatusItem("default.server");
            if (UserValidator.isDefaultServerOnline()) {
                item.setImage(LoginImage.getImage("Online"));
            } else {
                item.setImage(LoginImage.getImage("Offline"));
            }
            manager.add((IContributionItem)item);
            item.setVisible(true);
            manager.markDirty();
            windowX.updateActionSets();
        }
        UserValidator.addLoginListener(this);
    }

    public void run(IAction action) {
        if (!UserValidator.isDefaultServerOnline()) {
            UserValidator.Data data = UserValidator.getDefaultServerData(UserValidator.USER_LOGIN, null);
            UserValidator.setDefaultServerOnline(data != null);
        } else {
            UserValidator.setDefaultServerOnline(false);
        }
        action.setChecked(UserValidator.isDefaultServerOnline());
    }

    public static void update() {
        IAction pingAction;
        IAction action;
        theTracer.debug(LoginMessages.getString("UpdateLoginControl.Start"));
        boolean online = UserValidator.isDefaultServerOnline();
        if (item != null) {
            if (online) {
                LoginActionDelegate.setItemOnline();
            } else {
                item.setImage(LoginImage.getImage("Offline"));
                item.setText(LoginMessages.getString("Offline.message"));
            }
        }
        if ((action = LoginActionDelegate.getLoginAction()) != null) {
            action.setChecked(online);
        }
        if ((pingAction = LoginActionDelegate.getPingAction()) != null) {
            pingAction.setEnabled(online);
        }
        theTracer.debug(LoginMessages.getString("UpdateLoginControl.End"));
    }

    private static void setItemOnline() {
        item.setImage(LoginImage.getImage("Online"));
        item.setText(LoginMessages.getString("Online.message"));
    }

    protected static IAction getLoginAction() {
        CoolBarContributionItem cItem;
        IContributionItem[] items;
        IContributionItem sss;
        if (loginAction != null) {
            return loginAction;
        }
        if (windowX != null && (sss = windowX.getActionBars().getToolBarManager().find(LOGIN_ACTION_SET_ID)) instanceof CoolBarContributionItem && (items = (cItem = (CoolBarContributionItem)sss).getItems()) != null) {
            int i = 0;
            while (i < items.length) {
                if (LOGIN_ACTION_ID.equals(items[i].getId())) {
                    loginAction = ((ActionContributionItem)items[i]).getAction();
                    return loginAction;
                }
                ++i;
            }
        }
        return null;
    }

    public static IAction getPingAction() {
        if (pingAction != null) {
            return pingAction;
        }
        if (windowX != null) {
            pingAction = PingServerAction.getAction(windowX);
            return pingAction;
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void loginPerformed(UserValidator.Data loginData) {
        LoginActionDelegate.update();
    }

    public static void setEnabled(boolean value) {
        IAction action = LoginActionDelegate.getLoginAction();
        if (action != null) {
            action.setEnabled(value);
        }
    }

    public static void setPingDisabled() {
        IAction action = LoginActionDelegate.getPingAction();
        if (action != null) {
            action.setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

