/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.login;

import com.sap.ide.login.IValidityChecker;
import com.sap.ide.login.IValidityCheckerWithProgress;
import com.sap.ide.login.LoginListener;
import com.sap.ide.login.LoginListenerWithProgress;
import com.sap.ide.login.LoginMessages;
import com.sap.ide.login.LoginPlugin;
import com.sap.ide.login.UserValidationDialog;
import com.sap.ide.login.actions.LoginActionDelegate;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.MessageDialog;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UserValidator {
    private static boolean defaultServerLoginEnabled = true;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$login$UserValidator == null ? (class$com$sap$ide$login$UserValidator = UserValidator.class$("com.sap.ide.login.UserValidator")) : class$com$sap$ide$login$UserValidator));
    private static KeyStore defaultKeyStore = null;
    public static int FORCE_LOGIN = 0;
    public static int LAZY_LOGIN = 1;
    public static int LAZY_FORCE_LOGIN = 2;
    public static int USER_LOGIN = 3;
    private static Data defaultServerData = null;
    private static HashMap serverData = null;
    private static List defaultListeners = null;
    private static HashMap serverListeners = null;
    private static List defaultChecker = null;
    private static HashMap serverChecker = null;
    private static final String USER_PREFERENCE = "loginuser.dafault";
    static /* synthetic */ Class class$com$sap$ide$login$UserValidator;

    public static Data getServerData(String server) {
        return UserValidator.getServerData(server, FORCE_LOGIN, null, null);
    }

    public static Data getServerData(String server, int kind, Shell shell, IProgressMonitor monitor) {
        Data data = (Data)UserValidator.getServerData().get(server);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (kind == FORCE_LOGIN) {
            return data;
        }
        if (kind == USER_LOGIN || data == null || data.getUser() == null) {
            data = UserValidator.getData(shell, server, UserValidator.getDefaultUserName(data), LoginMessages.format("LoginServerInfo.message", new Object[]{server}), kind, false, false);
        }
        return data;
    }

    public static Data getDefaultServerData() {
        return UserValidator.getDefaultServerData(FORCE_LOGIN, null);
    }

    public static void resetDefaultServerData() {
        UserValidator.setDefaultServerOnline(false);
        defaultServerData = null;
    }

    public static Data getDefaultServerData(int kind, Shell shell) {
        return UserValidator.getDefaultServerData(kind, shell, null);
    }

    public static Data getDefaultServerData(int kind, Shell shell, String message) {
        Data data = defaultServerData;
        if (kind == FORCE_LOGIN) {
            return data;
        }
        if (kind == USER_LOGIN || defaultServerData == null || !defaultServerData.isOnline()) {
            boolean changableUser = defaultServerData == null || !defaultServerData.isUserValid();
            data = UserValidator.getData(shell, null, UserValidator.getDefaultUserName(), message != null ? message : LoginMessages.getString("LogingGeneralInfo.message"), kind, true, changableUser);
        }
        return data;
    }

    protected static int fireChangeEvent(List listeners, final Data data, final IProgressMonitor monitor) {
        int steps = 0;
        int i = 0;
        if (listeners == null) {
            return steps;
        }
        boolean anyErrors = false;
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            int value;
            if (monitor != null && (value = i * 10 / listeners.size()) > steps) {
                monitor.worked(value - steps);
                steps = value;
            }
            final Object listenerObject = it.next();
            theTracer.debug("Start Login Performed for: " + listenerObject.getClass());
            try {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        long start = System.currentTimeMillis();
                        try {
                            if (listenerObject instanceof LoginListener) {
                                ((LoginListener)listenerObject).loginPerformed(data);
                            }
                            if (listenerObject instanceof LoginListenerWithProgress) {
                                ((LoginListenerWithProgress)listenerObject).loginPerformed(data, monitor);
                            }
                            Object var4_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_3 = null;
                            long elapsed = System.currentTimeMillis() - start;
                            theTracer.debug("[" + elapsed + " ms]: LoginListener.logPerformed called on " + listenerObject);
                            throw throwable;
                        }
                        long elapsed = System.currentTimeMillis() - start;
                        theTracer.debug("[" + elapsed + " ms]: LoginListener.logPerformed called on " + listenerObject);
                    }
                });
                theTracer.debug("End Login Performed for: " + listenerObject.getClass());
            }
            catch (Throwable e) {
                theTracer.error("login performed failed for " + listenerObject, e);
                anyErrors = true;
            }
            ++i;
        }
        if (anyErrors) {
            org.eclipse.jface.dialogs.MessageDialog.openError((Shell)new Shell(), (String)"Error", (String)"Login process completed with errors.\nFor more information see error log.");
        }
        return steps;
    }

    public static void setDefaultServerOnline(boolean online) {
        if (UserValidator.isDefaultServerOnline() == online) {
            return;
        }
        if (defaultServerData != null) {
            defaultServerData.setOnline(online);
        }
        UserValidator.fireChangeEvent(defaultListeners, defaultServerData, null);
        if (online) {
            UserValidator.saveDeafultUser(defaultServerData);
        } else {
            UserValidator.enableLoginButton();
        }
    }

    private static void saveDeafultUser(Data data) {
        Preferences store = LoginPlugin.getPlugin().getPluginPreferences();
        if (store != null) {
            store.setValue(USER_PREFERENCE, data.getUser());
        }
    }

    private static String getDefaultUser() {
        Preferences store = LoginPlugin.getPlugin().getPluginPreferences();
        if (store != null) {
            return store.getString(USER_PREFERENCE);
        }
        return null;
    }

    public static boolean isDefaultServerOnline() {
        if (defaultServerData != null) {
            return defaultServerData.isOnline();
        }
        return false;
    }

    public static void setServerOnline(String server, boolean online, IProgressMonitor monitor) {
        Data data = (Data)UserValidator.getServerData().get(server);
        if (data == null || data.isOnline() == online) {
            return;
        }
        data.setOnline(online);
        List listeners = (List)UserValidator.getServerListeners().get(server);
        UserValidator.fireChangeEvent(listeners, data, monitor);
    }

    public static boolean isServerOnline(String server) {
        Data data = (Data)UserValidator.getServerData().get(server);
        if (data == null) {
            return false;
        }
        return data.isOnline();
    }

    public static void addLoginListener(LoginListener listener) {
        UserValidator.addLoginListener(true, null, listener);
    }

    public static void addLoginListener(LoginListenerWithProgress listener) {
        UserValidator.addLoginListener(true, null, listener);
    }

    public static void addLoginListener(boolean highPriority, LoginListener listener) {
        UserValidator.addLoginListener(highPriority, null, (Object)listener);
    }

    public static void addLoginListener(boolean highPriority, LoginListenerWithProgress listener) {
        UserValidator.addLoginListener(highPriority, null, listener);
    }

    public static void addValidityChecker(IValidityChecker checker) {
        UserValidator.addValidityChecker(null, (Object)checker);
    }

    public static void addValidityChecker(IValidityCheckerWithProgress checker) {
        UserValidator.addValidityChecker(null, (Object)checker);
    }

    public static void enableLoginButton() {
        boolean enabled = false;
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (defaultChecker != null) {
            Iterator it = defaultChecker.iterator();
            while (it.hasNext()) {
                Object checker = it.next();
                if (checker instanceof IValidityChecker) {
                    enabled |= ((IValidityChecker)checker).canValidate();
                    continue;
                }
                if (!(checker instanceof IValidityCheckerWithProgress)) continue;
                try {
                    enabled |= ((IValidityCheckerWithProgress)checker).canValidate((IProgressMonitor)monitor);
                }
                catch (InterruptedException e) {
                    theTracer.warning(LoginMessages.getString("action.interrupt"), (Throwable)e);
                }
            }
        }
        defaultServerLoginEnabled = enabled;
        LoginActionDelegate.setEnabled(enabled);
        if (!enabled) {
            UserValidator.setDefaultServerOnline(false);
        }
    }

    public static boolean isDefaultServerLoginEnabled() {
        return defaultServerLoginEnabled;
    }

    public static void addLoginListener(boolean highPriority, String server, LoginListener listener) {
        UserValidator.addLoginListener(highPriority, server, (Object)listener);
    }

    private static void addLoginListener(boolean highPriority, String server, Object listener) {
        List<Object> list;
        if (server == null || server.length() <= 0) {
            if (defaultListeners == null) {
                defaultListeners = new ArrayList();
            }
            list = defaultListeners;
        } else {
            list = (List)UserValidator.getServerListeners().get(server);
            if (list == null) {
                list = new ArrayList<Object>();
                UserValidator.getServerListeners().put(server, list);
            }
        }
        list.add(highPriority ? 0 : list.size(), listener);
    }

    public static void addValidityChecker(String server, IValidityChecker checker) {
        UserValidator.addValidityChecker(server, (Object)checker);
    }

    public static void addValidityChecker(String server, IValidityCheckerWithProgress checker) {
        UserValidator.addValidityChecker(server, (Object)checker);
    }

    private static void addValidityChecker(String server, Object checker) {
        List<Object> list;
        if (server == null || server.length() <= 0) {
            if (defaultChecker == null) {
                defaultChecker = new ArrayList();
            }
            list = defaultChecker;
        } else {
            list = (List)UserValidator.getServerChecker().get(server);
            if (list == null) {
                list = new ArrayList<Object>();
                UserValidator.getServerChecker().put(server, list);
            }
        }
        list.add(checker);
        if (server == null) {
            UserValidator.enableLoginButton();
        }
        if (!UserValidator.isDefaultServerOnline()) {
            LoginActionDelegate.setPingDisabled();
        }
    }

    public static void removeValidityChecker(IValidityChecker checker) {
        UserValidator.removeValidityChecker(null, (Object)checker);
    }

    public static void removeValidityChecker(String server, IValidityChecker checker) {
        UserValidator.removeValidityChecker(server, (Object)checker);
    }

    public static void removeValidityChecker(IValidityCheckerWithProgress checker) {
        UserValidator.removeValidityChecker(null, (Object)checker);
    }

    public static void removeValidityChecker(String server, IValidityCheckerWithProgress checker) {
        UserValidator.removeValidityChecker(server, (Object)checker);
    }

    private static void removeValidityChecker(String server, Object checker) {
        List list = server == null || server.length() <= 0 ? defaultChecker : (List)UserValidator.getServerChecker().get(server);
        if (list != null) {
            list.remove(checker);
        }
    }

    public static void removeLoginListener(LoginListener listener) {
        UserValidator.removeLoginListener(null, (Object)listener);
    }

    public static void removeLoginListener(LoginListenerWithProgress listener) {
        UserValidator.removeLoginListener(null, listener);
    }

    public static void removeLoginListener(String server, LoginListener listener) {
        UserValidator.removeLoginListener(server, (Object)listener);
    }

    public static void removeLoginListener(String server, Object listener) {
        List list = server == null || server.length() <= 0 ? defaultListeners : (List)UserValidator.getServerListeners().get(server);
        if (list != null) {
            list.remove(listener);
        }
    }

    private static void stopProgressMonitor(ProgressMonitorDialog progressMonitor) {
        if (progressMonitor != null && progressMonitor.getShell() != null && !progressMonitor.getShell().isDisposed()) {
            progressMonitor.close();
        }
        if (progressMonitor != null) {
            progressMonitor = null;
        }
    }

    private static String getDefaultUserName(Data data) {
        if (data != null && data.getUser() != null) {
            return data.getUser();
        }
        if (defaultServerData != null && defaultServerData.getUser() != null) {
            return defaultServerData.getUser();
        }
        String name = UserValidator.getDefaultUser();
        if (name != null && !"".equals(name)) {
            return name;
        }
        return System.getProperty("user.name", "");
    }

    private static String getDefaultUserName() {
        return UserValidator.getDefaultUserName(null);
    }

    private static Data getData(Shell shell, final String server, String defaultUser, String message, int kind, boolean startProgressMonitor, boolean changableUser) {
        if (shell == null && (shell = Display.getCurrent().getActiveShell()) == null) {
            shell = new Shell();
        }
        UserValidationDialog dialog = new UserValidationDialog(shell, defaultUser, message);
        dialog.setUsernameMutable(changableUser);
        final IStatus[] status = new IStatus[1];
        final Data[] data = new Data[1];
        ProgressMonitorDialog progressDialog = null;
        do {
            UserValidator.stopProgressMonitor(null);
            if (status[0] != null) {
                dialog.setErrorMessage("Login failed");
                dialog.setErrorDetails(status[0].getMessage());
            }
            if (dialog.open() == 1) {
                return null;
            }
            data[0] = new Data(dialog.getUsername(), dialog.getPassword());
            if (startProgressMonitor) {
                progressDialog = new ProgressMonitorDialog(shell);
                progressDialog.create();
                try {
                    progressDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            status[0] = UserValidator.ckeckValidity(data[0], server, monitor);
                            UserValidator.propagateData(server, data[0], status[0], monitor);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    theTracer.error(LoginMessages.getString("Login.failed"), (Throwable)e);
                }
                catch (InterruptedException e) {
                    theTracer.debug(LoginMessages.getString("UserValidation.Cancel"));
                    status[0] = new Status(4, "com.sap.ide.eclipse.login", 0, "Canceled by User", (Throwable)e);
                }
                continue;
            }
            status[0] = UserValidator.ckeckValidity(data[0], server, null);
            UserValidator.propagateData(server, data[0], status[0], null);
        } while (status[0] != null && 4 == status[0].getSeverity() && kind != LAZY_FORCE_LOGIN);
        if (status[0] == null) {
            return null;
        }
        if (status[0].getSeverity() == 1) {
            MessageDialog.showInfo((String)"Info", (String)"Login Info", (String)status[0].getMessage());
        }
        if (status[0].getSeverity() == 2 || status[0].getSeverity() == 4) {
            MessageDialog.showInfo((String)"Warning", (String)"Login Problems", (String)status[0].getMessage());
        }
        if (status[0].getSeverity() == 4) {
            data[0].setOnline(false);
        }
        data[0].setUserValid(status[0].getSeverity() != 4 && status[0].getCode() != -1);
        UserValidator.stopProgressMonitor(progressDialog);
        return data[0];
    }

    private static void propagateData(String server, Data data, IStatus status, IProgressMonitor monitor) {
        if (data == null || status == null || 4 == status.getSeverity()) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (server != null) {
            serverData.put(server, data);
            List listeners = (List)UserValidator.getServerListeners().get(server);
            UserValidator.fireChangeEvent(listeners, data, monitor);
        } else {
            defaultServerData = data;
            if (monitor != null) {
                monitor.setTaskName(LoginMessages.getString("LoginStatus.init.label"));
            }
            UserValidator.fireChangeEvent(defaultListeners, data, monitor);
            if (data.isOnline()) {
                LoginActionDelegate.setEnabled(true);
            }
            UserValidator.saveDeafultUser(data);
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static IStatus ckeckValidity(Data data, String server, IProgressMonitor monitor) {
        int steps;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String message = "";
        int code = -1;
        int severity = 0;
        List checker = server == null || server.length() <= 0 ? defaultChecker : (List)UserValidator.getServerChecker().get(server);
        Data myData = data;
        IStatus[] retStatus = new IStatus[1];
        int[] vars = new int[]{code, severity};
        String[] messageVar = new String[]{message};
        monitor.beginTask(LoginMessages.getString("LoginStatus.check.label"), 20);
        try {
            steps = UserValidator.runValidator(checker, myData, retStatus, vars, messageVar, monitor);
        }
        catch (InterruptedException e) {
            return new Status(4, "com.sap.ide.eclipse.login", 0, "Canceled by User", null);
        }
        code = vars[0];
        severity = vars[1];
        message = messageVar[0];
        monitor.worked(10 - steps);
        if (retStatus[0] != null) {
            return retStatus[0];
        }
        return new Status(severity, "com.sap.ide.eclipse.login", code, message, null);
    }

    private static int runValidator(List checker, Data myData, IStatus[] retStatus, int[] vars, String[] messageVar, IProgressMonitor monitor) throws InterruptedException {
        int myCode = vars[0];
        int mySeverity = vars[1];
        String myMessage = messageVar[0];
        int i = 0;
        int steps = 1;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.worked(1);
        if (checker != null) {
            Iterator it = checker.iterator();
            while (it.hasNext()) {
                int value = i * 10 / checker.size();
                if (value > steps) {
                    monitor.worked(value - steps);
                    steps = value;
                }
                IStatus status = null;
                Object element = it.next();
                if (element instanceof IValidityChecker) {
                    status = ((IValidityChecker)element).validate(myData);
                } else if (element instanceof IValidityCheckerWithProgress) {
                    status = ((IValidityCheckerWithProgress)element).validate(myData, monitor);
                }
                if (status.getCode() == 0) {
                    myCode = 0;
                }
                switch (status.getSeverity()) {
                    case 4: {
                        retStatus[0] = status;
                        return steps;
                    }
                    case 2: {
                        mySeverity = 2;
                    }
                    case 1: {
                        if (mySeverity != 2) {
                            mySeverity = 1;
                        }
                        myMessage = myMessage + status.getMessage() + "\n";
                    }
                }
                ++i;
            }
        }
        vars[0] = myCode;
        vars[1] = mySeverity;
        messageVar[0] = myMessage;
        return steps;
    }

    private static HashMap getServerData() {
        if (serverData == null) {
            serverData = new HashMap();
        }
        return serverData;
    }

    private static HashMap getServerListeners() {
        if (serverListeners == null) {
            serverListeners = new HashMap();
        }
        return serverListeners;
    }

    private static HashMap getServerChecker() {
        if (serverChecker == null) {
            serverChecker = new HashMap();
        }
        return serverChecker;
    }

    public static KeyStore getKeyStore() {
        return defaultKeyStore;
    }

    public static void setKeyStore(KeyStore keyStore) {
        defaultKeyStore = keyStore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Data {
        String user = null;
        String password = null;
        boolean online = false;
        boolean userValid = false;

        public Data(String user, String password) {
            this.user = user;
            this.password = password;
            this.online = true;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUser() {
            return this.user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public boolean isOnline() {
            return this.online;
        }

        public void setOnline(boolean online) {
            this.online = online;
        }

        public boolean isUserValid() {
            return this.userValid;
        }

        public void setUserValid(boolean userValid) {
            this.userValid = userValid;
        }
    }

    public static interface StatusCode {
        public static final int DATA_NOT_VALIDATED = -1;
    }
}

