/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.login;

import com.sap.ide.login.LoginMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserValidationDialog
extends Dialog {
    protected Text usernameField;
    protected Text passwordField;
    protected Text messageField;
    protected Composite myComposite;
    protected String defaultUsername;
    protected String password = null;
    protected boolean isUsernameMutable = true;
    protected String username = null;
    protected String message = null;
    protected String errorMessage = null;
    protected String errorDetails = null;
    private Button detailsButton;

    public UserValidationDialog(Shell parentShell, String defaultName, String message) {
        super(parentShell);
        this.defaultUsername = defaultName;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(LoginMessages.getString("Login.title"));
    }

    public void create() {
        super.create();
        Point size = this.getInitialSize();
        Point location = this.getInitialLocation(size);
        this.getShell().setBounds(location.x, location.y, size.x, size.y);
        if (this.defaultUsername != null) {
            this.usernameField.setText(this.defaultUsername);
        }
        this.updateUserMutable();
    }

    protected void updateUserMutable() {
        if (this.usernameField == null) {
            return;
        }
        if (this.isUsernameMutable) {
            this.usernameField.selectAll();
        } else {
            this.usernameField.setEditable(false);
        }
        this.passwordField.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        GridData data;
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.errorMessage);
            data = new GridData(768);
            data.horizontalSpan = 3;
            messageLabel.setLayoutData((Object)data);
        }
        if (this.message != null && this.message.length() > 0) {
            Label label = new Label(main, 64);
            label.setText(this.message);
            data = new GridData(768);
            data.horizontalSpan = 3;
            label.setLayoutData((Object)data);
        }
        this.createUsernameFields(main);
        this.createPasswordFields(main);
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText(LoginMessages.getString("PassordInputField.label"));
        this.passwordField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
        this.passwordField.setEchoChar('*');
        new Label(parent, 0);
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(LoginMessages.getString("UserInputField.label"));
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
        new Label(parent, 0);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    protected void okPressed() {
        this.password = this.passwordField.getText();
        this.username = this.usernameField.getText();
        super.okPressed();
    }

    public void setUsernameMutable(boolean value) {
        this.isUsernameMutable = value;
        this.updateUserMutable();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected Control createContents(Composite comp) {
        Control cont = super.createContents(comp);
        this.myComposite = comp;
        return cont;
    }

    protected Control createButtonBar(Composite comp) {
        Control control = super.createButtonBar(comp);
        this.detailsButton = this.createButton((Composite)control, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        if (this.errorDetails == null || this.errorDetails.length() <= 0) {
            this.detailsButton.setEnabled(false);
        }
        this.detailsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (UserValidationDialog.this.messageField != null) {
                    UserValidationDialog.this.messageField.dispose();
                    UserValidationDialog.this.messageField = null;
                    UserValidationDialog.this.myComposite.getShell().pack();
                    UserValidationDialog.this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
                } else if (UserValidationDialog.this.errorDetails != null) {
                    UserValidationDialog.this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
                    UserValidationDialog.this.messageField = new Text(UserValidationDialog.this.myComposite, 2818);
                    GridData gd = new GridData(768);
                    gd.horizontalSpan = 3;
                    UserValidationDialog.this.messageField.setLayoutData((Object)gd);
                    UserValidationDialog.this.messageField.setText("\n\n\n\n\n\n\n\n\n\n");
                    UserValidationDialog.this.myComposite.getShell().pack();
                    UserValidationDialog.this.messageField.setText(UserValidationDialog.this.errorDetails);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return control;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        if (this.detailsButton != null && !this.detailsButton.isDisposed()) {
            this.detailsButton.setEnabled(false);
        }
    }
}

