/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.login;

import com.sap.ide.login.IValidityChecker;
import com.sap.ide.login.UserValidator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class OnLineChecker
implements IValidityChecker {
    private String server = null;
    private int port = 80;

    public OnLineChecker(String server, int port) {
        this.server = server;
        if (port >= 0) {
            this.port = port;
        }
    }

    public IStatus validate(UserValidator.Data data) {
        if (this.server != null && this.port >= 0) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName(this.server);
            }
            catch (UnknownHostException e) {
                return new Status(4, "com.sap.ise.eclipse.login", 0, "Unknown host " + e.getMessage(), (Throwable)e);
            }
            try {
                Socket socket = new Socket(address, this.port);
                socket.close();
            }
            catch (IOException e) {
                return new Status(4, "com.sap.ise.eclipse.login", 0, e.getMessage(), (Throwable)e);
            }
        }
        return new Status(0, "com.sap.ise.eclipse.login", 0, "", null);
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean canValidate() {
        return true;
    }
}

