/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.login;

import com.sap.ide.login.LoginImage;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IStatusField;

public class LoginStatusItem
extends ContributionItem
implements IStatusField {
    private String fText;
    private Image fImage;
    private StatusLineLabel fLabel;

    public LoginStatusItem(String id) {
        super(id);
    }

    public void setText(String text) {
        this.fText = text;
        if (this.fLabel != null && !this.fLabel.isDisposed()) {
            this.fLabel.setToolTipText(this.fText);
        }
    }

    public void setImage(Image image) {
        this.fImage = image;
        if (this.fLabel != null && !this.fLabel.isDisposed()) {
            this.fLabel.setImage(this.fImage);
        }
    }

    public void fill(Composite parent) {
        this.fLabel = new StatusLineLabel(parent, 4);
        this.fLabel.setData((Object)this);
        if (this.fText != null) {
            this.fLabel.setText(this.fText);
        }
        if (this.fImage != null) {
            this.fLabel.setImage(this.fImage);
        }
    }

    static class StatusLineLabel
    extends CLabel {
        private static int INDENT = 4;
        private Point fFixedSize;

        public StatusLineLabel(Composite parent, int style) {
            super(parent, style);
            Image image = LoginImage.getImage("Offline");
            this.fFixedSize = new Point(image.getBounds().width + INDENT * 2, 10);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return this.fFixedSize;
        }
    }
}

