/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.editors.text.ColorEditor;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TabFolderLayout;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class TextEditorPreferencePage2
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String[][] fAppearanceColorListModel = new String[][]{{TextEditorMessages.getString("TextEditorPreferencePage.lineNumberForegroundColor"), "lineNumberColor"}, {TextEditorMessages.getString("TextEditorPreferencePage.currentLineHighlighColor"), "currentLineColor"}, {TextEditorMessages.getString("TextEditorPreferencePage.printMarginColor"), "printMarginColor"}};
    private final String[][] fAnnotationColorListModel;
    private OverlayPreferenceStore fOverlayStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            TextEditorPreferencePage2.this.fOverlayStore.setValue((String)TextEditorPreferencePage2.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            TextEditorPreferencePage2.this.fOverlayStore.setValue((String)TextEditorPreferencePage2.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TextEditorPreferencePage2.this.numberFieldChanged((Text)e.widget);
        }
    };
    private List fAppearanceColorList;
    private List fAnnotationList;
    private ColorEditor fAppearanceColorEditor;
    private ColorEditor fAnnotationForegroundColorEditor;
    private Button fShowInTextCheckBox;
    private Button fShowInOverviewRulerCheckBox;

    public TextEditorPreferencePage2() {
        this.setDescription(TextEditorMessages.getString("TextEditorPreferencePage.description"));
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
        this.fOverlayStore = this.createOverlayStore(preferences);
        this.fAnnotationColorListModel = this.createAnnotationTypeListModel(preferences);
    }

    private OverlayPreferenceStore createOverlayStore(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getTextPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getOverviewRulerPreferenceKey()));
        }
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "othersIndicationColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "othersIndication"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "othersIndicationInOverviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    private String[][] createAnnotationTypeListModel(MarkerAnnotationPreferences preferences) {
        ArrayList<String[]> listModelItems = new ArrayList<String[]>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            listModelItems.add(new String[]{info.getPreferenceLabel(), info.getColorPreferenceKey(), info.getTextPreferenceKey(), info.getOverviewRulerPreferenceKey()});
        }
        String[][] items = new String[listModelItems.size()][];
        listModelItems.toArray((T[])items);
        return items;
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ui.text_editor_preference_page_context");
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
    }

    private void handleAnnotationListSelection() {
        int i = this.fAnnotationList.getSelectionIndex();
        String key = this.fAnnotationColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        key = this.fAnnotationColorListModel[i][2];
        this.fShowInTextCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
        key = this.fAnnotationColorListModel[i][3];
        this.fShowInOverviewRulerCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
    }

    private static void setEnabled(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                TextEditorPreferencePage2.setEnabled(children[i], enable);
                ++i;
            }
        }
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String label = TextEditorMessages.getString("TextEditorPreferencePage.printMarginColumn");
        this.addTextField(appearanceComposite, label, "printMarginColumn", 3, 0, true);
        label = TextEditorMessages.getString("TextEditorPreferencePage.showOverviewRuler");
        this.addCheckBox(appearanceComposite, label, "overviewRuler", 0);
        label = TextEditorMessages.getString("TextEditorPreferencePage.showLineNumbers");
        this.addCheckBox(appearanceComposite, label, "lineNumberRuler", 0);
        label = TextEditorMessages.getString("TextEditorPreferencePage.highlightCurrentLine");
        this.addCheckBox(appearanceComposite, label, "currentLine", 0);
        label = TextEditorMessages.getString("TextEditorPreferencePage.showPrintMargin");
        this.addCheckBox(appearanceComposite, label, "printMargin", 0);
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(TextEditorMessages.getString("TextEditorPreferencePage.appearanceOptions"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(TextEditorMessages.getString("TextEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextEditorPreferencePage2.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = TextEditorPreferencePage2.this.fAppearanceColorList.getSelectionIndex();
                String key = TextEditorPreferencePage2.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)TextEditorPreferencePage2.this.fOverlayStore, (String)key, (RGB)TextEditorPreferencePage2.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    private Control createAnnotationsPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText(TextEditorMessages.getString("TextEditorPreferencePage.annotationPresentationOptions"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAnnotationList.setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1808));
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setText(TextEditorMessages.getString("TextEditorPreferencePage.annotations.showInText"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fShowInOverviewRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInOverviewRulerCheckBox.setText(TextEditorMessages.getString("TextEditorPreferencePage.annotations.showInOverviewRuler"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInOverviewRulerCheckBox.setLayoutData((Object)gd);
        label = new Label(optionsComposite, 16384);
        label.setText(TextEditorMessages.getString("TextEditorPreferencePage.annotations.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorEditor(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAnnotationList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TextEditorPreferencePage2.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = TextEditorPreferencePage2.this.fAnnotationList.getSelectionIndex();
                String key = TextEditorPreferencePage2.this.fAnnotationColorListModel[i][2];
                TextEditorPreferencePage2.this.fOverlayStore.setValue(key, TextEditorPreferencePage2.this.fShowInTextCheckBox.getSelection());
            }
        });
        this.fShowInOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = TextEditorPreferencePage2.this.fAnnotationList.getSelectionIndex();
                String key = TextEditorPreferencePage2.this.fAnnotationColorListModel[i][3];
                TextEditorPreferencePage2.this.fOverlayStore.setValue(key, TextEditorPreferencePage2.this.fShowInOverviewRulerCheckBox.getSelection());
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = TextEditorPreferencePage2.this.fAnnotationList.getSelectionIndex();
                String key = TextEditorPreferencePage2.this.fAnnotationColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)TextEditorPreferencePage2.this.fOverlayStore, (String)key, (RGB)TextEditorPreferencePage2.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        return composite;
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(TextEditorMessages.getString("TextEditorPreferencePage.general"));
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(TextEditorMessages.getString("TextEditorPreferencePage.annotationsTab.title"));
        item.setControl(this.createAnnotationsPage((Composite)folder));
        this.initialize();
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (TextEditorPreferencePage2.this.fAppearanceColorList != null && !TextEditorPreferencePage2.this.fAppearanceColorList.isDisposed()) {
                    TextEditorPreferencePage2.this.fAppearanceColorList.select(0);
                    TextEditorPreferencePage2.this.handleAppearanceColorListSelection();
                }
            }
        });
        i = 0;
        while (i < this.fAnnotationColorListModel.length) {
            this.fAnnotationList.add(this.fAnnotationColorListModel[i][0]);
            ++i;
        }
        this.fAnnotationList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (TextEditorPreferencePage2.this.fAnnotationList != null && !TextEditorPreferencePage2.this.fAnnotationList.isDisposed()) {
                    TextEditorPreferencePage2.this.fAnnotationList.select(0);
                    TextEditorPreferencePage2.this.handleAnnotationListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        String key;
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        EditorsPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorListSelection();
        this.handleAnnotationListSelection();
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Control addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(TextEditorMessages.getString("TextEditorPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(TextEditorMessages.getFormattedString("TextEditorPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(TextEditorMessages.getFormattedString("TextEditorPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = s.getSeverity() > status.getSeverity() ? s : status;
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    public void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }
}

