/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.SystemSummaryDocumentProvider;
import org.eclipse.ui.internal.SystemSummaryMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SystemSummaryEditor
extends AbstractTextEditor {
    static final String ID = String.valueOf(WorkbenchPlugin.getDefault().getDescriptor().getUniqueIdentifier()) + ".SystemSummaryEditor";
    public static final String LAST_FILE = "last_file";
    private static final String PREFIX = "org.eclipse.ui.";
    private static final String SYSTEM_SUMMARY_TEXT_EDITOR = "org.eclipse.ui.system_summary_editor_context";

    public SystemSummaryEditor() {
        this.setHelpContextId(SYSTEM_SUMMARY_TEXT_EDITOR);
        this.setDocumentProvider((IDocumentProvider)new SystemSummaryDocumentProvider());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        String filename = this.getFilename();
        if (filename == null) {
            return;
        }
        String contents = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, false), "UTF-8"));
            writer.write(contents);
            ((Writer)writer).close();
            writer = null;
        }
        catch (IOException ioe) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)SystemSummaryMessages.getString("SystemSummary.saveErrorTitle"), (String)SystemSummaryMessages.getFormattedString("SystemSummary.saveErrorMessage", new Object[]{filename, ioe.getMessage() == null ? "" : ioe.getMessage()}));
        }
        if (writer != null) {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getFilename() {
        String lastUsedPath = this.getDialogSettings().get(LAST_FILE);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.getEditorSite().getShell(), 4);
        dialog.setText(SystemSummaryMessages.getString("SystemSummary.dialogTitle"));
        dialog.setFilterPath(lastUsedPath);
        String filename = dialog.open();
        if (filename != null) {
            this.getDialogSettings().put(LAST_FILE, filename);
        }
        return filename;
    }

    private IDialogSettings getDialogSettings() {
        return WorkbenchPlugin.getDefault().getDialogSettings();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.copy"));
        this.addAction(menu, "copy");
        this.addAction(menu, "selectAll");
        menu.add((IContributionItem)new Separator("group.print"));
        this.addAction(menu, "print");
        menu.add((IContributionItem)new Separator("group.find"));
        this.addAction(menu, "find");
        this.addAction(menu, "GotoLine");
        menu.add((IContributionItem)new Separator("additions"));
    }
}

