/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PreferenceExporter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.internal.SystemSummaryMessages;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.SiteManager;

class SystemSummaryDocumentProvider
extends AbstractDocumentProvider {
    SystemSummaryDocumentProvider() {
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    public long getSynchronizationStamp(Object element) {
        return 0L;
    }

    public long getModificationStamp(Object element) {
        return 0L;
    }

    protected void doSaveDocument(IProgressMonitor arg0, Object arg1, IDocument arg2, boolean arg3) throws CoreException {
    }

    protected IDocument createDocument(Object element) throws CoreException {
        Document doc = new Document();
        doc.set(this.createDiagnostics());
        return doc;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    private String createDiagnostics() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        this.appendTimestamp(writer);
        this.appendProperties(writer);
        this.appendFeatures(writer);
        this.appendRegistry(writer);
        this.appendUserPreferences(writer);
        this.appendUpdateManagerLog(writer);
        this.appendLog(writer);
        writer.close();
        return out.toString();
    }

    private void appendTimestamp(PrintWriter writer) {
        writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.timeStamp", new Date()));
    }

    private void appendProperties(PrintWriter writer) {
        writer.println();
        writer.println(SystemSummaryMessages.getString("SystemSummary.systemProperties"));
        Properties properties = System.getProperties();
        TreeSet set = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareTo(s2);
            }
        });
        set.addAll(((Hashtable)properties).keySet());
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            writer.print(key);
            writer.print('=');
            writer.println(((Hashtable)properties).get(key));
        }
    }

    private void appendFeatures(PrintWriter writer) {
        writer.println();
        writer.println(SystemSummaryMessages.getString("SystemSummary.features"));
        IPlatformConfiguration platformConfiguration = BootLoader.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] featuresArray = platformConfiguration.getConfiguredFeatureEntries();
        Arrays.sort(featuresArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IPlatformConfiguration.IFeatureEntry)o1).getFeatureIdentifier();
                String s2 = ((IPlatformConfiguration.IFeatureEntry)o2).getFeatureIdentifier();
                return s1.compareTo(s2);
            }
        });
        int i = 0;
        while (i < featuresArray.length) {
            IPlatformConfiguration.IFeatureEntry info = featuresArray[i];
            Object[] args = new String[]{info.getFeatureIdentifier(), info.getFeatureVersion(), info.getFeaturePluginIdentifier()};
            writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.featureVersion", args));
            ++i;
        }
    }

    private void appendRegistry(PrintWriter writer) {
        writer.println();
        writer.println(SystemSummaryMessages.getString("SystemSummary.pluginRegistry"));
        IPluginDescriptor[] descriptors = Platform.getPluginRegistry().getPluginDescriptors();
        TreeSet<IPluginDescriptor> set = new TreeSet<IPluginDescriptor>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IPluginDescriptor)o1).getUniqueIdentifier();
                String s2 = ((IPluginDescriptor)o2).getUniqueIdentifier();
                return s1.compareTo(s2);
            }
        });
        int i = 0;
        int length = descriptors.length;
        while (i < length) {
            set.add(descriptors[i]);
            ++i;
        }
        Iterator i2 = set.iterator();
        while (i2.hasNext()) {
            PluginDescriptor descriptor = (PluginDescriptor)i2.next();
            Object[] args = new String[]{descriptor.getUniqueIdentifier(), descriptor.getVersionIdentifier().toString(), descriptor.getLabel()};
            writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.descriptorIdVersion", args));
            PluginFragmentModel[] fragments = descriptor.getFragments();
            if (fragments == null) continue;
            int j = 0;
            int length2 = fragments.length;
            while (j < length2) {
                PluginFragmentModel fragment = fragments[j];
                writer.print('\t');
                args = new String[]{fragment.getId(), fragment.getVersion(), fragment.getName()};
                writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.fragmentIdVersion", args));
                ++j;
            }
        }
    }

    private void appendUserPreferences(PrintWriter writer) {
        String tmpFile = ".tmpPrefFile";
        Path path = new Path(InternalPlatform.getMetaArea().getLocation().append(tmpFile).toOSString());
        File file = path.toFile();
        file.delete();
        try {
            PreferenceExporter.exportPreferences((IPath)path);
        }
        catch (CoreException e) {
            writer.println("Error exporting user preferences " + e.toString());
        }
        writer.println();
        writer.println(SystemSummaryMessages.getString("SystemSummary.userPreferences"));
        BufferedReader reader = null;
        try {
            FileInputStream in = new FileInputStream(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)in, "8859_1"));
            char[] chars = new char[8192];
            int read = reader.read(chars);
            while (read > 0) {
                writer.write(chars, 0, read);
                read = reader.read(chars);
            }
            reader.close();
            reader = null;
        }
        catch (IOException e) {
            writer.println("Error reading user preference file " + e.toString());
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                writer.println("Error closing user preference file " + e.toString());
            }
        }
        file.delete();
    }

    private void appendUpdateManagerLog(PrintWriter writer) {
        ILocalSite site;
        writer.println();
        writer.println(SystemSummaryMessages.getString("SystemSummary.updateManagerLog"));
        try {
            site = SiteManager.getLocalSite();
        }
        catch (CoreException e) {
            e.printStackTrace(writer);
            return;
        }
        IInstallConfiguration[] configurations = site.getConfigurationHistory();
        int i = 0;
        while (i < configurations.length) {
            writer.println();
            if (i > 0) {
                writer.println("----------------------------------------------------");
            }
            writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.configuration", configurations[i].getLabel()));
            writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.isCurrentConfiguration", "" + configurations[i].isCurrent()));
            IActivity[] activities = configurations[i].getActivities();
            int j = 0;
            while (j < activities.length) {
                writer.println();
                writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.date", activities[j].getDate()));
                writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.target", activities[j].getLabel()));
                writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.action", this.getActionLabel(activities[j])));
                writer.println(SystemSummaryMessages.getFormattedString("SystemSummary.status", this.getStatusLabel(activities[j])));
                ++j;
            }
            ++i;
        }
    }

    private void appendLog(PrintWriter writer) {
        File log = new File(InternalPlatform.getMetaArea().getLogLocation().toOSString());
        if (log.exists()) {
            writer.println();
            writer.println(SystemSummaryMessages.getString("SystemSummary.errorLog"));
            BufferedReader reader = null;
            try {
                FileInputStream in = new FileInputStream(log);
                reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                char[] chars = new char[8192];
                int read = reader.read(chars);
                while (read > 0) {
                    writer.write(chars, 0, read);
                    read = reader.read(chars);
                }
                reader.close();
                reader = null;
            }
            catch (IOException iOException) {
                writer.println("Error reading .log file");
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    writer.println("Error reading .log file");
                }
            }
        }
    }

    private String getActionLabel(IActivity activity) {
        int action = activity.getAction();
        switch (action) {
            case 6: {
                return SystemSummaryMessages.getString("SystemSummary.activity.enabled");
            }
            case 1: {
                return SystemSummaryMessages.getString("SystemSummary.activity.featureInstalled");
            }
            case 2: {
                return SystemSummaryMessages.getString("SystemSummary.activity.featureRemoved");
            }
            case 3: {
                return SystemSummaryMessages.getString("SystemSummary.activity.siteInstalled");
            }
            case 4: {
                return SystemSummaryMessages.getString("SystemSummary.activity.siteRemoved");
            }
            case 5: {
                return SystemSummaryMessages.getString("SystemSummary.activity.disabled");
            }
            case 7: {
                return SystemSummaryMessages.getString("SystemSummary.activity.revert");
            }
            case 8: {
                return SystemSummaryMessages.getString("SystemSummary.activity.reconcile");
            }
            case 9: {
                return SystemSummaryMessages.getString("SystemSummary.activity.preserved");
            }
        }
        return SystemSummaryMessages.getString("SystemSummary.activity.unknown");
    }

    private String getStatusLabel(IActivity activity) {
        switch (activity.getStatus()) {
            case 0: {
                return SystemSummaryMessages.getString("SystemSummary.activity.status.success");
            }
            case 1: {
                return SystemSummaryMessages.getString("SystemSummary.activity.status.failure");
            }
        }
        return SystemSummaryMessages.getString("SystemSummary.activity.status.unknown");
    }
}

