/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EncodingActionGroup;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.StatusTextEditor;

public class DefaultEncodingSupport
implements IEncodingSupport {
    private Preferences.IPropertyChangeListener fPropertyChangeListener;
    private StatusTextEditor fTextEditor;
    private EncodingActionGroup fEncodingActionGroup;

    public void initialize(StatusTextEditor textEditor) {
        this.fTextEditor = textEditor;
        this.fPropertyChangeListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent e) {
                if ("encoding".equals(e.getProperty())) {
                    DefaultEncodingSupport.this.setEncoding(null, false);
                }
            }
        };
        Preferences p = ResourcesPlugin.getPlugin().getPluginPreferences();
        p.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fEncodingActionGroup = new EncodingActionGroup((ITextEditor)this.fTextEditor);
        this.fEncodingActionGroup.update();
    }

    public void dispose() {
        Preferences p = ResourcesPlugin.getPlugin().getPluginPreferences();
        p.removePropertyChangeListener(this.fPropertyChangeListener);
        this.fEncodingActionGroup.dispose();
        this.fEncodingActionGroup = null;
        this.fTextEditor = null;
    }

    public void reset() {
        this.fEncodingActionGroup.update();
    }

    protected void setEncoding(String encoding, boolean overwrite) {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IEditorInput input = this.fTextEditor.getEditorInput();
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            String current = provider.getEncoding(input);
            String defaultEncoding = provider.getDefaultEncoding();
            if (current != null && current.equals(defaultEncoding)) {
                provider.setEncoding(input, encoding);
            } else if (!this.fTextEditor.isDirty()) {
                boolean apply;
                String internal = encoding == null ? "" : encoding;
                boolean bl = apply = (overwrite || current == null) && !internal.equals(current);
                if (apply) {
                    provider.setEncoding(this.fTextEditor.getEditorInput(), encoding);
                    Runnable encodingSetter = new Runnable(){

                        public void run() {
                            DefaultEncodingSupport.this.fTextEditor.doRevertToSaved();
                            DefaultEncodingSupport.this.fTextEditor.updatePartControl(DefaultEncodingSupport.this.fTextEditor.getEditorInput());
                        }
                    };
                    Display display = this.fTextEditor.getSite().getShell().getDisplay();
                    if (display != null && !display.isDisposed()) {
                        BusyIndicator.showWhile((Display)display, (Runnable)encodingSetter);
                    } else {
                        encodingSetter.run();
                    }
                }
            }
            this.fEncodingActionGroup.update();
        }
    }

    public void setEncoding(String encoding) {
        this.setEncoding(encoding, true);
    }

    public String getEncoding() {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            return provider.getEncoding(this.fTextEditor.getEditorInput());
        }
        return null;
    }

    public String getDefaultEncoding() {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            return provider.getDefaultEncoding();
        }
        return null;
    }

    public String getStatusHeader(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException) {
            return TextEditorMessages.getString("Editor.error.unreadable_encoding.header");
        }
        if (t instanceof UnsupportedEncodingException) {
            return TextEditorMessages.getString("Editor.error.unsupported_encoding.header");
        }
        return null;
    }

    public String getStatusBanner(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException) {
            return TextEditorMessages.getString("Editor.error.unreadable_encoding.banner");
        }
        if (t instanceof UnsupportedEncodingException) {
            return TextEditorMessages.getString("Editor.error.unsupported_encoding.banner");
        }
        return null;
    }

    public String getStatusMessage(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException || t instanceof UnsupportedEncodingException) {
            String encoding = this.getEncoding();
            if (encoding == null) {
                encoding = this.getDefaultEncoding();
            }
            if (t instanceof CharConversionException) {
                if (encoding != null) {
                    return MessageFormat.format(TextEditorMessages.getString("Editor.error.unreadable_encoding.message_arg"), encoding);
                }
                return TextEditorMessages.getString("Editor.error.unreadable_encoding.message");
            }
            if (t instanceof UnsupportedEncodingException) {
                if (encoding != null) {
                    return MessageFormat.format(TextEditorMessages.getString("Editor.error.unsupported_encoding.message_arg"), encoding);
                }
                return TextEditorMessages.getString("Editor.error.unsupported_encoding.message");
            }
        }
        return null;
    }
}

