/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.navigation.component.tree;

import com.togethersoft.navigation.component.tree.Reference;
import com.togethersoft.navigation.component.tree.TreeNode;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class Tree
extends Panel
implements MouseListener,
MouseMotionListener,
KeyListener,
AdjustmentListener,
FocusListener {
    private JLabel lastInfoLabel = null;
    private JLabel infoLabel = null;
    private static final int HORIZONTAL_SB_HEIGHT = 16;
    private static final int VERTICAL_SB_WIDTH = 16;
    private static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");
    protected Applet applet;
    private TreeNode rootNode;
    private Hashtable nodes = new Hashtable();
    private boolean hasFocus = false;
    private boolean isLayoutComplete;
    private boolean showRootHandles = true;
    protected TreeNode selectedNode;
    private boolean firstTime = true;
    private Hashtable myCurrentURLs = new Hashtable();
    private Image expandedImage;
    private Image collapsedImage;
    private int labelOffset;
    private int imageOffset;
    private int indent;
    private int cellHeight;
    private int fontBaseOffset;
    private int horizPosPixels;
    private int vertPosPixels;
    private Dimension insets;
    private Dimension rootHandleDim;
    private Dimension iconDim;
    private Dimension imageDim = new Dimension();
    private Image imgDoubleBuffer = null;
    private Rectangle displayedRect = new Rectangle();
    private Scrollbar sb_Horizontal;
    private Scrollbar sb_Vertical;
    private Button scrollCorner;
    private boolean isRootVisible;
    private boolean isNSScrollers;

    public Tree(URL uRL) {
        this.setLayout(null);
        this.setBackground(new Color(192, 192, 192));
        this.rootNode = this.createNode("ROOT_NODE", null, null, null);
        this.isRootVisible = this.rootNode.isVisible();
        try {
            this.expandedImage = Toolkit.getDefaultToolkit().getImage(new URL(uRL, "model-tree/expanded.gif"));
            this.collapsedImage = Toolkit.getDefaultToolkit().getImage(new URL(uRL, "model-tree/collapsed.gif"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.labelOffset = 6;
        this.imageOffset = 3;
        this.sb_Horizontal = new Scrollbar(0);
        this.sb_Vertical = new Scrollbar(1);
        this.scrollCorner = new Button();
        this.insets = new Dimension(5, 5);
        this.rootHandleDim = new Dimension(9, 9);
        this.indent = 7 + this.rootHandleDim.width;
        this.iconDim = new Dimension(16, 16);
        this.fontBaseOffset = this.iconDim.height;
        this.setFont(new Font(this.getFontName(), 0, this.getFontSize()));
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getLeading() + fontMetrics.getAscent() + fontMetrics.getDescent();
        this.setCellHeight(n);
        this.fontBaseOffset = n < this.cellHeight ? (this.cellHeight + n) / 2 - fontMetrics.getDescent() : this.cellHeight - fontMetrics.getDescent();
        Scrollbar scrollbar = new Scrollbar();
        scrollbar.setValues(0, 3, 0, 10);
        scrollbar.setValue(10);
        this.isNSScrollers = scrollbar.getValue() == 10;
        this.sb_Horizontal.setUnitIncrement(16);
        if (this.sb_Horizontal.getBlockIncrement() < 128) {
            this.sb_Horizontal.setBlockIncrement(128);
        }
        this.sb_Horizontal.setBackground(new Color(192, 192, 192));
        this.add(this.sb_Horizontal);
        this.sb_Vertical.setBackground(new Color(192, 192, 192));
        this.add(this.sb_Vertical);
        this.scrollCorner.setEnabled(false);
        this.add(this.scrollCorner);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.sb_Horizontal.addAdjustmentListener(this);
        this.sb_Vertical.addAdjustmentListener(this);
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public TreeNode createNode(String string, String string2, String string3, Image image) {
        TreeNode treeNode = new TreeNode(string, string2, string3, image);
        this.nodes.put(string, treeNode);
        return treeNode;
    }

    public TreeNode findNode(String string) {
        return (TreeNode)this.nodes.get(string);
    }

    public void paint(Graphics graphics) {
        if (!this.isLayoutComplete) {
            this.doLayout();
        }
        if (this.imgDoubleBuffer == null) {
            return;
        }
        Graphics graphics2 = this.imgDoubleBuffer.getGraphics();
        graphics2.setFont(this.getFont());
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        graphics2.setColor(this.getForeground());
        graphics2.translate(-this.horizPosPixels, -this.vertPosPixels);
        this.drawNodeWithChildren(graphics2, this.rootNode, this.insets.width, this.insets.height);
        graphics2.dispose();
        graphics2 = this.imgDoubleBuffer.getGraphics();
        this.paintBorder(graphics2);
        graphics.drawImage(this.imgDoubleBuffer, 0, 0, this);
    }

    public void update(Graphics graphics) {
        if (!this.isLayoutComplete) {
            this.doLayout();
        }
        this.paint(graphics);
    }

    public void setApplet(Applet applet) {
        this.applet = applet;
    }

    public synchronized void doLayout() {
        this.isLayoutComplete = false;
        this.displayedRect.setBounds(0, 0, this.getBounds().width, this.getBounds().height);
        if (this.displayedRect.width < 1 || this.displayedRect.height < 1) {
            return;
        }
        try {
            int n;
            this.layoutNodeRecursively(this.rootNode);
            int n2 = this.getMaxWidth(this.rootNode, 0, true);
            int n3 = this.getMaxHeight(this.rootNode, 0, true) / this.cellHeight - (this.isRootVisible ? 0 : 1);
            if (n3 < 1) {
                System.err.println("max height " + this.getMaxHeight(this.rootNode, 0, true));
                System.err.println("cell height " + this.cellHeight);
                System.err.println("j == " + n3);
                return;
            }
            if (n2 + 1 > this.displayedRect.width) {
                this.displayedRect.height -= 16;
            }
            if (n3 > (n = this.displayedRect.height / this.cellHeight)) {
                this.displayedRect.width -= 16;
            }
            this.reshapeScrollbars(this.sb_Horizontal, 0, this.displayedRect.height, this.displayedRect.width, 16);
            this.sb_Horizontal.setValues(this.horizPosPixels, this.displayedRect.width, 0, n2 - (this.isNSScrollers ? this.displayedRect.width : 0));
            this.reshapeScrollbars(this.sb_Vertical, this.displayedRect.width, 0, 16, this.displayedRect.height);
            this.sb_Vertical.setValues(this.vertPosPixels / this.cellHeight, n, 0, n3 - (this.isNSScrollers ? n : 0));
            this.reshapeScrollbars(this.scrollCorner, this.displayedRect.width, this.displayedRect.height, 16, 16);
            if (this.displayedRect.height < 0) {
                this.displayedRect.height = 0;
            }
            if (this.displayedRect.width < 0) {
                this.displayedRect.width = 0;
            }
            if (this.imgDoubleBuffer != null && (this.imageDim.width != this.displayedRect.width || this.imageDim.height != this.displayedRect.height)) {
                this.imgDoubleBuffer.flush();
                this.imgDoubleBuffer = null;
            }
            if (this.imgDoubleBuffer == null) {
                this.imgDoubleBuffer = this.createImage(this.displayedRect.width, this.displayedRect.height);
                this.imageDim.width = this.displayedRect.width;
                this.imageDim.height = this.displayedRect.height;
            }
            this.isLayoutComplete = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.imgDoubleBuffer = null;
        }
    }

    public void setSelectionToTop() {
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.selectedNode = this.rootNode;
        while (this.selectedNode != null) {
            if (this.selectedNode.isVisible()) break;
            this.selectedNode = this.selectedNode.nextNode();
        }
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(true);
        }
    }

    public synchronized void setSelectedNode(TreeNode treeNode, boolean bl) {
        if (treeNode == null || treeNode == this.rootNode && !this.isRootVisible) {
            return;
        }
        TreeNode treeNode2 = this.selectedNode;
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.selectedNode = treeNode;
        this.selectedNode.setSelected(true);
        this.openReferences(treeNode);
        if (bl) {
            this.repaint();
        } else {
            if (treeNode2 != null) {
                this.repaintNode(treeNode2);
            }
            this.repaintNode(this.selectedNode);
        }
    }

    public void repaintNode(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        Rectangle rectangle = treeNode.getBounds();
        this.repaint(rectangle.x, rectangle.y - this.vertPosPixels, rectangle.width, rectangle.height);
    }

    public void repaint() {
        super.repaint();
    }

    public synchronized void toggleNodeExpansion(TreeNode treeNode) {
        treeNode.setCollapsed(!treeNode.isCollapsed());
        if (treeNode.isCollapsed()) {
            int n = this.vertPosPixels / this.cellHeight;
            int n2 = this.displayedRect.height / this.cellHeight;
            int n3 = this.getMaxHeight(this.rootNode, 0, true) / this.cellHeight - 1;
            if (n + n2 > n3) {
                n = Math.max(n3 - n2, 0);
            }
            this.vertPosPixels = n * this.cellHeight;
        }
        this.doLayout();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.displayedRect.contains(mouseEvent.getPoint().x, mouseEvent.getPoint().y)) {
            return;
        }
        this.requestFocus();
        int n = mouseEvent.getClickCount();
        int n2 = mouseEvent.getPoint().x + this.horizPosPixels;
        int n3 = 11;
        TreeNode treeNode = this.nodeAtLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (treeNode != null) {
            boolean bl;
            boolean bl2 = bl = !IS_MAC && n % 2 == 0;
            if (IS_MAC) {
                n = 1;
            }
            if (treeNode.getChild() != null && n2 > treeNode.getBounds().x && (n2 < treeNode.getBounds().x + n3 || bl)) {
                this.toggleNodeExpansion(treeNode);
                this.setSelectedNode(treeNode, true);
            } else if (n2 > treeNode.getBounds().x + n3 && n < 2) {
                this.setSelectedNode(treeNode, false);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.applet != null) {
            Point point = mouseEvent.getPoint();
            TreeNode treeNode = this.nodeAtLocation(point.x, point.y);
            if (treeNode == null) {
                this.applet.showStatus("");
            } else {
                this.applet.showStatus(treeNode.getLabel());
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.sb_Horizontal) {
            this.horizPosPixels = this.sb_Horizontal.getValue();
        } else if (adjustmentEvent.getSource() == this.sb_Vertical) {
            this.vertPosPixels = this.sb_Vertical.getValue() * this.cellHeight;
        }
        this.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        TreeNode treeNode;
        if (this.selectedNode == null) {
            return;
        }
        boolean bl = false;
        if (keyEvent.getKeyCode() == 10) {
            if (this.selectedNode.getChild() == null) {
                return;
            }
            this.toggleNodeExpansion(this.selectedNode);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 40) {
            bl = true;
        } else if (keyEvent.getKeyCode() == 38) {
            treeNode = this.selectedNode.prevNode();
            if (treeNode == null) {
                return;
            }
            boolean bl2 = false;
            if (treeNode.getBounds().y < this.vertPosPixels) {
                this.sb_Vertical.setValue(this.sb_Vertical.getValue() - 1);
                this.vertPosPixels -= this.cellHeight;
                bl2 = true;
            }
            this.setSelectedNode(treeNode, bl2);
        } else if (keyEvent.getKeyCode() == 37) {
            if (this.selectedNode.isCollapsed()) {
                treeNode = this.selectedNode;
                TreeNode treeNode2 = this.selectedNode.getParent();
                if (treeNode2 == null) {
                    return;
                }
                this.setSelectedNode(treeNode2, false);
            } else {
                this.toggleNodeExpansion(this.selectedNode);
                this.repaint();
            }
        } else if (keyEvent.getKeyCode() == 39) {
            if (this.selectedNode.isCollapsed()) {
                if (this.selectedNode.getChild() == null) {
                    return;
                }
                this.toggleNodeExpansion(this.selectedNode);
                this.repaint();
            } else {
                bl = true;
            }
        }
        if (bl) {
            treeNode = this.selectedNode.nextNode();
            if (treeNode == null) {
                return;
            }
            boolean bl3 = false;
            if (treeNode.getBounds().y + this.cellHeight - this.vertPosPixels > this.displayedRect.height) {
                this.vertPosPixels += this.cellHeight;
                if (this.sb_Vertical.getVisibleAmount() + this.sb_Vertical.getValue() >= this.sb_Vertical.getMaximum()) {
                    this.sb_Vertical.setMaximum(this.sb_Vertical.getMaximum() + 1);
                }
                this.sb_Vertical.setValue(this.sb_Vertical.getValue() + 1);
                bl3 = true;
            }
            this.setSelectedNode(treeNode, bl3);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.repaintNode(this.selectedNode);
        if (this.firstTime) {
            this.openReferences(this.selectedNode);
            this.firstTime = false;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.repaintNode(this.selectedNode);
    }

    private void showInfo(String string) {
        Object object;
        if (this.infoLabel == null) {
            object = new JFrame();
            ((Component)object).setSize(new Dimension(200, 120));
            this.infoLabel = new JLabel();
            ((JFrame)object).getContentPane().setLayout(new BorderLayout());
            ((JFrame)object).getContentPane().add((Component)this.infoLabel, "Center");
            this.lastInfoLabel = new JLabel();
            ((JFrame)object).getContentPane().add((Component)this.lastInfoLabel, "North");
            ((Window)object).show();
        }
        if ((object = this.infoLabel.getText()) != null) {
            this.lastInfoLabel.setText((String)object);
        }
        this.infoLabel.setText(string);
    }

    private void openReferences(TreeNode treeNode) {
        Enumeration enumeration = treeNode.references();
        while (enumeration.hasMoreElements()) {
            Reference reference = (Reference)enumeration.nextElement();
            String string = reference.getHref();
            String string2 = reference.getFrame();
            URL uRL = null;
            try {
                uRL = new URL(this.applet.getDocumentBase(), string);
            }
            catch (MalformedURLException malformedURLException) {
                int n = string.indexOf("#");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                try {
                    uRL = new URL(this.applet.getDocumentBase(), string);
                }
                catch (MalformedURLException malformedURLException2) {
                    System.out.println("exception " + malformedURLException2.getMessage());
                    System.out.println("file name: " + string);
                }
            }
            if (uRL == null) continue;
            this.applet.getAppletContext().showDocument(uRL, string2);
        }
    }

    private void reshapeScrollbars(Component component, int n, int n2, int n3, int n4) {
        component.setLocation(n, n2);
        component.setSize(n3, n4);
    }

    private TreeNode nodeAtLocation(int n, int n2) {
        if (!this.displayedRect.contains(n, n2)) {
            return null;
        }
        int n3 = n2 + this.vertPosPixels;
        TreeNode treeNode = this.rootNode;
        while (treeNode != null) {
            Rectangle rectangle = treeNode.getBounds();
            if (n3 > rectangle.y && n3 <= rectangle.y + rectangle.height && treeNode.isVisible()) {
                return treeNode;
            }
            treeNode = treeNode.nextNode();
        }
        return null;
    }

    private int getMaxWidth(TreeNode treeNode, int n, boolean bl) {
        int n2 = 0;
        TreeNode treeNode2 = treeNode;
        while (treeNode2 != null) {
            int n3;
            if (treeNode2.getBounds().width + n > n2) {
                n2 = treeNode2.getBounds().width + n;
            }
            if (!(bl && treeNode2.isCollapsed() || (n3 = this.getMaxWidth(treeNode2.getChild(), n + this.indent, bl)) <= n2)) {
                n2 = n3;
            }
            treeNode2 = treeNode2.getSibling();
        }
        return n2;
    }

    private int getMaxHeight(TreeNode treeNode, int n, boolean bl) {
        int n2 = n;
        TreeNode treeNode2 = treeNode;
        while (treeNode2 != null) {
            n2 += this.cellHeight;
            if (!bl || !treeNode2.isCollapsed()) {
                n2 = this.getMaxHeight(treeNode2.getChild(), n2, bl);
            }
            treeNode2 = treeNode2.getSibling();
        }
        return n2;
    }

    private void setCellHeight(int n) {
        this.cellHeight = n < this.iconDim.height + 1 ? this.iconDim.height + 1 : n;
        if (this.cellHeight < this.rootHandleDim.height) {
            this.cellHeight = this.rootHandleDim.height;
        }
    }

    private int drawRootHandle(Graphics graphics, TreeNode treeNode, int n, int n2) {
        if (this.showRootHandles) {
            Image image = null;
            try {
                if (treeNode.getFirstChildId() != null) {
                    image = treeNode.isCollapsed() ? this.collapsedImage : this.expandedImage;
                }
            }
            catch (Exception exception) {
                image = null;
            }
            if (image != null) {
                int n3 = n2 + (this.cellHeight - this.rootHandleDim.height) / 2;
                graphics.drawImage(image, n, n3, this.rootHandleDim.width, this.rootHandleDim.height, this);
            }
            n += this.rootHandleDim.width;
        }
        return n;
    }

    private void layoutNode(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        if (this.showRootHandles) {
            n = this.iconDim.width;
        }
        if (treeNode.getImage() != null) {
            n += this.iconDim.width + this.labelOffset;
        }
        if (treeNode.isVisible()) {
            n += fontMetrics.stringWidth(treeNode.getLabel());
        } else if (treeNode.getImage() != null) {
            n -= this.labelOffset;
        }
        treeNode.setBounds(new Rectangle(0, 0, n, this.cellHeight));
    }

    private void layoutNodeRecursively(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode;
        while (treeNode2 != null) {
            this.layoutNode(treeNode2);
            this.layoutNodeRecursively(treeNode2.getChild());
            treeNode2 = treeNode2.getSibling();
        }
    }

    private void drawNode(Graphics graphics, TreeNode treeNode, int n, int n2) {
        treeNode.moveBounds(n, n2);
        n = this.drawRootHandle(graphics, treeNode, n, n2);
        if (treeNode.getImage() != null) {
            graphics.drawImage(treeNode.getImage(), n += this.imageOffset, n2 + 1, this.iconDim.width, this.iconDim.height, this);
            n += this.iconDim.width;
        }
        if (treeNode.isVisible()) {
            n += this.labelOffset;
            n2 += this.fontBaseOffset;
            if (treeNode.isSelected()) {
                if (this.hasFocus) {
                    graphics.setColor(new Color(0, 0, 128));
                } else {
                    graphics.setColor(new Color(96, 96, 96));
                }
                Rectangle rectangle = treeNode.getBounds();
                int n3 = rectangle.width + rectangle.x - n;
                graphics.fillRect(n, rectangle.y, n3, rectangle.height);
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(this.getForeground());
            }
            graphics.setFont(this.getFont());
            graphics.drawString(treeNode.getLabel(), n, n2);
        }
    }

    private void paintBorder(Graphics graphics) {
        Rectangle rectangle = this.displayedRect;
        Color color = this.getBackground();
        Color color2 = color.darker();
        Color color3 = color2.darker();
        Color color4 = color3.darker();
        graphics.setColor(color3);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 1);
        graphics.setColor(color4);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.setColor(color2);
        graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    private int drawNodeWithChildren(Graphics graphics, TreeNode treeNode, int n, int n2) {
        TreeNode treeNode2 = treeNode;
        while (treeNode2 != null) {
            int n3 = n;
            int n4 = n2;
            if (treeNode2.isVisible()) {
                this.drawNode(graphics, treeNode2, n, n2);
                n3 += this.indent;
                n4 += this.cellHeight;
            }
            n2 = !treeNode2.isCollapsed() ? this.drawNodeWithChildren(graphics, treeNode2.getChild(), n3, n4) : n4;
            treeNode2 = treeNode2.getSibling();
        }
        return n2;
    }

    private int getFontSize() {
        int n = 10;
        boolean bl = System.getProperty("os.name").startsWith("Windows");
        boolean bl2 = System.getProperty("java.version").equals("1.1.4");
        if (!bl || bl2) {
            n = 12;
        }
        return n;
    }

    private String getFontName() {
        return "Tahoma";
    }
}

