/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.navigation.component.tree;

import com.togethersoft.navigation.component.tree.Tree;
import com.togethersoft.navigation.component.tree.TreeNode;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Parser {
    private URL myCodebase = null;
    private Tree myTree;
    private Hashtable images = new Hashtable();

    public Parser(URL uRL) {
        this.myCodebase = uRL;
    }

    public boolean parse(String string) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(string);
        }
        catch (IOException iOException) {
            System.err.println("Can't find file: " + string);
            return false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Parsing failed: " + string);
            return false;
        }
        catch (SAXException sAXException) {
            System.err.println("Parsing failed. " + sAXException);
            return false;
        }
        this.myTree = new Tree(this.myCodebase);
        TreeNode treeNode = this.myTree.getRootNode();
        treeNode.setCollapsed(false);
        this.parseNodeRecursively(document, treeNode);
        return true;
    }

    public Tree getTree() {
        return this.myTree;
    }

    private void parseNodeRecursively(Node node, TreeNode treeNode) {
        NodeList nodeList = node.getChildNodes();
        Object object = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object2;
            String string;
            String string2;
            Node node2 = nodeList.item(n);
            if ("reference".equals(node2.getNodeName())) {
                string2 = null;
                string = null;
                object2 = node2.getAttributes();
                if (object2 != null) {
                    int n2 = 0;
                    while (n2 < object2.getLength()) {
                        Node node3 = object2.item(n2);
                        if ("frame".equals(node3.getNodeName())) {
                            string2 = node3.getNodeValue();
                        } else if ("href".equals(node3.getNodeName())) {
                            string = node3.getNodeValue();
                        }
                        ++n2;
                    }
                    if (string2 != null && string != null) {
                        treeNode.addReference(string2, string);
                    }
                }
            } else if ("node".equals(node2.getNodeName())) {
                string2 = null;
                string = null;
                object2 = null;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                if (namedNodeMap != null) {
                    Object object3;
                    int n3 = 0;
                    while (n3 < namedNodeMap.getLength()) {
                        object3 = namedNodeMap.item(n3);
                        if ("name".equals(object3.getNodeName())) {
                            string2 = object3.getNodeValue();
                        } else if ("uin".equals(object3.getNodeName())) {
                            string = object3.getNodeValue();
                        } else if ("image".equals(object3.getNodeName())) {
                            object2 = object3.getNodeValue();
                        }
                        ++n3;
                    }
                    if (string != null && string2 != null) {
                        object3 = this.myTree.createNode(string, treeNode.getID(), string2, this.getImage((String)object2));
                        treeNode.addChild((TreeNode)object3);
                        treeNode.setFirstChildId(string);
                        if (object == null) {
                            object = object3;
                        } else {
                            ((TreeNode)object).setSiblingId(string);
                        }
                        this.parseNodeRecursively(node2, (TreeNode)object3);
                    }
                }
            }
            ++n;
        }
    }

    private Image getImage(String string) {
        if (string == null) {
            return null;
        }
        Image image = null;
        if (string != null) {
            if (this.images.contains(string)) {
                image = (Image)this.images.get(string);
            } else {
                try {
                    image = Toolkit.getDefaultToolkit().getImage(new URL(this.myCodebase, string));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (image != null) {
                this.images.put(string, image);
            }
        }
        return image;
    }

    static interface IAttributes {
        public static final String NAME = "name";
        public static final String IMAGE = "image";
        public static final String UIN = "uin";
        public static final String FRAME = "frame";
        public static final String HREF = "href";
    }

    static interface IElements {
        public static final String NODE = "node";
        public static final String REFERENCE = "reference";
    }
}

