/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.navigation.component;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class TabButton
extends Canvas {
    protected String name;
    protected int x_offset;
    protected int y_offset;
    protected Font active;
    protected Font inactive;
    protected int tab_x;
    protected int tab_y;
    protected int tab_width;
    protected int tab_height;
    protected Image img;
    protected boolean pushState;

    public TabButton(String string) {
        this.setBackground(Color.lightGray);
        this.x_offset = -1;
        this.y_offset = -1;
        int n = this.getFontSize();
        this.active = new Font(TabButton.getFontName(), 1, n);
        this.inactive = new Font(TabButton.getFontName(), 0, n);
        this.setFont(this.inactive);
        this.name = string;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.tab_x = n;
        this.tab_y = n2;
        this.tab_width = n3;
        this.tab_height = n4;
        this.centerText();
    }

    private int getFontSize() {
        int n = 12;
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
        String string = System.getProperty("java.version");
        if (bl && !"1.1.4".equals(string)) {
            n = 10;
        }
        return n;
    }

    public static String getFontName() {
        return "Dialog";
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        if (this.img != null) {
            graphics.drawImage(this.img, 2, 2, null);
        } else if (this.name != null) {
            if (this.x_offset == -1 || this.y_offset == -1) {
                this.centerText();
            }
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            graphics.drawString(this.name, this.x_offset, this.y_offset);
        }
        if (this.pushState) {
            this.paintBorderIn(graphics);
            return;
        }
        this.paintBorderOut(graphics);
    }

    public void paintBorderOut(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Color color = this.getBackground().brighter();
        Color color2 = color.darker();
        Color color3 = color2.darker();
        Color color4 = color3.darker();
        graphics.setColor(color3);
        graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color4);
        graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 2);
        graphics.setColor(color2);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        if (this.isEnabled()) {
            graphics.drawLine(0, rectangle.height - 1, rectangle.width, rectangle.height - 1);
        }
        graphics.setColor(color);
        graphics.drawLine(1, 0, rectangle.width - 2, 0);
        graphics.drawLine(0, 1, 0, rectangle.height - 2);
        if (this.isEnabled()) {
            graphics.drawLine(0, rectangle.height - 2, rectangle.width, rectangle.height - 2);
        }
    }

    public void paintBorderIn(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Color color = this.getBackground().brighter();
        Color color2 = color.darker();
        Color color3 = color2.darker();
        Color color4 = color3.darker();
        graphics.setColor(color4);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 1);
        graphics.setColor(color3);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.setColor(color2);
        graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.setFont(this.inactive);
        } else {
            this.setFont(this.active);
        }
        this.centerText();
        this.repaint();
        super.setEnabled(bl);
    }

    public Dimension getPreferredSize() {
        try {
            if (this.img != null) {
                return new Dimension(this.img.getWidth(this) + 4, this.img.getHeight(this) + 4);
            }
            if (this.name != null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int n = fontMetrics.stringWidth(this.name);
                int n2 = fontMetrics.getMaxAscent();
                return new Dimension(n += 4 + 2 * fontMetrics.getMaxAdvance(), n2 += 4 + fontMetrics.getMaxDescent());
            }
            return new Dimension(20, 20);
        }
        catch (Exception exception) {
            return new Dimension(20, 20);
        }
    }

    protected void centerText() {
        Rectangle rectangle = this.getBounds();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.name);
        int n2 = fontMetrics.getMaxAscent();
        this.y_offset = rectangle.height - n2;
        this.y_offset = this.y_offset / 2 + n2;
        this.x_offset = rectangle.width - n;
        this.x_offset /= 2;
    }

    public void setPushState(boolean bl) {
        this.pushState = bl;
    }

    public String getName() {
        return this.name;
    }
}

