/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.navigation;

import com.togethersoft.navigation.DiagramView;
import com.togethersoft.navigation.component.TabbedPane;
import com.togethersoft.navigation.component.tree.Parser;
import com.togethersoft.navigation.component.tree.Tree;
import com.togethersoft.navigation.component.tree.TreeNode;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class Navigation
extends Applet {
    private Tree tree;
    private DiagramView view;

    public void init() {
        try {
            System.err.println("java.vendor: " + System.getProperty("java.vendor"));
            System.err.println("document base: " + this.getDocumentBase());
            this.setLayout(new BorderLayout());
            String string = this.getParameter("ModelFile");
            if (string == null) {
                try {
                    JSObject.getWindow((Applet)this).eval("parent.alert(\"Model file isn't defined as applet parameter!\")");
                }
                catch (JSException jSException) {
                    jSException.printStackTrace();
                }
                return;
            }
            string = new URL(this.getCodeBase(), string).toString();
            System.out.println("Reading source file " + string);
            Parser parser = new Parser(this.getCodeBase());
            if (!parser.parse(string)) {
                System.err.println("Parsing Error. " + string);
                return;
            }
            this.tree = parser.getTree();
            this.tree.setApplet(this);
            String string2 = this.getParameter("ModelTab");
            String string3 = this.getParameter("ViewTab");
            TabbedPane tabbedPane = new TabbedPane();
            this.add("Center", tabbedPane);
            if (string2 != null) {
                tabbedPane.addComponent(string2, this.tree);
            }
            if (string3 != null) {
                this.view = new DiagramView(this);
                tabbedPane.addComponent(string3, this.view);
                try {
                    JSObject.getWindow((Applet)this).eval("parent.imageFrame.loadImage()");
                }
                catch (JSException jSException) {
                    jSException.printStackTrace();
                }
            }
            if (string2 != null) {
                tabbedPane.setActiveTab(string2);
            } else if (string3 != null) {
                tabbedPane.setActiveTab(string3);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void loadView(String string, int n, int n2) {
        this.view.loadView(string, n, n2);
    }

    public void repaint() {
        this.view.repaint();
    }

    public void moveSpot(int n, int n2) {
        this.view.moveSpot(n, n2);
    }

    public void setSpotSize(int n, int n2) {
        this.view.setSpotSize(n, n2);
    }

    public void setSelection(String string) {
        TreeNode treeNode;
        if (string != null && (treeNode = this.tree.findNode(string)) != null) {
            this.tree.setSelectedNode(treeNode, true);
            this.recursiveExpandNode(treeNode.getParent());
            return;
        }
        this.tree.setSelectionToTop();
        this.tree.requestFocus();
    }

    private void recursiveExpandNode(TreeNode treeNode) {
        if (treeNode != null && treeNode.isCollapsed()) {
            this.recursiveExpandNode(treeNode.getParent());
            this.tree.toggleNodeExpansion(treeNode);
        }
    }

    private String readFile(URL uRL) throws IOException {
        System.out.println("reading input file");
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[512];
        int n = 0;
        InputStreamReader inputStreamReader = null;
        boolean bl = false;
        try {
            inputStreamReader = new InputStreamReader(uRL.openStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("UTF8 Encoding is not supported");
            inputStreamReader = new InputStreamReader(uRL.openStream());
            bl = true;
        }
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuffer.append(new String(cArray, 0, n));
        }
        ((Reader)inputStreamReader).close();
        String string = stringBuffer.toString();
        return bl ? this.decodeUTF8(string) : string;
    }

    private String decodeUTF8(String string) {
        int n = string.length();
        byte[] byArray = string.getBytes();
        char[] cArray = new char[n];
        int n2 = 0;
        byte[] byArray2 = new byte[5];
        char[] cArray2 = new char[2];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = n4;
            if (((n8 = byArray[n4++] & 0xFF) & 0x80) == 0) {
                cArray2[0] = (char)n8;
                n7 = 1;
            } else if ((n8 & 0xE0) == 192) {
                if (n4 >= n) {
                    n2 = 1;
                    byArray2[0] = (byte)n8;
                    break;
                }
                if (((n6 = byArray[n4++] & 0xFF) & 0xC0) != 128) {
                    System.err.println("Bad input");
                    return string;
                }
                cArray2[0] = (char)((n8 & 0x1F) << 6 | n6 & 0x3F);
                n7 = 1;
            } else if ((n8 & 0xF0) == 224) {
                if (n4 + 1 >= n) {
                    byArray2[0] = (byte)n8;
                    if (n4 >= n) {
                        n2 = 1;
                        break;
                    }
                    n2 = 2;
                    byArray2[1] = byArray[n4++];
                    break;
                }
                n6 = byArray[n4++] & 0xFF;
                n5 = byArray[n4++] & 0xFF;
                if ((n6 & 0xC0) != 128 || (n5 & 0xC0) != 128) {
                    System.err.println("Bad input");
                    return string;
                }
                cArray2[0] = (char)((n8 & 0xF) << 12 | (n6 & 0x3F) << 6 | n5 & 0x3F);
                n7 = 1;
            } else if ((n8 & 0xF8) == 240) {
                if (n4 + 2 >= n) {
                    byArray2[0] = (byte)n8;
                    if (n4 >= n) {
                        n2 = 1;
                        break;
                    }
                    if (n4 + 1 >= n) {
                        n2 = 2;
                        byArray2[1] = byArray[n4++];
                        break;
                    }
                    n2 = 3;
                    byArray2[1] = byArray[n4++];
                    byArray2[2] = byArray[n4++];
                    break;
                }
                n6 = byArray[n4++] & 0xFF;
                n5 = byArray[n4++] & 0xFF;
                int n10 = byArray[n4++] & 0xFF;
                if ((n6 & 0xC0) != 128 || (n5 & 0xC0) != 128 || (n10 & 0xC0) != 128) {
                    System.err.println("Bad input");
                    return string;
                }
                int n11 = (7 & n8) << 18 | (0x3F & n6) << 12 | (0x3F & n5) << 6 | 0x3F & n10;
                cArray2[0] = (char)((n11 - 65536) / 1024 + 55296);
                cArray2[1] = (char)((n11 - 65536) % 1024 + 56320);
                n7 = 2;
            } else {
                System.err.println("Bad input");
                return string;
            }
            if (n3 + n7 > n) {
                System.err.println("Buffer is full");
                return string;
            }
            n6 = 0;
            while (n6 < n7) {
                cArray[n3 + n6] = cArray2[n6];
                ++n6;
            }
            n3 += n7;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray);
        return stringBuffer.toString();
    }
}

