/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.navigation;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class DiagramView
extends Panel {
    private JSObject appletWindow;
    private Hashtable images = new Hashtable();
    private Applet applet;
    private Image myImage = null;
    private int myWidth = 0;
    private int myHeight = 0;
    private int maxWidth = 1;
    private int maxHeight = 1;
    private int imgW = 0;
    private int imgH = 0;
    private double rate = 1.0;
    private int xs = 0;
    private int ys = 0;
    private Rectangle spotRect = new Rectangle();
    private Point dragPoint = new Point();
    private boolean onSpot = false;
    private boolean isDragged = false;

    public DiagramView(Applet applet) {
        this.applet = applet;
        try {
            this.appletWindow = JSObject.getWindow((Applet)applet);
        }
        catch (JSException jSException) {
            // empty catch block
        }
        this.setBackground(Color.lightGray);
        this.setSize(200, 200);
        this.maxWidth = this.getSize().width - 2;
        this.maxHeight = this.getSize().height - 2;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DiagramView.this.onSpot) {
                    DiagramView.this.dragPoint = mouseEvent.getPoint();
                    DiagramView.this.xs = ((DiagramView)DiagramView.this).dragPoint.x - ((DiagramView)DiagramView.this).spotRect.x;
                    DiagramView.this.ys = ((DiagramView)DiagramView.this).dragPoint.y - ((DiagramView)DiagramView.this).spotRect.y;
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DiagramView.this.isDragged = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (DiagramView.this.spotRect.contains(mouseEvent.getPoint())) {
                    DiagramView.this.setCursor(new Cursor(13));
                    DiagramView.this.onSpot = true;
                } else {
                    DiagramView.this.setCursor(new Cursor(0));
                    DiagramView.this.onSpot = false;
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (DiagramView.this.onSpot) {
                    DiagramView.this.isDragged = true;
                    Graphics graphics = DiagramView.this.getGraphics();
                    graphics.setXORMode(Color.white);
                    DiagramView.this.drawSpot(graphics);
                    DiagramView.this.dragPoint = mouseEvent.getPoint();
                    DiagramView.this.setSpotLocation(mouseEvent.getX() - DiagramView.this.xs, mouseEvent.getY() - DiagramView.this.ys);
                    DiagramView.this.drawSpot(graphics);
                    graphics.dispose();
                    try {
                        if (DiagramView.this.appletWindow != null) {
                            DiagramView.this.appletWindow.eval("parent.imageFrame.scroll(" + String.valueOf((double)Math.round((double)((DiagramView)DiagramView.this).spotRect.x - 1.0) * DiagramView.this.rate) + ", " + String.valueOf((double)Math.round((double)((DiagramView)DiagramView.this).spotRect.y - 1.0) * DiagramView.this.rate) + ")");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        graphics.setPaintMode();
        if (this.myImage != null) {
            graphics.drawImage(this.myImage, 1, 1, this.myWidth, this.myHeight, this);
        }
        this.drawSpot(graphics);
        graphics.setColor(Color.blue);
        graphics.drawRect(0, 0, this.myWidth + 2, this.myHeight + 2);
    }

    private void drawSpot(Graphics graphics) {
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.black);
        graphics.fillRect(this.spotRect.x, this.spotRect.y, this.spotRect.width, this.spotRect.height);
    }

    public void loadView(String string, int n, int n2) {
        if (this.images.containsKey(string)) {
            ImageInfo imageInfo = (ImageInfo)this.images.get(string);
            this.myImage = imageInfo.getImage();
            this.myWidth = imageInfo.getWidth();
            this.myHeight = imageInfo.getHeight();
            this.rate = imageInfo.getRate();
            this.imgW = imageInfo.getImageWidth();
            this.imgH = imageInfo.getImageHeight();
        } else {
            Object object;
            try {
                double d;
                object = this.applet.getImage(this.applet.getDocumentBase(), string);
                if (object == null) {
                    return;
                }
                this.imgW = n;
                this.imgH = n2;
                double d2 = (double)this.imgW / (double)this.maxWidth;
                if (d2 < 1.0) {
                    d2 = 1.0;
                }
                if ((d = (double)this.imgH / (double)this.maxHeight) < 1.0) {
                    d = 1.0;
                }
                this.rate = Math.max(d2, d);
                this.myHeight = (int)Math.round((double)this.imgH / this.rate) - 1;
                this.myWidth = (int)Math.round((double)this.imgW / this.rate) - 1;
                this.myImage = ((Image)object).getScaledInstance(this.myWidth, this.myHeight, 4);
                ((Image)object).flush();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            if (this.myHeight > 1 && this.myWidth > 1) {
                object = new ImageInfo(this.myImage, this.myWidth, this.myHeight, this.rate, this.imgW, this.imgH);
                this.images.put(string, object);
            }
        }
    }

    public void setSpotSize(int n, int n2) {
        double d = (double)this.imgW / (double)n;
        double d2 = (double)this.imgH / (double)n2;
        int n3 = (int)Math.round((double)this.myWidth / d);
        int n4 = (int)Math.round((double)this.myHeight / d2);
        n3 = Math.min(n3, this.myWidth);
        n4 = Math.min(n4, this.myHeight);
        if (n3 <= 1) {
            n3 = 1;
        }
        if (n4 <= 1) {
            n4 = 1;
        }
        this.spotRect.setSize(n3, n4);
        int n5 = this.myWidth + 2 - this.spotRect.x - this.spotRect.width;
        int n6 = this.myHeight + 2 - this.spotRect.y - this.spotRect.height;
        if (n5 >= 0) {
            n5 = 0;
        }
        if (n6 >= 0) {
            n6 = 0;
        }
        if (n5 < 0 || n6 < 0) {
            this.moveSpotRelative(n5, n6);
        }
    }

    public void moveSpot(int n, int n2) {
        if (!this.isDragged) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(Color.white);
            this.drawSpot(graphics);
            int n3 = (int)Math.round((double)n / this.rate) + 1;
            int n4 = (int)Math.round((double)n2 / this.rate) + 1;
            this.setSpotLocation(n3, n4);
            this.drawSpot(graphics);
            graphics.dispose();
        }
    }

    private void moveSpotRelative(int n, int n2) {
        if (!this.isDragged) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(Color.white);
            this.drawSpot(graphics);
            int n3 = this.spotRect.x + n;
            int n4 = this.spotRect.y + n2;
            this.setSpotLocation(n3, n4);
            this.drawSpot(graphics);
            graphics.dispose();
        }
    }

    private void setSpotLocation(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n < 1) {
            n3 = 1;
        } else if (n + this.spotRect.width > this.myWidth + 2) {
            n3 = this.myWidth + 2 - this.spotRect.width;
        }
        if (n2 < 1) {
            n4 = 1;
        } else if (n2 + this.spotRect.height > this.myHeight + 2) {
            n4 = this.myHeight + 2 - this.spotRect.height;
        }
        this.spotRect.setLocation(n3, n4);
    }

    private class ImageInfo {
        private int width = 0;
        private int height = 0;
        private int imgW = 0;
        private int imgH = 0;
        private Image image = null;
        private double rate = 1.0;

        ImageInfo(Image image, int n, int n2, double d, int n3, int n4) {
            this.image = image;
            this.width = n;
            this.height = n2;
            this.rate = d;
            this.imgW = n3;
            this.imgH = n4;
        }

        int getWidth() {
            return this.width;
        }

        int getHeight() {
            return this.height;
        }

        double getRate() {
            return this.rate;
        }

        Image getImage() {
            return this.image;
        }

        int getImageWidth() {
            return this.imgW;
        }

        int getImageHeight() {
            return this.imgH;
        }
    }
}

