/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.types;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.endpoints.TypeNotFoundException;
import com.sap.ide.vi.types.Attribute;
import com.sap.ide.vi.types.Method;
import com.sap.ide.vi.types.Parameter;
import com.sap.ide.vi.types.TypeAnalyser;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class TypeInSourcePaths
extends TypeAnalyser {
    private static final String ENDPOINT_SUFFIX_JAVA = "java";
    private static final String DOT = ".";
    private static final String EMPTY_CONTENT = "";
    private IType type;
    static /* synthetic */ Class class$com$sap$ide$vi$types$TypeInSourcePaths;

    public TypeInSourcePaths(String projectName, String qualifiedType, int myCheckType) throws JavaModelException, InadmissableTypeException {
        super(projectName);
        CompUnitResult compResult;
        if (this.isJavaPrimitiveType(qualifiedType)) {
            qualifiedType = TypeAnalyser.getQualifiedTypeNameForPrimitiveType(qualifiedType);
        }
        if ((compResult = this.getCompilationUnitByQualifiedName(qualifiedType)) == null) {
            throw new TypeNotFoundException(qualifiedType);
        }
        compResult.setName(qualifiedType);
        this.type = compResult.getTypeByName();
        this.myCheckType = myCheckType;
    }

    protected boolean isForbidden() {
        return TypeAnalyser.forbiddenClasses.contains(this.type.getElementName());
    }

    public String getAnalysedTypeName() {
        return this.type.getFullyQualifiedName();
    }

    public IType getType() {
        return this.type;
    }

    private CompUnitResult getCompilationUnitByQualifiedName(String viReference) {
        String absolutePath;
        String virtName = viReference;
        String virtPackage = EMPTY_CONTENT;
        if (viReference.indexOf(DOT) > -1) {
            virtName = viReference.substring(viReference.lastIndexOf(DOT) + 1, viReference.length());
            virtPackage = viReference.substring(0, viReference.lastIndexOf(DOT));
        }
        if ((absolutePath = MetamodelManager.getMetamodelManager((String)this.projectName).getMDOPath(virtPackage, virtName, ENDPOINT_SUFFIX_JAVA)) == null) {
            if (virtPackage.equals(EMPTY_CONTENT)) {
                return null;
            }
            return this.getCompilationUnitByQualifiedName(virtPackage);
        }
        return new CompUnitResult(absolutePath, virtPackage);
    }

    public Vector getMethods() throws InadmissableTypeException {
        Vector<Method> resultVector = null;
        try {
            resultVector = this.type.getMethods().length > 0 ? new Vector(this.type.getMethods().length) : new Vector<Method>();
            int i = 0;
            while (i < this.type.getMethods().length) {
                String resTypename;
                IMethod method = this.type.getMethods()[i];
                Parameter[] params = new Parameter[method.getParameterTypes().length];
                int j = 0;
                while (j < method.getParameterTypes().length) {
                    resTypename = TypeInSourcePaths.getResolvedType(method.getParameterTypes()[j], this.type, true);
                    params[j] = new Parameter(method.getParameterNames()[j], resTypename, 0, 0);
                    ++j;
                }
                resTypename = TypeInSourcePaths.getResolvedType(method.getReturnType(), this.type, true);
                resultVector.add(new Method(method.getElementName(), resTypename, 0, method.getFlags(), params, this.type.getFullyQualifiedName()));
                ++i;
            }
        }
        catch (JavaModelException ex) {
            WebServiceCorePlugin.logError((Throwable)ex, this.getClass());
        }
        return resultVector;
    }

    public Vector getAttributes() throws InadmissableTypeException {
        Vector<Attribute> resultVector = null;
        try {
            resultVector = new Vector<Attribute>();
            int i = 0;
            while (i < this.type.getFields().length) {
                IField field = this.type.getFields()[i];
                if (!Flags.isStatic((int)field.getFlags()) || !Flags.isFinal((int)field.getFlags())) {
                    String resTypename = TypeInSourcePaths.getResolvedType(field.getTypeSignature(), this.type, true);
                    resultVector.add(new Attribute(field.getElementName(), resTypename, field.getFlags(), TypeAnalyser.isTableType(resTypename), 0, this.type.getFullyQualifiedName()));
                }
                ++i;
            }
        }
        catch (JavaModelException ex) {
            WebServiceCorePlugin.logError((Throwable)ex, this.getClass());
        }
        return resultVector;
    }

    public boolean parameterFullConstructorExisting() {
        try {
            IMethod[] methods = this.type.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor() && methods[i].getParameterNames().length > 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            return false;
        }
    }

    public boolean parameterLessConstructorExisting() {
        try {
            IMethod[] methods = this.type.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor() && methods[i].getParameterNames().length == 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            return false;
        }
    }

    public boolean isJavaPrimitiveType() {
        return super.isJavaPrimitiveType(this.type.toString());
    }

    public static String getResolvedType(String typeName, IType type, boolean getSignatureFirst) {
        return TypeInSourcePaths.getResolvedType(typeName, type, true, getSignatureFirst);
    }

    public static String getResolvedType(String typeName, IType type, boolean arrayMarksDesired, boolean getSignatureFirst) {
        String ty = typeName;
        if (getSignatureFirst) {
            try {
                ty = Signature.toString((String)typeName);
            }
            catch (IllegalArgumentException e) {
                WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$types$TypeInSourcePaths == null ? (class$com$sap$ide$vi$types$TypeInSourcePaths = TypeInSourcePaths.class$("com.sap.ide.vi.types.TypeInSourcePaths")) : class$com$sap$ide$vi$types$TypeInSourcePaths));
            }
        }
        return TypeInSourcePaths.resolveTypeWithArray(ty, type, arrayMarksDesired);
    }

    private static String resolveTypeWithArray(String typeName, IType type, boolean arrayMarksDesired) {
        String result = null;
        if (TypeAnalyser.isTableType(typeName)) {
            result = TypeInSourcePaths.resolveTypeWithArray(TypeAnalyser.getLineType(typeName), type, arrayMarksDesired) + (arrayMarksDesired ? "[]" : "Array");
        } else {
            result = TypeInSourcePaths.resolveType(typeName, type);
            if (result == null && typeName.indexOf(DOT) > -1) {
                String head = typeName.substring(0, typeName.indexOf(DOT));
                String tail = typeName.substring(typeName.indexOf(DOT));
                result = TypeInSourcePaths.resolveType(head, type);
                if (result != null) {
                    result = result + tail;
                } else {
                    System.err.println("Type resolution error for type name: " + typeName);
                }
            }
        }
        if (result != null) {
            return result;
        }
        return typeName;
    }

    private static String resolveType(String typeName, IType type) {
        String[][] st = null;
        try {
            st = type.resolveType(typeName);
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$types$TypeInSourcePaths == null ? (class$com$sap$ide$vi$types$TypeInSourcePaths = TypeInSourcePaths.class$("com.sap.ide.vi.types.TypeInSourcePaths")) : class$com$sap$ide$vi$types$TypeInSourcePaths));
        }
        if (st != null) {
            if (st[0][0].equals(EMPTY_CONTENT)) {
                return st[0][1];
            }
            return st[0][0] + DOT + st[0][1];
        }
        if (typeName.startsWith(new String(new char[]{'Q'}))) {
            return TypeInSourcePaths.resolveType(typeName.substring(1, typeName.length()), type);
        }
        return null;
    }

    protected String getName() {
        return this.type.getElementName();
    }

    protected String getSuperClassName() {
        String superClass = null;
        try {
            superClass = this.type.getSuperclassName();
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
        return superClass;
    }

    public TypeAnalyser getInterfaceType(String interfaceName) throws InadmissableTypeException {
        String[] interfaceNames = this.getInterfaceNames();
        int i = 0;
        while (i < interfaceNames.length) {
            if (interfaceNames[i].equals(interfaceName)) {
                return TypeAnalyser.getInstance(this.projectName, TypeInSourcePaths.getResolvedType(interfaceName, this.type, false), this.myCheckType);
            }
            ++i;
        }
        return null;
    }

    protected String[] getInterfaceNames() {
        String[] interfaceNames = null;
        try {
            interfaceNames = this.type.getSuperInterfaceNames();
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
        return interfaceNames;
    }

    public boolean equals(TypeAnalyser t) {
        if (t instanceof TypeInSourcePaths) {
            return this.type.getFullyQualifiedName().equals(((TypeInSourcePaths)t).getType().getFullyQualifiedName());
        }
        return false;
    }

    public boolean isAbstract() {
        try {
            return Flags.isAbstract((int)this.type.getFlags());
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            return false;
        }
    }

    public boolean isInterface() {
        try {
            return this.type.isInterface();
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CompUnitResult {
        private ICompilationUnit unit;
        private String virtPackage;
        private String virtName;
        private String absolutePath;

        public CompUnitResult(String path, String pack) {
            this.absolutePath = path;
            this.virtPackage = pack;
            this.absolutePath = this.absolutePath.replace('\\', '/');
            IClasspathEntry[] classpaths = MetamodelManager.getJavaProjectClassPaths((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(TypeInSourcePaths.this.projectName));
            int i = 0;
            while (i < classpaths.length) {
                String clpath = classpaths[i].getPath().toString().replace('\\', '/');
                if (this.absolutePath.indexOf(clpath) > -1) {
                    this.absolutePath = this.absolutePath.substring(this.absolutePath.indexOf(clpath), this.absolutePath.length());
                    break;
                }
                ++i;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.absolutePath));
            this.unit = JavaCore.createCompilationUnitFrom((IFile)file);
        }

        public void setName(String viReference) {
            if (viReference.indexOf(this.virtPackage) > -1) {
                this.virtName = this.virtPackage.length() == 0 ? viReference : viReference.substring(viReference.indexOf(this.virtPackage) + this.virtPackage.length() + 1, viReference.length());
            }
        }

        public IType getTypeByName() throws JavaModelException {
            return this.getTypeByName(this.unit, this.virtName);
        }

        private IType getTypeByName(ICompilationUnit cu, String name) throws JavaModelException {
            if (name.indexOf(TypeInSourcePaths.DOT) > -1) {
                String nameHead = name.substring(0, name.indexOf(TypeInSourcePaths.DOT));
                String nameTail = name.substring(name.indexOf(TypeInSourcePaths.DOT) + 1, name.length());
                IType headType = this.getTypeByName(cu, nameHead);
                return this.getTypeByName(headType, nameTail);
            }
            return cu.getType(name);
        }

        private IType getTypeByName(IType type, String name) throws JavaModelException {
            IType returnType = null;
            String nameHead = name;
            String nameTail = null;
            if (name.indexOf(TypeInSourcePaths.DOT) > -1) {
                nameHead = name.substring(0, name.indexOf(TypeInSourcePaths.DOT));
                nameTail = name.substring(name.indexOf(TypeInSourcePaths.DOT) + 1, name.length());
            }
            IJavaElement[] elements = type.getChildren();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IType && ((IType)elements[i]).getElementName().equals(nameHead)) {
                    returnType = (IType)elements[i];
                    break;
                }
                ++i;
            }
            if (nameTail != null) {
                return this.getTypeByName(returnType, nameTail);
            }
            return returnType;
        }
    }
}

