/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.types;

import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.types.Attribute;
import com.sap.ide.vi.types.ClassLoaderManager;
import com.sap.ide.vi.types.Method;
import com.sap.ide.vi.types.Parameter;
import com.sap.ide.vi.types.TypeAnalyser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;

public class TypeInClassPath
extends TypeAnalyser {
    private Class classToBeAnalysed;

    public TypeInClassPath(String projectName, String qualifiedType, int myCheckType) throws ClassNotFoundException, InadmissableTypeException {
        super(projectName);
        ClassLoader loader = ClassLoaderManager.getClassLoader(projectName);
        if (this.isJavaPrimitiveType(qualifiedType)) {
            qualifiedType = TypeAnalyser.getQualifiedTypeNameForPrimitiveType(qualifiedType);
        }
        this.classToBeAnalysed = loader.loadClass(qualifiedType);
        this.myCheckType = myCheckType;
    }

    public Class getClassToBeAnalysed() {
        return this.classToBeAnalysed;
    }

    public boolean isAbstract() {
        return Flags.isAbstract((int)this.classToBeAnalysed.getModifiers());
    }

    public boolean isInterface() {
        return this.classToBeAnalysed.isInterface();
    }

    protected boolean isForbidden() {
        return TypeAnalyser.forbiddenClasses.contains(this.classToBeAnalysed.getName());
    }

    public Vector getMethods() throws InadmissableTypeException {
        Vector<Method> resultVector = null;
        if (!this.classToBeAnalysed.isPrimitive()) {
            java.lang.reflect.Method[] methods = this.classToBeAnalysed.getDeclaredMethods();
            resultVector = methods.length > 0 ? new Vector(methods.length) : new Vector<Method>();
            int i = 0;
            while (i < methods.length) {
                String typeName;
                Class<?> compType;
                java.lang.reflect.Method method = methods[i];
                Parameter[] params = new Parameter[method.getParameterTypes().length];
                int j = 0;
                while (j < method.getParameterTypes().length) {
                    int parameterArrayDimension = 0;
                    if (method.getParameterTypes()[j].isArray()) {
                        compType = method.getParameterTypes()[j].getComponentType();
                        ++parameterArrayDimension;
                        while (compType.isArray()) {
                            compType = compType.getComponentType();
                            ++parameterArrayDimension;
                        }
                        typeName = compType.getName();
                    } else {
                        typeName = method.getParameterTypes()[j].getName();
                    }
                    params[j] = new Parameter("p" + new Integer(j).toString(), typeName, parameterArrayDimension, 0);
                    ++j;
                }
                int returnTypeArrayDimension = 0;
                if (method.getReturnType().isArray()) {
                    compType = method.getReturnType().getComponentType();
                    ++returnTypeArrayDimension;
                    while (compType.isArray()) {
                        compType = compType.getComponentType();
                        ++returnTypeArrayDimension;
                    }
                    typeName = compType.getName();
                } else {
                    typeName = method.getReturnType().getName();
                }
                resultVector.add(new Method(method.getName(), typeName, returnTypeArrayDimension, method.getModifiers(), params, this.classToBeAnalysed.getName()));
                ++i;
            }
        }
        return resultVector;
    }

    public Vector getAttributes() throws InadmissableTypeException {
        Vector<Attribute> resultVector = null;
        if (!this.classToBeAnalysed.isPrimitive()) {
            Field[] fields = this.classToBeAnalysed.getDeclaredFields();
            resultVector = new Vector<Attribute>();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (!Flags.isStatic((int)field.getModifiers()) || !Flags.isFinal((int)field.getModifiers())) {
                    String typeName;
                    int dimension = 0;
                    if (field.getType().isArray()) {
                        ++dimension;
                        Class<?> compType = field.getType().getComponentType();
                        while (compType.isArray()) {
                            compType = compType.getComponentType();
                            ++dimension;
                        }
                        typeName = compType.getName();
                    } else {
                        typeName = field.getType().getName();
                    }
                    resultVector.add(new Attribute(field.getName(), typeName, field.getModifiers(), dimension > 0, dimension, this.classToBeAnalysed.getName()));
                }
                ++i;
            }
        }
        return resultVector;
    }

    public String getAnalysedTypeName() {
        return this.classToBeAnalysed.getName();
    }

    public boolean parameterFullConstructorExisting() {
        if (this.classToBeAnalysed.getName().equals("java.lang.String")) {
            return true;
        }
        Constructor<?>[] constructors = this.classToBeAnalysed.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean parameterLessConstructorExisting() {
        if (this.classToBeAnalysed.getName().equals("java.lang.String")) {
            return true;
        }
        Constructor<?>[] constructors = this.classToBeAnalysed.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isJavaPrimitiveType() {
        return super.isJavaPrimitiveType(this.classToBeAnalysed.getName());
    }

    protected String getName() {
        return this.classToBeAnalysed.getName();
    }

    protected String getSuperClassName() {
        Class c = this.classToBeAnalysed.getSuperclass();
        if (c != null) {
            return c.getName();
        }
        return null;
    }

    public boolean equals(TypeAnalyser t) {
        if (t instanceof TypeInClassPath) {
            return this.classToBeAnalysed.getName().equals(((TypeInClassPath)t).getClassToBeAnalysed().getName());
        }
        return false;
    }

    public TypeAnalyser getInterfaceType(String interFaceName) throws InadmissableTypeException {
        Class<?>[] interfaces = this.classToBeAnalysed.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName().equals(interFaceName)) {
                return TypeAnalyser.getInstance(this.projectName, interFaceName, this.myCheckType);
            }
            ++i;
        }
        return null;
    }

    protected String[] getInterfaceNames() {
        Class<?>[] interfaces = this.classToBeAnalysed.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        int i = 0;
        while (i < interfaceNames.length) {
            interfaceNames[i] = interfaces[i].getName();
            ++i;
        }
        return interfaceNames;
    }
}

