/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.types;

import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.endpoints.TypeNotFoundException;
import com.sap.ide.vi.types.TypeCheckManager;
import com.sap.ide.vi.types.TypeInClassPath;
import com.sap.ide.vi.types.TypeInSourcePaths;
import com.sap.ide.vi.types.TypeKey;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jdt.core.JavaModelException;

public abstract class TypeAnalyser {
    private static Hashtable typeMappingTableForInputParameters = null;
    private static Hashtable typeMappingTableForOutputParameters = null;
    public static final String ARRAY_MARK = "[]";
    protected static final String ARRAY_STRING = "Array";
    public static final String TYPE_VOID = "void";
    private static Hashtable analysedTypes = new Hashtable();
    private static Hashtable primitiveTypes = null;
    public static HashSet forbiddenClasses = null;
    protected int myCheckType;
    protected String projectName = null;
    public static final int ENDPOINT_TYPE = 0;
    public static final int INNER_TYPE = 1;
    protected static final HashSet ALLOWEDMULTI_INTERFACES = new HashSet();
    static /* synthetic */ Class class$com$sap$ide$vi$types$TypeAnalyser;

    public static boolean onlyAllowedMultipleInterfaces(String[] interfaceNames, int maxAllowed) {
        int noneAllowedInterfaceCount = 0;
        if (interfaceNames.length > 0) {
            int i = 0;
            while (i < interfaceNames.length) {
                if (!ALLOWEDMULTI_INTERFACES.contains(interfaceNames[i]) && ++noneAllowedInterfaceCount > maxAllowed) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean onlyAllowedMultipleInterfacesForObjectExtenders(String[] interfaceNames) {
        return TypeAnalyser.onlyAllowedMultipleInterfaces(interfaceNames, 1);
    }

    public static boolean onlyAllowedMultipleInterfacesForNoneObjectExtenders(String[] interfaceNames) {
        return TypeAnalyser.onlyAllowedMultipleInterfaces(interfaceNames, 0);
    }

    private static boolean onlyAllowedMultipleInterfaces(Class[] interfaces, int maxAllowed) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < interfaces.length) {
            list.add(interfaces[i].getName());
            ++i;
        }
        return TypeAnalyser.onlyAllowedMultipleInterfaces(list.toArray(new String[list.size()]), maxAllowed);
    }

    private static void initialize() {
        if (forbiddenClasses == null) {
            forbiddenClasses = new HashSet();
            forbiddenClasses.add("java.rmi.RemoteException");
        }
        if (typeMappingTableForInputParameters == null) {
            typeMappingTableForInputParameters = new Hashtable();
            typeMappingTableForInputParameters.put("java.lang.String", new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double", "java.lang.String"});
            typeMappingTableForInputParameters.put("java.lang.Double", new String[]{"byte", "short", "int", "long", "float", "double"});
            typeMappingTableForInputParameters.put("java.lang.Float", new String[]{"byte", "short", "int", "float"});
            typeMappingTableForInputParameters.put("java.lang.Long", new String[]{"byte", "short", "int", "long"});
            typeMappingTableForInputParameters.put("java.lang.Integer", new String[]{"byte", "short", "int"});
            typeMappingTableForInputParameters.put("java.lang.Short", new String[]{"byte", "short"});
            typeMappingTableForInputParameters.put("java.lang.Character", new String[]{"byte", "char"});
            typeMappingTableForInputParameters.put("java.lang.Byte", new String[]{"byte"});
            typeMappingTableForInputParameters.put("java.lang.Boolean", new String[]{"boolean"});
            typeMappingTableForOutputParameters = new Hashtable();
            typeMappingTableForOutputParameters.put("java.lang.Boolean", new String[]{"boolean", "java.lang.String"});
            typeMappingTableForOutputParameters.put("java.lang.Byte", new String[]{"byte", "char", "short", "int", "long", "float", "double", "java.lang.String"});
            typeMappingTableForOutputParameters.put("java.lang.Character", new String[]{"short", "int", "long", "float", "double", "java.lang.String"});
            typeMappingTableForOutputParameters.put("java.lang.Short", new String[]{"short", "int", "long", "float", "double", "java.lang.String"});
            typeMappingTableForOutputParameters.put("java.lang.Integer", new String[]{"int", "long", "float", "double", "java.lang.String"});
            typeMappingTableForOutputParameters.put("java.lang.Long", new String[]{"long", "double", "java.lang.String"});
            typeMappingTableForOutputParameters.put("java.lang.Float", new String[]{"float", "double", "java.lang.String"});
            typeMappingTableForOutputParameters.put("java.lang.Double", new String[]{"double", "java.lang.String"});
            typeMappingTableForOutputParameters.put("java.lang.String", new String[]{"java.lang.String"});
        }
    }

    public static boolean checkValueForPrimitiveType(String value, String type) {
        if (value.length() == 0 || type.endsWith("String")) {
            return true;
        }
        type = TypeAnalyser.getQualifiedTypeNameForPrimitiveType(type);
        try {
            if (type.equals("java.lang.Boolean")) {
                return "true".equals(value) || "false".equals(value);
            }
            if (type.equals("java.lang.Byte")) {
                byte b = new Byte(value);
            } else {
                if (type.equals("java.lang.Character") && value.length() == 1) {
                    return true;
                }
                if (type.equals("java.lang.Short")) {
                    short s = new Short(value);
                } else if (type.equals("java.lang.Integer")) {
                    int i = new Integer(value);
                } else if (type.equals("java.lang.Long")) {
                    long l = new Long(value);
                } else if (type.equals("java.lang.Float")) {
                    float f = new Float(value).floatValue();
                } else if (type.equals("java.lang.Double")) {
                    double d = new Double(value);
                }
            }
            return true;
        }
        catch (Exception e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$types$TypeAnalyser == null ? (class$com$sap$ide$vi$types$TypeAnalyser = TypeAnalyser.class$("com.sap.ide.vi.types.TypeAnalyser")) : class$com$sap$ide$vi$types$TypeAnalyser));
            return false;
        }
    }

    protected abstract boolean isForbidden();

    public boolean isForbidden(boolean withInheritance) throws InadmissableTypeException {
        if (this.isForbidden()) {
            return true;
        }
        if (withInheritance) {
            TypeAnalyser father = this.getParentType();
            if (father == null) {
                return false;
            }
            return father.isForbidden(withInheritance);
        }
        return false;
    }

    public static boolean isTableType(String typeName) {
        return typeName.endsWith(ARRAY_MARK);
    }

    public static boolean isVoidType(String typeName) {
        return typeName.equals(TYPE_VOID);
    }

    public static String getLineType(String typeName) {
        if (typeName.endsWith(ARRAY_MARK)) {
            return typeName.substring(0, typeName.length() - ARRAY_MARK.length());
        }
        return typeName;
    }

    public static boolean isConvertableType(String type) {
        if (TypeAnalyser.isVoidType(type)) {
            return false;
        }
        return TypeAnalyser.getPossibleMapTypesForConvertableType(type, true) != null;
    }

    public static String[] getPossibleMapTypesForConvertableType(String type, boolean importParameter) {
        TypeAnalyser.fillPrimitiveTypes();
        if (primitiveTypes.get(type) != null) {
            type = (String)primitiveTypes.get(type);
        }
        if (TypeAnalyser.isTableType(type)) {
            String[] tempResults = TypeAnalyser.getPossibleMapTypesForConvertableType(TypeAnalyser.getLineType(type), importParameter);
            if (tempResults == null) {
                return null;
            }
            String[] results = new String[tempResults.length];
            int i = 0;
            while (i < tempResults.length) {
                results[i] = tempResults[i] + ARRAY_MARK;
                ++i;
            }
            return results;
        }
        if (importParameter) {
            return (String[])typeMappingTableForInputParameters.get(type);
        }
        return (String[])typeMappingTableForOutputParameters.get(type);
    }

    public TypeAnalyser(String projectName) {
        this.projectName = projectName;
    }

    public static void clearAnalysedTypes() {
        analysedTypes.clear();
    }

    public static TypeAnalyser getInstance(String projectName, String qualifiedType, int checkType) throws InadmissableTypeException {
        if (TypeAnalyser.isTableType(qualifiedType)) {
            return null;
        }
        TypeAnalyser.fillPrimitiveTypes();
        TypeAnalyser result = (TypeAnalyser)analysedTypes.get(new TypeKey(projectName, qualifiedType));
        if (result == null) {
            try {
                result = new TypeInClassPath(projectName, qualifiedType, checkType);
            }
            catch (ClassNotFoundException e) {
                try {
                    result = new TypeInSourcePaths(projectName, qualifiedType, checkType);
                }
                catch (JavaModelException ex) {
                    result = null;
                }
                catch (TypeNotFoundException ex) {
                    result = null;
                }
            }
            if (result != null) {
                if (checkType == 1) {
                    TypeCheckManager.getProjectRelevantInnerTypeCheck(projectName).checkType(result);
                } else {
                    TypeCheckManager.getEndpointTypeCheck(projectName).checkType(result);
                }
                analysedTypes.put(new TypeKey(projectName, qualifiedType), result);
            }
        }
        return result;
    }

    public boolean isDefaultInitialApplicable() {
        return this.parameterLessConstructorExisting();
    }

    public boolean isDefaultValueApplicable() {
        return this.isJavaPrimitiveType();
    }

    protected abstract String getName();

    public abstract boolean isJavaPrimitiveType();

    public abstract String getAnalysedTypeName();

    public abstract TypeAnalyser getInterfaceType(String var1) throws InadmissableTypeException;

    protected abstract String[] getInterfaceNames();

    protected abstract String getSuperClassName();

    public TypeAnalyser[] getInterfaceTypes() throws InadmissableTypeException {
        String[] interfaceNames = this.getInterfaceNames();
        TypeAnalyser[] returns = new TypeAnalyser[interfaceNames.length];
        int i = 0;
        while (i < interfaceNames.length) {
            returns[i] = this.getInterfaceType(interfaceNames[i]);
            ++i;
        }
        return returns;
    }

    protected boolean isImplemented(TypeAnalyser type, String specialInterface) throws InadmissableTypeException {
        while (type.getSuperClassName() != null && type.getAnalysedTypeName() != null && !type.getAnalysedTypeName().equals("java.lang.Object")) {
            if (type.getAnalysedTypeName().equals(specialInterface)) {
                return true;
            }
            if (type == null) {
                return false;
            }
            String[] interfaceNames = type.getInterfaceNames();
            int i = 0;
            while (i < interfaceNames.length) {
                if (this.isImplementedViaExtension(TypeAnalyser.getInstance(type.projectName, interfaceNames[i], this.myCheckType), specialInterface)) {
                    return true;
                }
                ++i;
            }
            type = TypeAnalyser.getInstance(type.projectName, type.getSuperClassName(), type.getMyCheckType());
        }
        return false;
    }

    private boolean isImplementedViaExtension(TypeAnalyser type, String specialInterface) throws InadmissableTypeException {
        if (type.getAnalysedTypeName().equals(specialInterface)) {
            return true;
        }
        if (type != null) {
            String[] interfaceNames = type.getInterfaceNames();
            int i = 0;
            while (i < interfaceNames.length) {
                if (this.isImplementedViaExtension(TypeAnalyser.getInstance(type.projectName, interfaceNames[i], this.myCheckType), specialInterface)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public abstract boolean equals(TypeAnalyser var1);

    public TypeAnalyser getParentType() throws InadmissableTypeException {
        String resultTypeName = null;
        String superClassName = this.getSuperClassName();
        String[] interfaceNames = this.getInterfaceNames();
        boolean isInterface = this.isInterface();
        if (isInterface || superClassName.equals("java.lang.Object")) {
            int i = 0;
            while (i < interfaceNames.length) {
                if (!ALLOWEDMULTI_INTERFACES.contains(interfaceNames[i])) {
                    resultTypeName = interfaceNames[i];
                }
                ++i;
            }
            if (resultTypeName == null && interfaceNames.length > 0) {
                resultTypeName = "java.io.Serializable";
            }
        } else {
            resultTypeName = superClassName;
        }
        if (resultTypeName == null) {
            return null;
        }
        return TypeAnalyser.getInstance(this.projectName, resultTypeName, this.myCheckType);
    }

    protected boolean isJavaPrimitiveType(String typeName) {
        return primitiveTypes.get(typeName) != null;
    }

    protected static String getQualifiedTypeNameForPrimitiveType(String typeName) {
        return (String)primitiveTypes.get(typeName);
    }

    public static String getPrimitiveTypeForQualifiedType(String typeName) {
        if (typeName.startsWith("java.lang.")) {
            if (TypeAnalyser.isTableType(typeName)) {
                return TypeAnalyser.getPrimitiveTypeForQualifiedType(TypeAnalyser.getLineType(typeName)) + ARRAY_MARK;
            }
            Enumeration enumeration = primitiveTypes.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!primitiveTypes.get(key).equals(typeName) || key.equals(primitiveTypes.get(key))) continue;
                return key;
            }
            return "";
        }
        return typeName;
    }

    private static void fillPrimitiveTypes() {
        if (primitiveTypes == null) {
            primitiveTypes = new Hashtable(19);
            primitiveTypes.put("boolean", "java.lang.Boolean");
            primitiveTypes.put("java.lang.Boolean", "java.lang.Boolean");
            primitiveTypes.put("byte", "java.lang.Byte");
            primitiveTypes.put("java.lang.Byte", "java.lang.Byte");
            primitiveTypes.put("char", "java.lang.Character");
            primitiveTypes.put("java.lang.Character", "java.lang.Character");
            primitiveTypes.put("double", "java.lang.Double");
            primitiveTypes.put("java.lang.Double", "java.lang.Double");
            primitiveTypes.put("float", "java.lang.Float");
            primitiveTypes.put("java.lang.Float", "java.lang.Float");
            primitiveTypes.put("int", "java.lang.Integer");
            primitiveTypes.put("java.lang.Integer", "java.lang.Integer");
            primitiveTypes.put("java.lang.String", "java.lang.String");
            primitiveTypes.put("long", "java.lang.Long");
            primitiveTypes.put("java.lang.Long", "java.lang.Long");
            primitiveTypes.put("Object", "java.lang.Object");
            primitiveTypes.put("java.lang.Object", "java.lang.Object");
            primitiveTypes.put("short", "java.lang.Short");
            primitiveTypes.put("java.lang.Short", "java.lang.Short");
        }
    }

    public abstract Vector getAttributes() throws InadmissableTypeException;

    public abstract Vector getMethods() throws InadmissableTypeException;

    public abstract boolean parameterLessConstructorExisting();

    public abstract boolean parameterFullConstructorExisting();

    public abstract boolean isAbstract();

    public abstract boolean isInterface();

    public boolean isExceptionType() throws InadmissableTypeException {
        if (this.getName().equals("java.lang.Object")) {
            return false;
        }
        if (this.getName().equals("java.lang.Throwable")) {
            return true;
        }
        TypeAnalyser parentType = this.getParentType();
        if (parentType != null) {
            return parentType.isExceptionType();
        }
        return false;
    }

    public int getMyCheckType() {
        return this.myCheckType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ALLOWEDMULTI_INTERFACES.add("java.lang.Cloneable");
        ALLOWEDMULTI_INTERFACES.add("java.io.Serializable");
        ALLOWEDMULTI_INTERFACES.add("java.lang.Comparable");
        TypeAnalyser.initialize();
    }
}

