/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.types;

import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class MethodAttributes {
    boolean toBeContained;
    boolean toBeContainedOriginally;
    IMethod method;
    String internalMethodName;
    String methodNameWithSignature;
    String methodNameWithSignatureAndReturnType;
    boolean isOverloaded;
    IType type;
    private InadmissableTypeException forbiddenReason;

    public MethodAttributes(boolean toBeContained, IMethod method, IType type) {
        this.toBeContained = toBeContained;
        this.method = method;
        this.type = type;
        String methodName = method.getElementName();
        this.methodNameWithSignature = ViBasics.getMappedMethodName(type, method);
        this.methodNameWithSignatureAndReturnType = ViBasics.getMethodNameWithSignature(type, method);
        try {
            this.isOverloaded = this.isOverloaded(type.getMethods(), method);
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, this.getClass());
        }
        this.internalMethodName = this.isOverloaded ? this.convertToJaxRpcName() : methodName;
    }

    private String convertToJaxRpcName() {
        String jaxRpcName = null;
        jaxRpcName = this.methodNameWithSignature.replace('(', '_');
        jaxRpcName = jaxRpcName.replace('.', '_');
        jaxRpcName = jaxRpcName.replace(',', '_');
        jaxRpcName = jaxRpcName.replace(')', ' ');
        jaxRpcName = jaxRpcName.trim();
        char[] chars = jaxRpcName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '_') {
                chars[i + 1] = new String(new char[]{chars[i + 1]}).toUpperCase().toCharArray()[0];
            }
            ++i;
        }
        jaxRpcName = new String(chars);
        while (jaxRpcName.indexOf(95) > -1) {
            String start = jaxRpcName.substring(0, jaxRpcName.indexOf(95));
            String end = jaxRpcName.substring(jaxRpcName.indexOf(95) + 1, jaxRpcName.length());
            jaxRpcName = start + end;
        }
        return jaxRpcName;
    }

    public InadmissableTypeException getForbiddenReason() {
        return this.forbiddenReason;
    }

    public void setForbidden(InadmissableTypeException reason) {
        this.forbiddenReason = reason;
    }

    public void setToBeContained(boolean checked) {
        this.toBeContained = checked;
    }

    public void setToBeContainedOriginally(boolean checked) {
        this.toBeContainedOriginally = checked;
        this.setToBeContained(checked);
    }

    public IMethod getMethod() {
        return this.method;
    }

    public IType getType() {
        return this.type;
    }

    public String getName() {
        return this.internalMethodName;
    }

    public String getNameWithSignature() {
        return this.methodNameWithSignature;
    }

    public String getNameWithSignatureAndReturnType() {
        return this.methodNameWithSignatureAndReturnType;
    }

    public boolean isOverloaded() {
        return this.isOverloaded;
    }

    public boolean isToBeContained() {
        return this.toBeContained;
    }

    public boolean isToBeContainedOriginally() {
        return this.toBeContainedOriginally;
    }

    public boolean isForbidden() {
        return this.forbiddenReason != null;
    }

    private boolean isOverloaded(IMethod[] methods, IMethod method) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i] != method && methods[i].getElementName().equals(method.getElementName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

