/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.types;

import com.sap.ide.ws.core.plugin.WebServiceCorePlugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ClassLoaderManager
implements IResourceChangeListener {
    private static final String FILE_PREFIX = "file:";
    private static ClassLoaderManager mInstance;
    private static Hashtable classLoaderCache;
    private static HashMap projectNamesConsidered;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResourceDelta;
    static /* synthetic */ Class class$com$sap$ide$vi$types$TypeInClassPath;

    private ClassLoaderManager() {
    }

    static ClassLoader getClassLoader(String projectName) {
        if (mInstance == null) {
            mInstance = new ClassLoaderManager();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)mInstance);
        }
        if (classLoaderCache.containsKey(projectName)) {
            return (ClassLoader)classLoaderCache.get(projectName);
        }
        URL[] urls = ClassLoaderManager.getClpUrlsForProject(projectName);
        URLClassLoader loader = new URLClassLoader(urls);
        classLoaderCache.put(projectName, loader);
        return loader;
    }

    private static void resetProject(String projectName) {
        classLoaderCache.remove(projectName);
    }

    private static void reset() {
        classLoaderCache = new Hashtable();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event != null && event.getDelta() != null) {
            IResourceDelta[] children = event.getDelta().getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                ResourceDelta rDelta = (ResourceDelta)children[i].getAdapter(class$org$eclipse$core$resources$IResourceDelta == null ? ClassLoaderManager.class$("org.eclipse.core.resources.IResourceDelta") : class$org$eclipse$core$resources$IResourceDelta);
                if (rDelta.getResource() != null && rDelta.getResource() instanceof IProject) {
                    if (classLoaderCache.containsKey(rDelta.getResource().getName())) {
                        ClassLoaderManager.resetProject(rDelta.getResource().getName());
                    } else if (projectNamesConsidered.containsKey(rDelta.getResource().getName())) {
                        ClassLoaderManager.reset();
                    }
                }
                ++i;
            }
        }
    }

    private static URL[] getClpUrlsForProject(String projectName) {
        if (projectName == null) {
            return new URL[0];
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ArrayList<URL> clpEntryPaths = new ArrayList<URL>();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] clpEntries = javaProject.getRawClasspath();
            int i = 0;
            while (i < clpEntries.length) {
                IClasspathEntry clpEntry;
                if (clpEntries[i].getEntryKind() == 2) {
                    URL[] urls = ClassLoaderManager.getClpUrlsForProject(clpEntries[i].getPath().toOSString());
                    projectNamesConsidered.put(clpEntries[i].getPath().toOSString(), urls);
                    int j = 0;
                    while (j < urls.length) {
                        clpEntryPaths.add(urls[j]);
                        ++j;
                    }
                }
                if (clpEntries[i].getEntryKind() == 1) {
                    if (clpEntries[i].getPath().getDevice() == null) {
                        clpEntryPaths.add(new URL(FILE_PREFIX + javaProject.getProject().getLocation().removeLastSegments(1).toOSString() + clpEntries[i].getPath().toOSString()));
                    } else {
                        clpEntryPaths.add(new URL(FILE_PREFIX + JavaCore.getResolvedClasspathEntry((IClasspathEntry)clpEntries[i]).getPath().toOSString()));
                    }
                }
                if (clpEntries[i].getEntryKind() == 4 && (clpEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)clpEntries[i])) != null) {
                    clpEntryPaths.add(new URL(FILE_PREFIX + clpEntry.getPath().toOSString()));
                }
                if (clpEntries[i].getEntryKind() == 5 && (clpEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)clpEntries[i])) != null) {
                    clpEntryPaths.add(new URL(FILE_PREFIX + clpEntry.getPath().toOSString()));
                }
                if (clpEntries[i].getEntryKind() == 3 && (clpEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)clpEntries[i])) != null) {
                    String outputPath = clpEntry.getOutputLocation() == null ? javaProject.getOutputLocation().makeAbsolute().toOSString() : clpEntry.getOutputLocation().makeAbsolute().toOSString();
                    if (outputPath.startsWith(File.separator)) {
                        outputPath = outputPath.substring(1);
                    }
                    String projectPath = project.getLocation().toOSString();
                    projectPath = outputPath.indexOf(File.separatorChar) > -1 ? FILE_PREFIX + projectPath + outputPath.substring(outputPath.indexOf(File.separatorChar)) + File.separator : FILE_PREFIX + projectPath + File.separator;
                    clpEntryPaths.add(new URL(projectPath));
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$types$TypeInClassPath == null ? (class$com$sap$ide$vi$types$TypeInClassPath = ClassLoaderManager.class$("com.sap.ide.vi.types.TypeInClassPath")) : class$com$sap$ide$vi$types$TypeInClassPath));
        }
        catch (MalformedURLException e) {
            WebServiceCorePlugin.logError((Throwable)e, (Class)(class$com$sap$ide$vi$types$TypeInClassPath == null ? (class$com$sap$ide$vi$types$TypeInClassPath = ClassLoaderManager.class$("com.sap.ide.vi.types.TypeInClassPath")) : class$com$sap$ide$vi$types$TypeInClassPath));
        }
        return clpEntryPaths.toArray(new URL[clpEntryPaths.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classLoaderCache = new Hashtable();
        projectNamesConsidered = new HashMap();
    }
}

