/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.vi.types;

import com.sap.ide.vi.check.ViBasics;
import com.sap.ide.vi.endpoints.InadmissableTypeException;
import com.sap.ide.vi.endpoints.InheritanceAndImplementationExecption;
import com.sap.ide.vi.endpoints.MultipleImplementationException;
import com.sap.ide.vi.endpoints.NotSupportedJavaTypeException;
import com.sap.ide.vi.endpoints.RemoteObjectException;
import com.sap.ide.vi.endpoints.SerializableNotImplementedException;
import com.sap.ide.vi.types.ITypeCheck;
import com.sap.ide.vi.types.TypeAnalyser;

public abstract class AbstractTypeCheck
implements ITypeCheck {
    public boolean checkAllowedJavaType(TypeAnalyser type) throws InadmissableTypeException {
        if (type.getAnalysedTypeName().startsWith("java.")) {
            if (!ViBasics.isAllowedJavaType(type.getAnalysedTypeName())) {
                throw new NotSupportedJavaTypeException(type.getAnalysedTypeName());
            }
            return true;
        }
        return false;
    }

    public void checkSerializableImplemented(TypeAnalyser type) throws InadmissableTypeException {
        if (!(this.checkAllowedJavaType(type) || type.isInterface() || type.isAbstract() || type.isImplemented(type, "java.io.Serializable"))) {
            throw new SerializableNotImplementedException(type.getName());
        }
    }

    public void checkRemoteImplemented(TypeAnalyser type) throws InadmissableTypeException {
        if (!this.checkAllowedJavaType(type) && type.isImplemented(type, "java.rmi.Remote")) {
            throw new RemoteObjectException(type.getAnalysedTypeName());
        }
    }

    public void checkSuperInterfaces(TypeAnalyser type) throws InadmissableTypeException {
        if (!this.checkAllowedJavaType(type) && type.getSuperClassName() != null && type.getInterfaceNames().length > 0) {
            if (!type.getSuperClassName().equals("java.lang.Object") && !type.isExceptionType()) {
                if (!TypeAnalyser.onlyAllowedMultipleInterfacesForNoneObjectExtenders(type.getInterfaceNames())) {
                    throw new InheritanceAndImplementationExecption(type.getAnalysedTypeName(), type.getSuperClassName(), type.getInterfaceNames()[0]);
                }
            } else if (!TypeAnalyser.onlyAllowedMultipleInterfacesForObjectExtenders(type.getInterfaceNames())) {
                throw new MultipleImplementationException(type.getAnalysedTypeName(), type.getInterfaceNames()[0], type.getInterfaceNames()[1]);
            }
        }
    }

    public abstract void checkType(TypeAnalyser var1) throws InadmissableTypeException;
}

